/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.handlers.traceability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.transition.common.handlers.session.SessionHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.LinkTraceabilityHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class SIDTraceabilityHandler
extends LinkTraceabilityHandler {
    public static final EAttribute PROPERTY_SID = ModellingcorePackage.Literals.MODEL_ELEMENT__SID;

    public EAttribute getAttribute(IContext context_p) {
        return PROPERTY_SID;
    }

    public SIDTraceabilityHandler(String identifier_p) {
        super(identifier_p);
    }

    protected List<EObject> getSourceAttachments(EObject targetElement_p, IContext context_p) {
        ArrayList<EObject> elements = new ArrayList<EObject>();
        EObject result = null;
        if (targetElement_p instanceof CapellaElement) {
            for (String id : this.getSourceIds(targetElement_p, context_p)) {
                result = SessionHandlerHelper.getInstance((IContext)context_p).getEObjectFromId(id, context_p);
                if (result == null) continue;
                elements.add(result);
            }
        }
        return elements;
    }

    protected void fixIssue56FunctionalChainInvolvmentLinkId(FunctionalChainInvolvementLink link) {
        FunctionalExchange exchange;
        if (link.getInvolved() instanceof FunctionalExchange && (exchange = (FunctionalExchange)link.getInvolved()).getSid() != null && exchange.getSid().startsWith("ID_FakeFunctionalExchange") && link.getSid() != null && link.getSid().startsWith("ID_FakeFunctionalChainInvolvement") && !link.getSid().equals(link.getId())) {
            link.setId(link.getSid());
        }
    }

    protected List<String> getSourceIds(EObject targetElement_p, IContext context_p) {
        ArrayList<String> ids = new ArrayList<String>();
        if (targetElement_p instanceof CapellaElement) {
            String[] values;
            String propertyValue;
            EAttribute attribute = this.getAttribute(context_p);
            if (targetElement_p instanceof FunctionalChainInvolvementLink) {
                this.fixIssue56FunctionalChainInvolvmentLinkId((FunctionalChainInvolvementLink)targetElement_p);
            }
            propertyValue = (propertyValue = (String)targetElement_p.eGet((EStructuralFeature)attribute)) == null ? "" : propertyValue;
            String[] stringArray = values = propertyValue.split(";");
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (value != null && value.length() > 0) {
                    ids.add(value);
                }
                ++n2;
            }
        }
        return ids;
    }

    public void attachTraceability(EObject sourceElement_p, EObject targetElement_p, IContext context_p) {
        EAttribute attribute = this.getAttribute(context_p);
        if (targetElement_p != null && targetElement_p.eClass().getEAllAttributes().contains((Object)attribute)) {
            this.createAttachment(sourceElement_p, targetElement_p, context_p);
        }
    }

    protected void createAttachment(EObject sourceElement_p, EObject targetElement_p, final IContext context_p) {
        List<String> ids;
        EAttribute attribute = this.getAttribute(context_p);
        ArrayList<String> values = new ArrayList<String>();
        String propertyValue = (String)targetElement_p.eGet((EStructuralFeature)attribute);
        if (propertyValue != null && propertyValue.length() > 0) {
            values.addAll(Arrays.asList(propertyValue.split(";")));
        }
        if ((ids = this.getSourceIds(sourceElement_p, context_p)).size() == 0) {
            String id = SessionHandlerHelper.getInstance((IContext)context_p).getId(sourceElement_p, context_p);
            ids.add(id);
            if (sourceElement_p.eGet((EStructuralFeature)attribute) == null) {
                sourceElement_p.eSet((EStructuralFeature)attribute, (Object)id);
            }
        }
        this.addMappings(sourceElement_p, targetElement_p, context_p);
        for (String id : ids) {
            if (!values.contains(id)) {
                values.add(id);
                continue;
            }
            return;
        }
        values.sort(new Comparator<String>(){

            @Override
            public int compare(String id1, String id2) {
                Object obj;
                EObject eObjectFromId1 = SessionHandlerHelper.getInstance((IContext)context_p).getEObjectFromId(id1, context_p);
                EObject eObjectFromId2 = SessionHandlerHelper.getInstance((IContext)context_p).getEObjectFromId(id2, context_p);
                if (eObjectFromId1.eContainer() != null && eObjectFromId2.eContainer() != null && eObjectFromId1.eContainer() == eObjectFromId2.eContainer() && (obj = eObjectFromId1.eContainer().eGet((EStructuralFeature)eObjectFromId1.eContainmentFeature())) instanceof List) {
                    return ((List)obj).indexOf(eObjectFromId1) < ((List)obj).indexOf(eObjectFromId2) ? -1 : 1;
                }
                return 0;
            }
        });
        String result = "";
        int i = 0;
        for (String value : values) {
            if (value == null || value.length() <= 0) continue;
            result = String.valueOf(result) + value;
            if (++i >= values.size()) continue;
            result = String.valueOf(result) + ";";
        }
        targetElement_p.eSet((EStructuralFeature)attribute, (Object)result);
    }
}

