/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.sirius.util.diagram;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.common.tools.api.util.FileUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Display;
import org.polarsys.kitalpha.doc.gen.business.core.Activator;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.diagram.GenDocDiagramExportAction;
import org.polarsys.kitalpha.doc.gen.business.core.util.DocGenHtmlUtil;

public class DiagramExport {
    private static final String JPG = "JPG";
    private final NullProgressMonitor NULL_PROGRESS_MONITOR = new NullProgressMonitor();
    private IPath outputPath;
    private DDiagram diagram;
    private Session session;
    private IProject project;

    public DiagramExport(IPath outputPath, DDiagram diagram, Session session) {
        this.initDiagramExport(outputPath, diagram, session);
    }

    public DiagramExport(String projectName, IPath outputPath, DDiagram diagram, Session session) {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.refreshProject();
        this.initDiagramExport(outputPath, diagram, session);
    }

    private void refreshProject() {
        if (this.project != null && this.project.exists()) {
            try {
                this.project.refreshLocal(2, (IProgressMonitor)this.NULL_PROGRESS_MONITOR);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void initDiagramExport(IPath outputPath, DDiagram diagram, Session session) {
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(outputPath);
        if (folder != null && !folder.exists()) {
            try {
                folder.create(true, true, (IProgressMonitor)this.NULL_PROGRESS_MONITOR);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        this.outputPath = folder.getLocation();
        this.diagram = diagram;
        this.session = session;
    }

    public IFile exportAsImage() {
        ArrayList<IFile> result = new ArrayList<IFile>();
        Resource airdResource = this.session.getSessionResource();
        URI airdURI = airdResource.getURI();
        if (airdURI != null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    GenDocDiagramExportAction exportAction = new GenDocDiagramExportAction(DiagramExport.this.session, DiagramExport.this.getRepresentationsToExportAsImage(), DiagramExport.this.outputPath, ImageFileFormat.JPG, false);
                    try {
                        exportAction.run((IProgressMonitor)DiagramExport.this.NULL_PROGRESS_MONITOR);
                    }
                    catch (InterruptedException e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.doc.gen.business.core", "An error occured during export action", (Throwable)e));
                    }
                    catch (Exception e) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.kitalpha.doc.gen.business.core", "An error occured during export action", (Throwable)e));
                    }
                }
            });
            result.add(this.getGeneratedDiagram());
        }
        if (result.size() > 0) {
            return (IFile)result.get(0);
        }
        return null;
    }

    private IFile getGeneratedDiagram() {
        IFile iFile;
        String representaionName = DocGenHtmlUtil.getValidFileName(this.diagram.getName());
        FileUtil obeoDSLFileUtil = new FileUtil(representaionName);
        String expectedFileName = obeoDSLFileUtil.isValid() ? String.valueOf(representaionName) + "." + JPG.toLowerCase() : String.valueOf(obeoDSLFileUtil.getValidFilename()) + "." + JPG.toLowerCase();
        IFolder folder = (IFolder)ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation(this.outputPath);
        if (folder == null) {
            this.refreshProject();
            folder = (IFolder)ResourcesPlugin.getWorkspace().getRoot().findContainersForLocation(this.outputPath)[0];
        }
        if ((iFile = folder.getFile(expectedFileName)).exists()) {
            return iFile;
        }
        IPath filePath = this.outputPath.append(expectedFileName);
        IFile iLinkedFile = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(filePath)[0];
        if (iLinkedFile != null && iLinkedFile.exists()) {
            return iLinkedFile;
        }
        return null;
    }

    @Deprecated
    private Map<URI, List<DRepresentation>> getRepresentationsPerFile(URI airdUri) {
        HashMap<URI, List<DRepresentation>> representationsPerFile = new HashMap<URI, List<DRepresentation>>();
        ArrayList<DDiagram> list = new ArrayList<DDiagram>();
        list.add(this.diagram);
        representationsPerFile.put(airdUri, list);
        return representationsPerFile;
    }

    private List<DRepresentation> getRepresentationsToExportAsImage() {
        ArrayList<DRepresentation> list = new ArrayList<DRepresentation>();
        list.add((DRepresentation)this.diagram);
        return list;
    }
}

