/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.polarsys.kitalpha.doc.gen.business.core.Activator;
import org.polarsys.kitalpha.doc.gen.business.core.util.DocGenHtmlUtil;
import org.polarsys.kitalpha.doc.gen.business.core.util.EscapeChars;

public class IndexingConceptsTask
implements ITaskProduction {
    private static final String LOG_PROPERTY = "org.polarsys.kitalpha.doc.gen.business.core.task.IndexingConceptsTask.log";
    private static final boolean doTrace = IndexingConceptsTask.isLogFeatureSetted();
    private static final Logger logger = Logger.getLogger(IndexingConceptsTask.class.getName());
    private static final String INDEXING_PREF = "[INDEXING] ";
    private Map<String, List<String>> conceptsToPageTitle = new HashMap<String, List<String>>();
    private Map<String, List<String>> conceptsToPageParagraph = new HashMap<String, List<String>>();
    private Map<String, List<String>> conceptsToPageList = new HashMap<String, List<String>>();
    private Map<String, List<String>> conceptsToPageTable = new HashMap<String, List<String>>();
    private Map<String, String> fileNameToTitle = new HashMap<String, String>();
    private static final Pattern pTable = Pattern.compile("<table>(.*?)</table>");
    private static final Pattern pTitle = Pattern.compile(".*<title>(.*)</title>.*");
    private static final Pattern pHeaderOne = Pattern.compile("<h1>(.*)</h1>");
    private static final Pattern pParagraphe = Pattern.compile("<p>(.*?)</p>");
    private static final Pattern pListStartEnd = Pattern.compile("((<ul.*?>)|(</ul>))", 32);
    private static Matcher mTable = pTable.matcher("");
    private static Matcher mTitle = pTitle.matcher("");
    private static Matcher mPHeaderOne = pHeaderOne.matcher("");
    private static Matcher mParagraphe = pParagraphe.matcher("");
    private static Matcher mListStartEnd = pListStartEnd.matcher("");
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\"><head><meta http-equiv=\"content-type\" content=\"text/html;charset=ISO-8859-1\" /><meta http-equiv=\"Content-Style-Type\" content=\"text/css\" /><title>Index</title>\t\t<link title=\"default\" rel=\"stylesheet\" type=\"text/css\" media=\"screen, projection\" href=\"../../../css/content.css\"></link></head><body><div id=\"content\">";
    private static final String FOOTER = "</div></body></html>";

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    public boolean isFileAModelHtmlPage(String fileName) {
        return !fileName.equals("footer.html") && !fileName.equals("header.html") && !fileName.equals("index.html") && !fileName.equals("searchIndex.html") && !fileName.equals("sidebar.html");
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String projectName = (String)productionContext.getInputValue((Object)"projectName", String.class);
        String outputFolder = (String)productionContext.getInputValue((Object)"outputFolder", String.class);
        List<String> concepts = (List<String>)productionContext.getInputValue((Object)"concepts", List.class);
        if (doTrace) {
            logger.info("[INDEXING] Start indexing at: " + Calendar.getInstance().get(12));
            logger.info("[INDEXING] Project: " + projectName);
            logger.info("[INDEXING] Output folder: " + outputFolder);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        IFolder folder = project.getFolder((IPath)new Path(outputFolder));
        try {
            IResource[] content;
            IResource[] iResourceArray = content = folder.members();
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                IResource currentResource = iResourceArray[n2];
                if (currentResource instanceof IFile && (file = (IFile)currentResource).getName().endsWith(".html") && this.isFileAModelHtmlPage(file.getName())) {
                    if (doTrace) {
                        logger.info("[INDEXING] Starting indexing page: " + file.getName());
                    }
                    this.indexPage(concepts, file);
                    if (doTrace) {
                        logger.info("[INDEXING] Ending indexing page: " + file.getName());
                    }
                }
                ++n2;
            }
            concepts = this.removeConceptsWithEmptyPages(concepts);
            productionContext.setOutputValue((Object)"concepts.with.pages", concepts);
            if (doTrace) {
                logger.info("[INDEXING] Starting generating index pages");
            }
            this.generatingConceptsPages(projectName, outputFolder, concepts);
            if (doTrace) {
                logger.info("[INDEXING] End generating index pages");
            }
        }
        catch (CoreException e) {
            Status status = new Status(4, "org.polarsys.kitalpha.doc.gen.business.core", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    public List<String> removeConceptsWithEmptyPages(List<String> concepts) {
        ArrayList<String> conceptsToRemove = new ArrayList<String>();
        for (String currentConcept : concepts) {
            boolean noPage = true;
            List<String> inPages = this.conceptsToPageTitle.get(currentConcept);
            noPage = inPages == null || inPages != null && inPages.isEmpty();
            boolean noPageParagraph = true;
            List<String> inPageParagraph = this.conceptsToPageParagraph.get(currentConcept);
            noPageParagraph = inPageParagraph == null || inPageParagraph != null && inPageParagraph.isEmpty();
            boolean noPageList = true;
            List<String> inList = this.conceptsToPageList.get(currentConcept);
            noPageList = inList == null || inList != null && inList.isEmpty();
            boolean noPageTable = true;
            List<String> inTable = this.conceptsToPageTable.get(currentConcept);
            boolean bl = noPageTable = inTable == null || inTable != null && inTable.isEmpty();
            if (!noPage || !noPageParagraph || !noPageList || !noPageTable) continue;
            conceptsToRemove.add(currentConcept);
        }
        if (!conceptsToRemove.isEmpty()) {
            concepts.removeAll(conceptsToRemove);
        }
        return concepts;
    }

    private void generatingConceptsPages(String projectName, String outputFolder, List<String> concepts) {
        int i = 0;
        for (String currentConcept : concepts) {
            ++i;
            StringBuffer buffer = new StringBuffer();
            buffer.append(HEADER);
            buffer.append("<h1>" + currentConcept + "</h1>");
            List<String> currentConceptPages = this.conceptsToPageTitle.get(currentConcept);
            if (currentConceptPages != null) {
                buffer.append("<h2>Concept referenced in title</h2>");
                buffer.append("<ul>");
                for (String fileName : this.conceptsToPageTitle.get(currentConcept)) {
                    buffer.append("<li>");
                    buffer.append("<a href=\"../" + fileName + "\">" + this.fileNameToTitle.get(fileName) + "</a>");
                    buffer.append("</li>");
                }
                buffer.append("</ul>");
            }
            if ((currentConceptPages = this.conceptsToPageParagraph.get(currentConcept)) != null) {
                buffer.append("<h2>Concept referenced in paraphraph</h2>");
                buffer.append("<ul>");
                for (String fileName : this.conceptsToPageParagraph.get(currentConcept)) {
                    buffer.append("<li>");
                    buffer.append("<a href=\"../" + fileName + "\">" + this.fileNameToTitle.get(fileName) + "</a>");
                    buffer.append("</li>");
                }
                buffer.append("</ul>");
            }
            if ((currentConceptPages = this.conceptsToPageList.get(currentConcept)) != null) {
                buffer.append("<h2>Concept referenced in list</h2>");
                buffer.append("<ul>");
                for (String fileName : currentConceptPages) {
                    buffer.append("<li>");
                    buffer.append("<a href=\"../" + fileName + "\">" + this.fileNameToTitle.get(fileName) + "</a>");
                    buffer.append("</li>");
                }
                buffer.append("</ul>");
            }
            if ((currentConceptPages = this.conceptsToPageTable.get(currentConcept)) != null) {
                buffer.append("<h2>Concept referenced in Table</h2>");
                buffer.append("<ul>");
                for (String fileName : currentConceptPages) {
                    buffer.append("<li>");
                    buffer.append("<a href=\"../" + fileName + "\">" + this.fileNameToTitle.get(fileName) + "</a>");
                    buffer.append("</li>");
                }
                buffer.append("</ul>");
            }
            buffer.append(FOOTER);
            DocGenHtmlUtil.writeFilePatternContent(String.valueOf(i) + "_" + DocGenHtmlUtil.getValidFileName(currentConcept), projectName, String.valueOf(outputFolder) + "/concepts", buffer.toString());
        }
    }

    private String getPageContent(IFile file) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        InputStream inputStream = file.getContents();
        InputStreamReader reader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                buffer.append(line);
            }
            inputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    private void indexPage(List<String> concepts, IFile file) throws CoreException {
        String currentConcept_html;
        String fileName = file.getName();
        String pageContent = this.getPageContent(file);
        if ((mTitle = mTitle.reset(pageContent)).matches()) {
            String title = mTitle.group(1);
            this.fileNameToTitle.put(fileName, title);
            if (doTrace) {
                logger.info("[INDEXING] Title index: " + title + " in file: " + fileName);
            }
        }
        if ((mPHeaderOne = mPHeaderOne.reset(pageContent)).matches()) {
            for (String currentConcept : concepts) {
                String currentConcept_html2;
                String title = mPHeaderOne.group(1);
                if (!title.contains(currentConcept_html2 = EscapeChars.forHTML(currentConcept))) continue;
                this.indexTitle(fileName, currentConcept);
            }
        }
        if (doTrace) {
            logger.info("[INDEXING] Starting indexing paragraphs of file: " + fileName);
        }
        mParagraphe = mParagraphe.reset(pageContent);
        while (mParagraphe.find()) {
            block2: for (String currentConcept : concepts) {
                int i = 1;
                while (i <= mParagraphe.groupCount()) {
                    String paragraph = mParagraphe.group(i);
                    if (paragraph.contains(currentConcept_html = EscapeChars.forHTML(currentConcept))) {
                        this.indexParagraph(fileName, currentConcept);
                        continue block2;
                    }
                    ++i;
                }
            }
        }
        if (doTrace) {
            logger.info("[INDEXING] End indexing paragraphs of file: " + fileName);
        }
        if (doTrace) {
            logger.info("[INDEXING] Start indexing Lists of file: " + fileName);
        }
        mListStartEnd = mListStartEnd.reset(pageContent);
        int level = 0;
        int listStartIndex = -1;
        while (mListStartEnd.find()) {
            if (mListStartEnd.groupCount() > 1 && mListStartEnd.group(2) != null) {
                if (++level != 1) continue;
                listStartIndex = mListStartEnd.start(2);
                continue;
            }
            if (--level != 0) continue;
            int listEndIndex = mListStartEnd.end(3);
            String listText = pageContent.substring(listStartIndex, listEndIndex);
            for (String currentConcept : concepts) {
                String currentConcept_html3 = EscapeChars.forHTML(currentConcept);
                if (!listText.contains(currentConcept_html3)) continue;
                this.indexList(fileName, currentConcept);
            }
        }
        if (doTrace) {
            logger.info("[INDEXING] End indexing Lists of file: " + fileName);
        }
        if (doTrace) {
            logger.info("[INDEXING] Start indexing Table of file: " + fileName);
        }
        mTable = mTable.reset(pageContent);
        while (mTable.find()) {
            block7: for (String currentConcept : concepts) {
                currentConcept_html = EscapeChars.forHTML(currentConcept);
                int i = 1;
                while (i <= mTable.groupCount()) {
                    String listGroup = mTable.group(i);
                    if (listGroup.contains(currentConcept_html)) {
                        this.indexTable(fileName, currentConcept);
                        continue block7;
                    }
                    ++i;
                }
            }
        }
        if (doTrace) {
            logger.info("[INDEXING] End indexing Table of file: " + fileName);
        }
    }

    private void indexList(String fileName, String currentConcept) {
        List<String> list = this.conceptsToPageList.get(currentConcept);
        if (list != null && !list.contains(fileName)) {
            list.add(fileName);
        } else {
            ArrayList<String> localList = new ArrayList<String>();
            localList.add(fileName);
            this.conceptsToPageList.put(currentConcept, localList);
        }
        if (doTrace) {
            logger.info("[INDEXING] Concept: " + currentConcept + " is indexed in file: " + fileName);
        }
    }

    private void indexParagraph(String fileName, String currentConcept) {
        List<String> list = this.conceptsToPageParagraph.get(currentConcept);
        if (list != null && !list.contains(fileName)) {
            list.add(fileName);
        } else {
            ArrayList<String> localList = new ArrayList<String>();
            localList.add(fileName);
            this.conceptsToPageParagraph.put(currentConcept, localList);
        }
        if (doTrace) {
            logger.info("[INDEXING] Concept: " + currentConcept + " is indexed in file: " + fileName);
        }
    }

    private void indexTitle(String fileName, String currentConcept) {
        List<String> list = this.conceptsToPageTitle.get(currentConcept);
        if (list != null && !list.contains(fileName)) {
            list.add(fileName);
        } else {
            ArrayList<String> localList = new ArrayList<String>();
            localList.add(fileName);
            this.conceptsToPageTitle.put(currentConcept, localList);
        }
        if (doTrace) {
            logger.info("[INDEXING] Concept: " + currentConcept + " is indexed in file: " + fileName);
        }
    }

    private void indexTable(String fileName, String currentConcept) {
        List<String> list = this.conceptsToPageTable.get(currentConcept);
        if (list != null && !list.contains(fileName)) {
            list.add(fileName);
        } else {
            ArrayList<String> localList = new ArrayList<String>();
            localList.add(fileName);
            this.conceptsToPageTable.put(currentConcept, localList);
        }
        if (doTrace) {
            logger.info("[INDEXING] Concept: " + currentConcept + " is indexed in file: " + fileName);
        }
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }

    private static boolean isLogFeatureSetted() {
        String property = System.getProperty(LOG_PROPERTY);
        return property != null && property.equals("true");
    }
}

