/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.branding;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.polarsys.kitalpha.doc.gen.business.core.branding.DocumentationBrandingDataException;

public class DocumentationBrandingDataHelper {
    private DocumentationBrandingDataHelper() {
    }

    public static void copyLogoFile(String projectName, String outputFolder, String logoPath) {
        IFolder imgFolder = DocumentationBrandingDataHelper.getImgFolder(projectName, outputFolder);
        if (imgFolder != null && imgFolder.exists()) {
            InputStream sourceFileIputStr = null;
            try {
                sourceFileIputStr = DocumentationBrandingDataHelper.getIconInputStream(logoPath);
            }
            catch (DocumentationBrandingDataException e) {
                e.printStackTrace();
            }
            if (sourceFileIputStr != null) {
                IFile destinationFile = imgFolder.getFile("logo.gif");
                try {
                    if (!destinationFile.exists()) {
                        destinationFile.create(sourceFileIputStr, true, null);
                    } else {
                        destinationFile.setContents(sourceFileIputStr, 256, null);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static InputStream getIconInputStream(String logoPath) throws DocumentationBrandingDataException {
        if (logoPath.startsWith("platform:/plugin")) {
            return DocumentationBrandingDataHelper.getBundledIconInputStream(logoPath);
        }
        try {
            URI uri = URIUtil.fromString((String)logoPath);
            if (uri.isAbsolute()) {
                return DocumentationBrandingDataHelper.getLocalFileInputStream(logoPath);
            }
            return DocumentationBrandingDataHelper.getWorkspaceIconInputStream(logoPath);
        }
        catch (FileNotFoundException e) {
            throw new DocumentationBrandingDataException(DocumentationBrandingDataException.ExceptionCause.FileDoesntExist, "", e);
        }
        catch (URISyntaxException e) {
            throw new DocumentationBrandingDataException(DocumentationBrandingDataException.ExceptionCause.MalformatedURL, "", e);
        }
    }

    private static InputStream getBundledIconInputStream(String logoPath) throws DocumentationBrandingDataException {
        try {
            URL url = new URL(logoPath);
            return url.openConnection().getInputStream();
        }
        catch (MalformedURLException e) {
            throw new DocumentationBrandingDataException(DocumentationBrandingDataException.ExceptionCause.MalformatedURL, logoPath, e);
        }
        catch (IOException e) {
            throw new DocumentationBrandingDataException(DocumentationBrandingDataException.ExceptionCause.CantLoadContent, logoPath, e);
        }
    }

    private static InputStream getLocalFileInputStream(String logoPath) throws URISyntaxException, FileNotFoundException {
        URI uri = URIUtil.fromString((String)logoPath).normalize();
        if (!logoPath.startsWith("file:")) {
            uri = URIUtil.fromString((String)("file://" + logoPath)).normalize();
        }
        File file = URIUtil.toFile((URI)uri);
        return new FileInputStream(file);
    }

    private static InputStream getWorkspaceIconInputStream(String logoPath) throws DocumentationBrandingDataException {
        Path sourcePath = new Path(logoPath);
        IFile sourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)sourcePath);
        if (sourceFile.exists()) {
            try {
                return sourceFile.getContents();
            }
            catch (CoreException e) {
                throw new DocumentationBrandingDataException(DocumentationBrandingDataException.ExceptionCause.CantLoadContent, logoPath, e);
            }
        }
        throw new DocumentationBrandingDataException(DocumentationBrandingDataException.ExceptionCause.FileDoesntExist, logoPath);
    }

    private static IFolder getImgFolder(String projectName, String outputFolder) {
        IFolder folder;
        IFolder imgFolder = null;
        String rootFolder = DocumentationBrandingDataHelper.getRootFolder(outputFolder);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists() && (folder = project.getFolder(rootFolder)).exists() && !(imgFolder = folder.getFolder("img")).exists()) {
            try {
                imgFolder.create(true, false, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return imgFolder;
    }

    private static String getRootFolder(String folderPath) {
        String[] segment = folderPath.split("/");
        if (segment.length > 0) {
            return segment[0];
        }
        return "output";
    }
}

