/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.ui.internal.dialogs;

import java.util.List;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.dialogs.AbstractCheckboxSelectionDialog;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.provider.FcoreItemProviderAdapterFactory;
import org.eclipse.egf.model.fcore.provider.FcoreResourceItemProviderAdapterFactory;
import org.eclipse.egf.model.fprod.provider.FprodItemProviderAdapterFactory;
import org.eclipse.egf.producer.ui.EGFProducerUIPlugin;
import org.eclipse.egf.producer.ui.l10n.ProducerUIMessages;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class ActivityValidationSelectionDialog
extends AbstractCheckboxSelectionDialog {
    private final String SETTINGS_ID = String.valueOf(EGFProducerUIPlugin.getDefault().getPluginID()) + ".SCOPED_SAVE_SELECTION_DIALOG";
    private Button _savePreferences;
    private List<Activity> _activities;
    private ComposedAdapterFactory _adapterFactory;

    public ActivityValidationSelectionDialog(Shell parentShell, List<Activity> activities) {
        super(parentShell);
        this._activities = activities;
        this.setTitle(ProducerUIMessages.ActivityValidationSelectionDialog_Title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setShowSelectAllButtons(true);
        this._adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this._adapterFactory.addAdapterFactory((AdapterFactory)new FcoreResourceItemProviderAdapterFactory());
        this._adapterFactory.addAdapterFactory((AdapterFactory)new FprodItemProviderAdapterFactory());
        this._adapterFactory.addAdapterFactory((AdapterFactory)new FcoreItemProviderAdapterFactory());
        this._adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    protected IContentProvider getContentProvider() {
        return new AdapterFactoryContentProvider((AdapterFactory)this._adapterFactory);
    }

    protected ILabelProvider getLabelProvider() {
        return new LabelProvider(){
            ILabelProvider _labelProvider;
            {
                this._labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)ActivityValidationSelectionDialog.this._adapterFactory);
            }

            public String getText(Object object) {
                return this._labelProvider.getText(object);
            }

            public Image getImage(Object object) {
                return this._labelProvider.getImage(object);
            }
        };
    }

    protected String getDialogSettingsId() {
        return this.SETTINGS_ID;
    }

    protected Object getViewerInput() {
        return new ItemProvider((AdapterFactory)this._adapterFactory, this._activities);
    }

    protected String getViewerLabel() {
        return ProducerUIMessages.ActivityValidationSelectionDialog_Select;
    }

    protected List<?> getInitialElementSelections() {
        return this._activities;
    }

    protected void addCustomFooterControls(Composite parent) {
        super.addCustomFooterControls(parent);
        this._savePreferences = new Button(parent, 32);
        this._savePreferences.setText(ProducerUIMessages.ActivityValidationSelectionDialog_Never_Validate);
    }

    protected void okPressed() {
        IPreferenceStore store = EGFCoreUIPlugin.getDefault().getPreferenceStore();
        String val = this._savePreferences.getSelection() ? "never" : "prompt";
        store.setValue("org.eclipse.egf.core.validate.model.instances.before.launch", val);
        super.okPressed();
    }

    protected void addViewerListeners(StructuredViewer viewer) {
    }

    protected boolean isValid() {
        return true;
    }
}

