/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.uri;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.core.platform.uri.TargetPlatformURIHandlerImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ArchiveURIHandlerImpl;
import org.eclipse.emf.ecore.resource.impl.EFSURIHandlerImpl;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.FileURIHandlerImpl;
import org.eclipse.emf.ecore.resource.impl.PlatformResourceURIHandlerImpl;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;

public class TargetPlatformURIConverter
extends ExtensibleURIConverterImpl
implements IPluginModelListener {
    private Object __lock = new Object();

    private static List<URIHandler> getDefaultHandlers() {
        return Collections.unmodifiableList(Arrays.asList(new PlatformResourceURIHandlerImpl(), new FileURIHandlerImpl(), new EFSURIHandlerImpl(), new ArchiveURIHandlerImpl(), new TargetPlatformURIHandlerImpl()));
    }

    public TargetPlatformURIConverter() {
        super(TargetPlatformURIConverter.getDefaultHandlers(), (Collection)ContentHandler.Registry.INSTANCE.contentHandlers());
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
        this.getURIMap().putAll(this.initializeURIMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelsChanged(PluginModelDelta event) {
        Object object = this.__lock;
        synchronized (object) {
            this.loadURIMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI normalize(URI uri) {
        Object object = this.__lock;
        synchronized (object) {
            return super.normalize(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        Object object = this.__lock;
        synchronized (object) {
            return super.createOutputStream(uri, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        Object object = this.__lock;
        synchronized (object) {
            return super.createInputStream(uri, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(URI uri, Map<?, ?> options) throws IOException {
        Object object = this.__lock;
        synchronized (object) {
            super.delete(uri, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        Object object = this.__lock;
        synchronized (object) {
            return super.contentDescription(uri, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(URI uri, Map<?, ?> options) {
        Object object = this.__lock;
        synchronized (object) {
            return super.exists(uri, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        Object object = this.__lock;
        synchronized (object) {
            return super.getAttributes(uri, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        Object object = this.__lock;
        synchronized (object) {
            super.setAttributes(uri, attributes, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.__lock;
        synchronized (object) {
            PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
            this.getURIMap().clear();
        }
    }

    private void loadURIMap() {
        this.getURIMap().clear();
        this.getURIMap().putAll(this.initializeURIMap());
    }

    private Map<URI, URI> initializeURIMap() {
        HashMap<URI, URI> urimap = new HashMap<URI, URI>();
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getActiveModels((boolean)true);
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleId;
            IPluginModelBase base = iPluginModelBaseArray[n2];
            if (base != null && (bundleId = BundleHelper.getBundleId((IPluginModelBase)base)) != null) {
                if (base.getUnderlyingResource() == null) {
                    urimap.put(URI.createPlatformResourceURI((String)(String.valueOf(bundleId) + "/"), (boolean)false), URI.createPlatformPluginURI((String)(String.valueOf(bundleId) + "/"), (boolean)false));
                } else {
                    urimap.put(URI.createPlatformPluginURI((String)(String.valueOf(bundleId) + "/"), (boolean)false), URI.createPlatformResourceURI((String)(String.valueOf(bundleId) + "/"), (boolean)false));
                }
            }
            ++n2;
        }
        return urimap;
    }
}

