/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.pattern;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.egf.model.pattern.Pattern;

public abstract class Node {
    private final Node parent;
    private Pattern pattern;
    private final String patternClass;
    private final Set<String> appliedOutputProcessors = new HashSet<String>();

    protected Node(Node parent, String patternClass) {
        this.parent = parent;
        this.patternClass = patternClass;
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getContainer(Class cls) {
        if (this.parent == null) {
            return null;
        }
        if (this.getClass().equals(cls)) {
            return this;
        }
        return this.parent.getContainer(cls);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getPatternClass() {
        return this.patternClass;
    }

    public Set<String> getAppliedOutputProcessors() {
        return this.appliedOutputProcessors;
    }

    public String toString() {
        return "Node [patternClass=" + this.patternClass + "]";
    }

    public abstract void accept(NodeVisitor var1);

    public static class CallBackContainer
    extends Container {
        public CallBackContainer(Container parent) {
            super(parent, (String)null);
        }
    }

    public static class Container
    extends Node {
        private final List<Node> children = new ArrayList<Node>();

        public Container(Container parent, Class patternClass) {
            this(parent, patternClass.getName());
        }

        public Container(Container parent, String patternClass) {
            super(parent, patternClass);
            if (parent != null) {
                parent.getChildren().add(this);
            }
        }

        public List<Node> getChildren() {
            return this.children;
        }

        @Override
        public void accept(NodeVisitor visitor) {
            if (!visitor.visit(this)) {
                return;
            }
            for (Node child : this.children) {
                child.accept(visitor);
            }
        }
    }

    public static final class DataLeaf
    extends Leaf {
        private final String method;
        private String data;

        public DataLeaf(Container parent, Class patternClass, String method, String data) {
            super(parent, patternClass.getName());
            this.method = method;
            this.data = data;
            if (data != null && !"".equals(data)) {
                parent.getChildren().add(this);
            }
        }

        public String getMethod() {
            return this.method;
        }

        @Override
        public String toString() {
            return "Leaf [method=" + this.method + ", data=" + this.data + " ]";
        }

        public String getData() {
            return this.data;
        }

        public void setData(String data) {
            this.data = data;
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append(this.data);
        }
    }

    public static abstract class Leaf
    extends Node {
        protected Leaf(Container parent, String patternClass) {
            super(parent, patternClass);
        }

        public abstract void toString(StringBuilder var1);

        @Override
        public void accept(NodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NodeVisitor {
        public boolean visit(Node node) {
            return true;
        }
    }

    public static class SuperOrchestrationContainer
    extends Container {
        public SuperOrchestrationContainer(Container parent) {
            super(parent, (String)null);
        }
    }
}

