/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class PatternEditorInput
implements IEditorInput {
    public static final String PATTERN_ID = "patternId";
    public static final String RESSOURCE_URI = "uri";
    private final PatternPersistableElement persistable = new PatternPersistableElement();
    private final String id;
    private final Resource resource;
    private IFile file;
    private boolean isReadOnly = false;

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public PatternEditorInput(Resource resource, String id) {
        if (id == null || resource == null) {
            throw new IllegalArgumentException();
        }
        this.resource = resource;
        this.id = id;
    }

    public boolean exists() {
        if (this.getURI().isFile()) {
            return new File(this.getURI().toFileString()).exists();
        }
        return EclipseUtil.exists(this.getURI());
    }

    public boolean isReadOnly() {
        return this.isReadOnly || this.getFile() == null;
    }

    public Pattern getPattern() {
        return (Pattern)this.getResource().getEObject(this.id);
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getID() {
        return this.id;
    }

    public URI getURI() {
        if (this.getPattern() != null) {
            return EGFPlatformPlugin.getPlatformURIConverter().normalize(EcoreUtil.getURI((EObject)this.getPattern()));
        }
        return EGFPlatformPlugin.getPlatformURIConverter().normalize(this.getResource().getURI());
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.getPattern() == null) {
            return "";
        }
        return this.getPattern().getName();
    }

    public IPersistableElement getPersistable() {
        return this.persistable;
    }

    public String getToolTipText() {
        return this.getURI().toString();
    }

    public Object getAdapter(Class adapter) {
        Object result = EclipseUtil.getAdapter(adapter, this.getURI());
        if (result != null) {
            return result;
        }
        return null;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof PatternEditorInput && this.getURI().equals(((PatternEditorInput)object).getURI());
    }

    public IFile getFile() {
        if (this.file == null) {
            this.file = (IFile)EclipseUtil.getAdapter(IFile.class, this.getURI());
        }
        return this.file;
    }

    public IStorage getStorage() {
        return this.getFile();
    }

    protected static class EclipseUtil {
        protected EclipseUtil() {
        }

        public static Object getAdapter(Class<?> adapter, URI uri) {
            if ((adapter == IFile.class || adapter == IResource.class) && uri.isPlatformResource()) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            }
            return null;
        }

        public static boolean exists(URI uri) {
            if (uri.isPlatformResource()) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))).exists();
            }
            return false;
        }
    }

    private class PatternPersistableElement
    implements IPersistableElement {
        private PatternPersistableElement() {
        }

        public void saveState(IMemento memento) {
            if (PatternEditorInput.this.getPattern() != null) {
                memento.putString(PatternEditorInput.PATTERN_ID, PatternEditorInput.this.getID());
                memento.putString(PatternEditorInput.RESSOURCE_URI, PatternEditorInput.this.resource.getURI().toString());
            }
        }

        public String getFactoryId() {
            return "org.eclipse.egf.pattern.ui.pattern.factory.id";
        }
    }
}

