/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.data.capellacore.Allocation;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.docgen.util.CapellaPropertyServices;
import org.polarsys.capella.docgen.util.CapellaServices;

public class CapellaElementService {
    public static List<String> getPropertiesValue(EObject eObject_p, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        if (eObject_p instanceof CapellaElement) {
            for (AbstractPropertyValue prop : ((CapellaElement)eObject_p).getOwnedPropertyValues()) {
                ret.add(CapellaPropertyServices.getPropertyValueInformation(prop, projectName, outputFolder));
            }
        }
        return ret;
    }

    public static Collection<String> getOutGoingAllocation(CapellaElement element, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        for (AbstractTrace currentAbstractTrace : element.getOutgoingTraces()) {
            if (!(currentAbstractTrace instanceof Allocation) || !CapellaElementService.isSuperLayer(element, ((Allocation)currentAbstractTrace).getTargetElement())) continue;
            StringBuffer buffer = new StringBuffer();
            TraceableElement traceableElement = ((Allocation)currentAbstractTrace).getTargetElement();
            if (traceableElement != null) {
                buffer.append(CapellaServices.getImageLinkFromElement((EObject)traceableElement, projectName, outputFolder));
                buffer.append(" ");
                buffer.append(CapellaServices.getHyperlinkFromElement((EObject)traceableElement));
            }
            ret.add(buffer.toString());
        }
        return ret;
    }

    public static Collection<String> getIncomingAllocation(CapellaElement element, String projectName, String outputFolder) {
        ArrayList<String> ret = new ArrayList<String>();
        for (AbstractTrace currentAbstractTrace : element.getIncomingTraces()) {
            if (!(currentAbstractTrace instanceof Allocation) || !CapellaElementService.isLowerLayer(element, ((Allocation)currentAbstractTrace).getSourceElement())) continue;
            StringBuffer buffer = new StringBuffer();
            TraceableElement traceableElement = ((Allocation)currentAbstractTrace).getSourceElement();
            if (traceableElement != null) {
                buffer.append(CapellaServices.getImageLinkFromElement((EObject)traceableElement, projectName, outputFolder));
                buffer.append(" ");
                buffer.append(CapellaServices.getHyperlinkFromElement((EObject)traceableElement));
            }
            ret.add(buffer.toString());
        }
        return ret;
    }

    private static boolean isLowerLayer(CapellaElement targetElement, TraceableElement sourceElement) {
        if (sourceElement instanceof CapellaElement) {
            CapellaElement sourceCapellaElement = (CapellaElement)sourceElement;
            if (CapellaLayerCheckingExt.isInEPBSLayer((CapellaElement)sourceCapellaElement)) {
                return false;
            }
            if (CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)targetElement)) {
                return CapellaLayerCheckingExt.isInEPBSLayer((CapellaElement)sourceCapellaElement);
            }
            if (CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)targetElement)) {
                return CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)sourceCapellaElement);
            }
            if (CapellaElementService.isInSystemAnalysis(targetElement)) {
                return CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)sourceCapellaElement);
            }
            if (CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)targetElement)) {
                return CapellaElementService.isInSystemAnalysis(sourceCapellaElement);
            }
        }
        return false;
    }

    public static boolean isInSystemAnalysis(CapellaElement ele_p) {
        ArrayList<CapellaElement> meleList = new ArrayList<CapellaElement>(0);
        CapellaLayerCheckingExt.getAll_ContainerElements((CapellaElement)ele_p, meleList);
        meleList.add(ele_p);
        for (CapellaElement element : meleList) {
            if (!(element instanceof SystemAnalysis)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSuperLayer(CapellaElement element, TraceableElement targetElement) {
        if (targetElement instanceof CapellaElement) {
            CapellaElement targetCapellaElement = (CapellaElement)targetElement;
            if (CapellaLayerCheckingExt.isInEPBSLayer((CapellaElement)element)) {
                return !CapellaLayerCheckingExt.isInEPBSLayer((CapellaElement)targetCapellaElement);
            }
            if (CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)element)) {
                return !CapellaLayerCheckingExt.isInEPBSLayer((CapellaElement)targetCapellaElement) && !CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)targetCapellaElement);
            }
            if (CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)element)) {
                return CapellaLayerCheckingExt.isInContextLayer((CapellaElement)targetCapellaElement) || CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)targetCapellaElement);
            }
            if (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)element)) {
                return CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)targetCapellaElement);
            }
        }
        return false;
    }
}

