/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.core.ui.preferences;

import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.kitalpha.doc.gen.business.core.extension.page.PageExtensionElement;
import org.polarsys.kitalpha.doc.gen.business.core.extension.page.PageExtensionRegistry;
import org.polarsys.kitalpha.doc.gen.business.core.extension.page.helpers.NamingOptionalityPreferencesHelper;
import org.polarsys.kitalpha.doc.gen.business.core.preference.ui.AbstractDocgenPreferencePage;

public class OptionalityPreferencesPage
extends AbstractDocgenPreferencePage {
    private ListViewer domainViewer;
    private CheckboxTableViewer categoryViewer;

    protected void createFieldEditors() {
    }

    protected Control createContents(Composite parent) {
        Composite child = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        child.setLayout((Layout)layout);
        SashForm sash = new SashForm(child, 256);
        sash.setFont(child.getFont());
        Composite domainComposite = new Composite((Composite)sash, 0);
        domainComposite.setLayout((Layout)new GridLayout(1, true));
        Label domainLabel = new Label(domainComposite, 0);
        domainLabel.setText("Domains");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)domainLabel);
        this.domainViewer = new ListViewer(domainComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.domainViewer.getList());
        Composite categoryComposite = new Composite((Composite)sash, 0);
        categoryComposite.setLayout((Layout)new GridLayout(1, true));
        Label categoryLabel = new Label(categoryComposite, 0);
        categoryLabel.setText("Categories");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)categoryLabel);
        this.categoryViewer = CheckboxTableViewer.newCheckList((Composite)categoryComposite, (int)2048);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.categoryViewer.getTable());
        this.domainViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.categoryViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.domainViewer.setInput(this.doGetDomains());
        this.domainViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String selectedDomain = (String)((IStructuredSelection)event.getSelection()).getFirstElement();
                OptionalityPreferencesPage.this.categoryViewer.setInput(OptionalityPreferencesPage.this.doGetCategoriesOfDomain(selectedDomain));
            }
        });
        this.categoryViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                String domain = OptionalityPreferencesPage.this.doGetSelectedDomain();
                String category = (String)event.getElement();
                boolean isCategoryChecked = event.getChecked();
                PageExtensionElement.PageExtensionActivationStatus status = isCategoryChecked ? PageExtensionElement.PageExtensionActivationStatus.Active : PageExtensionElement.PageExtensionActivationStatus.Inactive;
                PageExtensionRegistry.getInstance().setCategoryActivationStatus(domain, category, status);
                String key = NamingOptionalityPreferencesHelper.getKeyOfPageExtensionElement((String)domain, (String)category);
                NamingOptionalityPreferencesHelper.setCustomizedStringValue((String)key, (String)status.name());
                OptionalityPreferencesPage.this.categoryViewer.refresh();
            }
        });
        this.categoryViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                PageExtensionElement.PageExtensionActivationStatus categoryActivationStatus = this.doGetPageExtensionActivationStatus((String)element);
                return categoryActivationStatus.equals((Object)PageExtensionElement.PageExtensionActivationStatus.Unknown);
            }

            public boolean isChecked(Object element) {
                PageExtensionElement.PageExtensionActivationStatus categoryActivationStatus = this.doGetPageExtensionActivationStatus((String)element);
                return categoryActivationStatus.equals((Object)PageExtensionElement.PageExtensionActivationStatus.Active);
            }

            private PageExtensionElement.PageExtensionActivationStatus doGetPageExtensionActivationStatus(Object element) {
                String domain = OptionalityPreferencesPage.this.doGetSelectedDomain();
                String category = (String)element;
                PageExtensionElement.PageExtensionActivationStatus categoryActivationStatus = PageExtensionRegistry.getInstance().getCategoryActivationStatus(domain, category);
                return categoryActivationStatus;
            }
        });
        this.doSelectFirstItem();
        return child;
    }

    protected void performDefaults() {
        String[] domains;
        String[] stringArray = domains = this.domainViewer.getList().getItems();
        int n = domains.length;
        int n2 = 0;
        while (n2 < n) {
            String domain = stringArray[n2];
            Collection categories = PageExtensionRegistry.getInstance().getCategories(domain);
            for (String category : categories) {
                Collection categoryExtensions = PageExtensionRegistry.getInstance().getCategoryExtensions(domain, category);
                for (PageExtensionElement pageExtensionElement : categoryExtensions) {
                    pageExtensionElement.setCurrentActivactionStatus(pageExtensionElement.getDefaultActivationStatus());
                }
            }
            ++n2;
        }
        this.categoryViewer.refresh();
        super.performDefaults();
    }

    private void doSelectFirstItem() {
        int itemCount = this.domainViewer.getList().getItemCount();
        if (itemCount > 0) {
            this.domainViewer.setSelection((ISelection)new StructuredSelection((Object)this.domainViewer.getList().getItem(0)));
        }
    }

    private String doGetSelectedDomain() {
        return (String)((IStructuredSelection)this.domainViewer.getSelection()).getFirstElement();
    }

    private Collection<String> doGetDomains() {
        return PageExtensionRegistry.getInstance().getDomains();
    }

    private Collection<String> doGetCategoriesOfDomain(String domain) {
        return PageExtensionRegistry.getInstance().getCategories(domain);
    }
}

