/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.pattern;

import java.util.List;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.domain.EgfResourceSet;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternPackage;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.pde.core.plugin.IPluginModelBase;

public class PatternNameHelper {
    public static final String DEFAULT_PATTERN_NAME = "myPattern";

    private PatternNameHelper() {
    }

    public static void setUniquePatternName(IPlatformFcore fcore, Pattern pattern, List<String> names) {
        if (fcore == null || pattern == null || names == null) {
            return;
        }
        int i = 0;
        while (names.contains(pattern.getName())) {
            pattern.setName(i == 0 ? DEFAULT_PATTERN_NAME : "myPattern_" + i);
            ++i;
        }
    }

    public static List<String> getPatternNameWithinBundle(IPlatformFcore fcore, PatternLibrary library, Pattern pattern) {
        UniqueEList names = new UniqueEList();
        for (Pattern innerPattern : PatternNameHelper.getPatterns(fcore, library)) {
            if (innerPattern.getName() == null || innerPattern.getName().trim().length() == 0 || pattern == innerPattern) continue;
            names.add(innerPattern.getName());
        }
        return names;
    }

    public static List<Pattern> getPatterns(IPlatformFcore fcore, PatternLibrary library, Pattern pattern, String patternName) {
        UniqueEList patterns = new UniqueEList();
        if (patternName == null || patternName.trim().length() == 0) {
            return patterns;
        }
        for (Pattern innerPattern : PatternNameHelper.getPatterns(fcore, library)) {
            if (pattern == innerPattern || !patternName.equals(innerPattern.getName())) continue;
            patterns.add(innerPattern);
        }
        return patterns;
    }

    public static List<Pattern> getPatterns(IPlatformFcore fcore, PatternLibrary library) {
        UniqueEList patterns = new UniqueEList();
        if (fcore == null || library == null || library.getName() == null || library.getName().trim().length() == 0) {
            return patterns;
        }
        ResourceSet resourceSet = null;
        if (library.eResource() != null) {
            resourceSet = library.eResource().getResourceSet();
        }
        if (resourceSet == null) {
            resourceSet = new EgfResourceSet(fcore.isRuntime());
        }
        IPlatformFcore[] fcores = null;
        IPlatformFcore[] iPlatformFcoreArray = fcores = EGFCorePlugin.getPlatformFcores((IPluginModelBase)fcore.getPluginModelBase());
        int n = fcores.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformFcore innerFcore = iPlatformFcoreArray[n2];
            Resource resource = resourceSet.getResource(innerFcore.getURI(), true);
            for (EObject root : resource.getContents()) {
                for (EObject innerEObject : EMFHelper.getAllProperContents((EClassifier)PatternPackage.eINSTANCE.getPattern(), (EObject)root)) {
                    Pattern innerPattern = (Pattern)innerEObject;
                    if (!innerPattern.getContainer().getName().equals(library.getName())) continue;
                    patterns.add((Pattern)innerEObject);
                }
            }
            ++n2;
        }
        return patterns;
    }
}

