/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import java.net.ConnectException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.FilewatcherUtils;
import org.eclipse.codewind.filewatchers.core.internal.HttpUtil;
import org.json.JSONObject;

public class HttpPostOutputQueue {
    private final PriorityQueue<PostQueueChunkGroup> queue_synch = new PriorityQueue();
    private final List<OutputQueueWorkerThread> threads_sync_lock = new ArrayList<OutputQueueWorkerThread>();
    private final AtomicBoolean disposed_sync_lock = new AtomicBoolean(false);
    private final FWLogger log = FWLogger.getInstance();
    private final AtomicInteger activeWorkerThreads_synch = new AtomicInteger();
    private final Object lock = new Object();
    private final String serverBaseUrl;
    private static final long CHUNK_GROUP_EXPIRE_TIME_IN_NANOS = TimeUnit.NANOSECONDS.convert(24L, TimeUnit.HOURS);

    public HttpPostOutputQueue(String url) {
        this.serverBaseUrl = url;
        for (int x = 0; x < 3; ++x) {
            OutputQueueWorkerThread wt = new OutputQueueWorkerThread();
            wt.start();
            this.threads_sync_lock.add(wt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToQueue(String projectId, long timestamp, List<String> base64Compressed) {
        Object object = this.lock;
        synchronized (object) {
            if (this.disposed_sync_lock.get()) {
                return;
            }
        }
        this.log.logDebug("Added file changes to queue: " + base64Compressed.size(), projectId);
        PostQueueChunkGroup chunkGroup = new PostQueueChunkGroup(timestamp, projectId, base64Compressed, System.nanoTime() + CHUNK_GROUP_EXPIRE_TIME_IN_NANOS, this);
        PriorityQueue<PostQueueChunkGroup> priorityQueue = this.queue_synch;
        synchronized (priorityQueue) {
            this.queue_synch.offer(chunkGroup);
            this.informStateChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateDebugString() {
        String result = "- ";
        int activeWorkers = 0;
        PriorityQueue<PostQueueChunkGroup> priorityQueue = this.activeWorkerThreads_synch;
        synchronized (priorityQueue) {
            activeWorkers = this.activeWorkerThreads_synch.get();
        }
        priorityQueue = this.lock;
        synchronized (priorityQueue) {
            if (this.disposed_sync_lock.get()) {
                return result + "[disposed]";
            }
            result = result + "total-workers: " + this.threads_sync_lock.size() + "  active-workers:" + activeWorkers;
        }
        priorityQueue = this.queue_synch;
        synchronized (priorityQueue) {
            result = result + "  chunkGroupList-size: " + this.queue_synch.size() + "\n";
            if (this.queue_synch.size() > 0) {
                result = result + "\n";
                result = result + "- HTTP Post Chunk Group List:\n";
                for (PostQueueChunkGroup group : this.queue_synch) {
                    result = result + "  - projectID: " + group.getProjectId() + "  timestamp: " + group.getTimestamp() + "\n";
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupChunkGroups() {
        PriorityQueue<PostQueueChunkGroup> priorityQueue = this.queue_synch;
        synchronized (priorityQueue) {
            long currentTime = System.nanoTime();
            boolean changeMade = false;
            Iterator<PostQueueChunkGroup> it = this.queue_synch.iterator();
            while (it.hasNext()) {
                PostQueueChunkGroup group = it.next();
                if (group.isGroupComplete()) {
                    it.remove();
                    changeMade = true;
                    continue;
                }
                if (currentTime <= group.getExpireTimeInNanos()) continue;
                it.remove();
                changeMade = true;
                this.log.logSevere("Chunk group expired. This implies we could not connect to server for many hours. Chunk-group project: " + group.getProjectId() + "  timestamp: " + group.getTimestamp());
            }
            if (changeMade) {
                this.informStateChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void informStateChange() {
        PriorityQueue<PostQueueChunkGroup> priorityQueue = this.queue_synch;
        synchronized (priorityQueue) {
            this.queue_synch.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PostQueueChunk getOrWaitForNextPieceOfWork() throws InterruptedException {
        PostQueueChunk result = null;
        while (result == null) {
            PriorityQueue<PostQueueChunkGroup> priorityQueue = this.queue_synch;
            synchronized (priorityQueue) {
                PostQueueChunkGroup group;
                Optional<PostQueueChunk> o;
                this.cleanupChunkGroups();
                if (this.queue_synch.size() > 0 && (o = (group = this.queue_synch.peek()).acquireNextChunkAvailableToSend()).isPresent()) {
                    result = o.get();
                }
                if (result == null) {
                    this.queue_synch.wait();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            if (this.disposed_sync_lock.get()) {
                return;
            }
            this.disposed_sync_lock.set(true);
            this.threads_sync_lock.forEach(e -> e.setThreadRunning(false));
            this.threads_sync_lock.clear();
        }
    }

    private static class PostQueueChunk {
        private final String projectId;
        private final long timestamp;
        private final String base64Compressed;
        private final int chunkId;
        private final int chunkTotal;
        private final PostQueueChunkGroup parentGroup;

        public PostQueueChunk(String projectId, long timestamp, String base64Compressed, int chunkId, int chunkTotal, PostQueueChunkGroup parentGroup) {
            this.projectId = projectId;
            this.timestamp = timestamp;
            this.base64Compressed = base64Compressed;
            this.chunkId = chunkId;
            this.chunkTotal = chunkTotal;
            this.parentGroup = parentGroup;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getBase64Compressed() {
            return this.base64Compressed;
        }

        public int getChunkId() {
            return this.chunkId;
        }

        public int getChunkTotal() {
            return this.chunkTotal;
        }

        public PostQueueChunkGroup getParentGroup() {
            return this.parentGroup;
        }
    }

    private static class PostQueueChunkGroup
    implements Comparable<PostQueueChunkGroup> {
        private final Map<Integer, PostQueueChunk> chunkMap;
        private final Map<Integer, ChunkStatus> chunkStatus_synch = new HashMap<Integer, ChunkStatus>();
        private final long timestamp;
        private final HttpPostOutputQueue parent;
        private final FWLogger log = FWLogger.getInstance();
        private final String projectId;
        private final long expireTimeInNanos;

        public PostQueueChunkGroup(long timestamp, String projectId, List<String> base64Compressed, long expireTimeInNanos, HttpPostOutputQueue parent) {
            this.parent = parent;
            this.projectId = projectId;
            this.expireTimeInNanos = expireTimeInNanos;
            HashMap<Integer, PostQueueChunk> chunkMap = new HashMap<Integer, PostQueueChunk>();
            int chunkId = 1;
            for (String text : base64Compressed) {
                PostQueueChunk chunk = new PostQueueChunk(projectId, timestamp, text, chunkId, base64Compressed.size(), this);
                chunkMap.put(chunk.getChunkId(), chunk);
                this.chunkStatus_synch.put(chunk.getChunkId(), ChunkStatus.AVAILABLE_TO_SEND);
                ++chunkId;
            }
            this.chunkMap = Collections.unmodifiableMap(chunkMap);
            this.timestamp = timestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isGroupComplete() {
            Map<Integer, ChunkStatus> map = this.chunkStatus_synch;
            synchronized (map) {
                return !this.chunkStatus_synch.values().stream().anyMatch(e -> e != ChunkStatus.COMPLETE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void informChunkSent(PostQueueChunk chunk) {
            Map<Integer, ChunkStatus> map = this.chunkStatus_synch;
            synchronized (map) {
                ChunkStatus currStatus = this.chunkStatus_synch.get(chunk.getChunkId());
                if (currStatus != ChunkStatus.WAITING_FOR_ACK) {
                    this.log.logSevere("Unexpected status of chunk, should be WAITING, but was:" + (Object)((Object)currStatus));
                }
                this.chunkStatus_synch.put(chunk.getChunkId(), ChunkStatus.COMPLETE);
            }
            this.parent.informStateChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void informChunkFailedToSend(PostQueueChunk chunk) {
            Map<Integer, ChunkStatus> map = this.chunkStatus_synch;
            synchronized (map) {
                ChunkStatus currStatus = this.chunkStatus_synch.get(chunk.getChunkId());
                if (currStatus != ChunkStatus.WAITING_FOR_ACK) {
                    this.log.logSevere("Unexpected status of chunk, should be WAITING, but was:" + (Object)((Object)currStatus));
                }
                this.chunkStatus_synch.put(chunk.getChunkId(), ChunkStatus.AVAILABLE_TO_SEND);
            }
            this.parent.informStateChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Optional<PostQueueChunk> acquireNextChunkAvailableToSend() {
            Map<Integer, ChunkStatus> map = this.chunkStatus_synch;
            synchronized (map) {
                Map.Entry entry = this.chunkStatus_synch.entrySet().stream().filter(e -> e.getValue() == ChunkStatus.AVAILABLE_TO_SEND).findFirst().orElse(null);
                if (entry == null) {
                    return Optional.empty();
                }
                this.chunkStatus_synch.put((Integer)entry.getKey(), ChunkStatus.WAITING_FOR_ACK);
                return Optional.of(this.chunkMap.get(entry.getKey()));
            }
        }

        @Override
        public int compareTo(PostQueueChunkGroup other) {
            int result = this.timestamp > other.timestamp ? 1 : (this.timestamp < other.timestamp ? -1 : 0);
            return result;
        }

        long getExpireTimeInNanos() {
            return this.expireTimeInNanos;
        }

        String getProjectId() {
            return this.projectId;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        private static enum ChunkStatus {
            AVAILABLE_TO_SEND,
            WAITING_FOR_ACK,
            COMPLETE;

        }
    }

    private class OutputQueueWorkerThread
    extends Thread {
        private boolean threadRunning = true;
        private final FilewatcherUtils.ExponentialBackoffUtil failureDelay = FilewatcherUtils.getDefaultBackoffUtil(4000L);

        public OutputQueueWorkerThread() {
            this.setName(OutputQueueWorkerThread.class.getName());
            this.setDaemon(true);
        }

        public void setThreadRunning(boolean threadRunning) {
            this.threadRunning = threadRunning;
        }

        @Override
        public void run() {
            while (this.threadRunning) {
                try {
                    this.pollAndSend();
                }
                catch (Throwable t) {
                    HttpPostOutputQueue.this.log.logSevere("Exception in outer loop of pollAndSend", t, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pollAndSend() {
            PostQueueChunk chunkToSend;
            boolean sendFailed;
            block25: {
                Object url;
                sendFailed = false;
                chunkToSend = null;
                try {
                    chunkToSend = HttpPostOutputQueue.this.getOrWaitForNextPieceOfWork();
                    if (chunkToSend == null || !this.threadRunning) break block25;
                    AtomicInteger atomicInteger = HttpPostOutputQueue.this.activeWorkerThreads_synch;
                    synchronized (atomicInteger) {
                        HttpPostOutputQueue.this.activeWorkerThreads_synch.incrementAndGet();
                    }
                    url = HttpPostOutputQueue.this.serverBaseUrl + "/api/v1/projects/" + chunkToSend.getProjectId() + "/file-changes?timestamp=" + chunkToSend.getTimestamp() + "&chunk=" + chunkToSend.getChunkId() + "&chunk_total=" + chunkToSend.getChunkTotal();
                    JSONObject obj = new JSONObject();
                    obj.put("msg", (Object)chunkToSend.getBase64Compressed());
                    HttpPostOutputQueue.this.log.logInfo("Issuing POST request to '" + (String)url + "', with payload size of " + chunkToSend.getBase64Compressed().length());
                    HttpUtil.HttpResult response = HttpUtil.post(new URI((String)url), obj, e -> {
                        HttpUtil.allowAllCerts(e);
                        e.setConnectTimeout(10000);
                        e.setReadTimeout(10000);
                    });
                    if (response == null || response.responseCode != 200) {
                        sendFailed = true;
                    } else {
                        this.failureDelay.successReset();
                        sendFailed = false;
                    }
                }
                catch (Throwable t) {
                    if (t instanceof ConnectException && t.getMessage().contains("Connection refused")) {
                        HttpPostOutputQueue.this.log.logError("Exception in pollAndSend");
                    } else {
                        HttpPostOutputQueue.this.log.logError("Exception in pollAndSend", t);
                    }
                    sendFailed = true;
                }
                finally {
                    if (chunkToSend != null) {
                        url = HttpPostOutputQueue.this.activeWorkerThreads_synch;
                        synchronized (url) {
                            HttpPostOutputQueue.this.activeWorkerThreads_synch.decrementAndGet();
                        }
                    }
                }
            }
            if (!sendFailed && chunkToSend != null) {
                chunkToSend.getParentGroup().informChunkSent(chunkToSend);
            }
            if (sendFailed && this.threadRunning) {
                if (chunkToSend != null) {
                    chunkToSend.getParentGroup().informChunkFailedToSend(chunkToSend);
                }
                this.failureDelay.sleepIgnoreInterrupt();
                this.failureDelay.failIncrease();
            }
        }
    }
}

