/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.interfaces.scoping.InterfaceUtilities;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionAny;
import org.eclipse.comma.expressions.expression.ExpressionConstantBool;
import org.eclipse.comma.expressions.expression.ExpressionEnumLiteral;
import org.eclipse.comma.expressions.expression.ExpressionFactory;
import org.eclipse.comma.parameters.parameters.EventParams;
import org.eclipse.comma.parameters.parameters.ExpressionExtended;
import org.eclipse.comma.parameters.parameters.NotificationParams;
import org.eclipse.comma.parameters.parameters.ParametersFactory;
import org.eclipse.comma.parameters.parameters.Params;
import org.eclipse.comma.parameters.parameters.ReplyParams;
import org.eclipse.comma.parameters.parameters.StateParams;
import org.eclipse.comma.parameters.parameters.TriggerParams;
import org.eclipse.comma.project.generatortasks.OutputLocator;
import org.eclipse.comma.project.project.ComponentReference;
import org.eclipse.comma.project.project.ExecutableSource;
import org.eclipse.comma.project.project.FilePath;
import org.eclipse.comma.project.project.InterfaceReference;
import org.eclipse.comma.project.project.Task;
import org.eclipse.comma.project.project.TraceSource;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.types.generator.CommaFileSystemAccess;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.SimpleTypeDecl;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class GeneratorTask {
    protected final List<String> errors;
    protected final Task task;
    protected final Resource resource;
    protected final IScopeProvider scopeProvider;
    protected final IFileSystemAccess2 fsa;
    protected final String projectFileName;
    protected final OutputLocator outputLocator;

    public GeneratorTask(Task task, IScopeProvider scopeProvider, OutputLocator outputLocator, IFileSystemAccess2 fsa) {
        this.task = task;
        this.resource = task.eResource();
        this.scopeProvider = scopeProvider;
        this.fsa = fsa;
        ArrayList<String> _arrayList = new ArrayList<String>();
        this.errors = _arrayList;
        this.projectFileName = this.resource.getURI().lastSegment();
        this.outputLocator = outputLocator;
    }

    public List<String> startGeneration() {
        try {
            this.doGenerate();
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                IllegalArgumentException e = (IllegalArgumentException)_t;
                this.errors.add(e.getMessage());
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        return this.errors;
    }

    protected abstract void doGenerate() throws IllegalArgumentException;

    protected IllegalArgumentException createException(String message) {
        String _lastSegment = this.resource.getURI().lastSegment();
        String _plus = String.valueOf(message) + " - " + _lastSegment;
        String _plus_1 = String.valueOf(_plus) + " (";
        String _simpleName = this.getClass().getSimpleName();
        String _plus_2 = String.valueOf(_plus_1) + _simpleName;
        String _plus_3 = String.valueOf(_plus_2) + ")";
        return new IllegalArgumentException(_plus_3);
    }

    protected IllegalArgumentException createException(String message, Resource context, Class<?> cl) {
        String _lastSegment = context.getURI().lastSegment();
        String _plus = String.valueOf(message) + " - " + _lastSegment;
        String _plus_1 = String.valueOf(_plus) + " (";
        String _simpleName = cl.getSimpleName();
        String _plus_2 = String.valueOf(_plus_1) + _simpleName;
        String _plus_3 = String.valueOf(_plus_2) + ")";
        return new IllegalArgumentException(_plus_3);
    }

    public CommaFileSystemAccess commaFSA() {
        return new CommaFileSystemAccess(this.fsa);
    }

    public CommaFileSystemAccess commaFSA(String root) {
        CommaFileSystemAccess _xblockexpression = null;
        String _xifexpression = null;
        boolean _endsWith = root.endsWith("/");
        boolean _not = !_endsWith;
        _xifexpression = _not ? String.valueOf(root) + "/" : root;
        String path = _xifexpression;
        _xblockexpression = new CommaFileSystemAccess(path, this.fsa);
        return _xblockexpression;
    }

    public Signature getSignature(Interface cInterface) {
        return InterfaceUtilities.getSignature((Interface)cInterface, (IScopeProvider)this.scopeProvider);
    }

    public String getGeneratedFile(Task task) {
        return this.outputLocator.getGeneratedFile(task);
    }

    public String getFileName(Task task) {
        return this.outputLocator.getFileName(task);
    }

    public String getOutputFolder(Task task) {
        return this.outputLocator.getOutputFolder(task);
    }

    public CommaFileSystemAccess getFileSystemAccess(Task task) {
        return this.commaFSA(this.outputLocator.getOutputFolder(task));
    }

    public Resource getTraceResource(TraceSource source) {
        return this.outputLocator.getTraceResource((IFileSystemAccess)this.fsa, source);
    }

    public URI getTraceResourceURI(TraceSource source) {
        return this.outputLocator.getTraceResourceURI((IFileSystemAccess)this.fsa, source);
    }

    protected Interface _getInterface(InterfaceReference iRef) {
        return iRef.getInterface();
    }

    protected Interface _getInterface(ComponentReference iRef) {
        return null;
    }

    public ArrayList<Resource> getResourcesFromDirs(List<FilePath> directories) {
        ArrayList<Resource> _xblockexpression = null;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (FilePath location : directories) {
            URI uri = GeneratorTask.resolveUri(this.resource, location.getPath());
            boolean _isPlatform = uri.isPlatform();
            if (_isPlatform) {
                String platform = uri.toPlatformString(true);
                IResource eclipseResource = ResourcesPlugin.getWorkspace().getRoot().findMember(platform);
                uri = URI.createFileURI((String)eclipseResource.getRawLocation().toOSString());
            }
            FilenameFilter traceFiler = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".traces") || name.endsWith(".events") || name.endsWith(".jsonl");
                }
            };
            String _fileString = uri.toFileString();
            File dir = new File(_fileString);
            if (dir.exists() && dir.isDirectory()) {
                File[] _listFiles;
                File[] fileArray = _listFiles = dir.listFiles(traceFiler);
                int n = _listFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    Resource res = this.resource.getResourceSet().getResource(URI.createFileURI((String)file.getPath()), true);
                    if (res != null) {
                        resources.add(res);
                    } else {
                        String _path = file.getPath();
                        String _plus = "Trace resource could not be loaded: " + _path;
                        String _plus_1 = String.valueOf(_plus) + ".";
                        this.errors.add(_plus_1);
                    }
                    ++n2;
                }
                continue;
            }
            String _path = dir.getPath();
            String _plus = "Trace dir did not exist or is not a directory. " + _path;
            this.errors.add(_plus);
        }
        _xblockexpression = resources;
        return _xblockexpression;
    }

    public static URI resolveUri(Resource context, String path) {
        URI contextURI = context.getURI();
        URI uri = URI.createFileURI((String)path);
        if (contextURI.isHierarchical() && !contextURI.isRelative() && uri.isRelative() && !uri.isEmpty()) {
            uri = uri.resolve(contextURI);
        }
        return uri;
    }

    public static void refreshWorkspaceProjects() {
        try {
            IProject[] _projects;
            boolean _tripleEquals;
            ResourcesPlugin _plugin = ResourcesPlugin.getPlugin();
            boolean bl = _tripleEquals = _plugin == null;
            if (_tripleEquals) {
                return;
            }
            IProject[] iProjectArray = _projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = _projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject r = iProjectArray[n2];
                r.refreshLocal(2, null);
                ++n2;
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void expandParams(List<Resource> resources) {
        for (Resource r : resources) {
            EList _contents = r.getContents();
            for (EObject element : _contents) {
                List sps = EcoreUtil2.getAllContentsOfType((EObject)element, StateParams.class);
                for (StateParams sp : sps) {
                    BasicEList parList = new BasicEList();
                    EList _params = sp.getParams();
                    for (Params par : _params) {
                        EList _value = par.getValue();
                        BasicEList _basicEList = new BasicEList();
                        parList.addAll(this.listParams((EList<ExpressionExtended>)_value, (EList<Expression>)_basicEList, 0));
                    }
                    sp.getParams().clear();
                    sp.getParams().addAll((Collection)parList);
                }
            }
        }
    }

    public EList<Params> listParams(EList<ExpressionExtended> eeLst, EList<Expression> eLst, int index) {
        BasicEList parLst = new BasicEList();
        EList _exps = ((ExpressionExtended)eeLst.get(index)).getExps();
        for (Expression e : _exps) {
            boolean _greaterThan;
            int _size = eeLst.size();
            int _minus = _size - 1;
            boolean bl = _greaterThan = _minus > index;
            if (_greaterThan) {
                EList<Expression> _expandAstrisk = this.expandAstrisk(e, index);
                for (Expression a : _expandAstrisk) {
                    BasicEList tmpLst = new BasicEList();
                    tmpLst.addAll(eLst);
                    tmpLst.add((Object)e);
                    parLst.addAll(this.listParams(eeLst, (EList<Expression>)tmpLst, index + 1));
                }
                continue;
            }
            parLst.addAll(this.createParams(e, eLst, index));
        }
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty((Iterable)((ExpressionExtended)eeLst.get(index)).getExps());
        if (_isNullOrEmpty) {
            boolean _greaterThan_1;
            int _size_1 = eeLst.size();
            int _minus_1 = _size_1 - 1;
            boolean bl = _greaterThan_1 = _minus_1 > index;
            if (_greaterThan_1) {
                EList<Expression> _expandAstrisk_1 = this.expandAstrisk(((ExpressionExtended)eeLst.get(index)).getExp(), index);
                for (Expression a_1 : _expandAstrisk_1) {
                    BasicEList tmpLst = new BasicEList();
                    tmpLst.addAll(eLst);
                    tmpLst.add((Object)a_1);
                    parLst.addAll(this.listParams(eeLst, (EList<Expression>)tmpLst, index + 1));
                }
            } else {
                parLst.addAll(this.createParams(((ExpressionExtended)eeLst.get(index)).getExp(), eLst, index));
            }
        }
        return parLst;
    }

    public EList<Params> createParams(Expression exp, EList<Expression> eLst, int index) {
        ParametersFactory parFac = ParametersFactory.eINSTANCE;
        BasicEList parLst = new BasicEList();
        EList<Expression> _expandAstrisk = this.expandAstrisk(exp, index);
        for (Expression a : _expandAstrisk) {
            Params par = parFac.createParams();
            for (Expression el : eLst) {
                ExpressionExtended newEe = parFac.createExpressionExtended();
                newEe.setExp((Expression)EcoreUtil.copy((EObject)el));
                par.getValue().add((Object)newEe);
            }
            ExpressionExtended newEe = parFac.createExpressionExtended();
            newEe.setExp((Expression)EcoreUtil.copy((EObject)a));
            par.getValue().add((Object)newEe);
            parLst.add((Object)par);
        }
        return parLst;
    }

    public EList<Expression> expandAstrisk(Expression expr, int index) {
        BasicEList exprLst = new BasicEList();
        if (expr instanceof ExpressionAny) {
            Expression e = expr;
            while (!(e instanceof EventParams)) {
                e = e.eContainer();
            }
            exprLst.addAll(this.getLiterals((EObject)e, index));
        } else {
            exprLst.add((Object)expr);
        }
        return exprLst;
    }

    protected EList<Expression> _getLiterals(TriggerParams params, int index) {
        return this.getLiterals((EObject)params.getEvent(), index);
    }

    protected EList<Expression> _getLiterals(NotificationParams params, int index) {
        return this.getLiterals((EObject)params.getEvent(), index);
    }

    protected EList<Expression> _getLiterals(ReplyParams params, int index) {
        TypeDecl _type = params.getEvent().getType().getType();
        if (_type instanceof EnumTypeDecl) {
            TypeDecl _type_1 = params.getEvent().getType().getType();
            EObject _eContainer = params.getEvent().eContainer();
            return this.getTriggerLiterals((EnumTypeDecl)_type_1, (Signature)_eContainer);
        }
        TypeDecl _type_2 = params.getEvent().getType().getType();
        EObject _eContainer_1 = params.getEvent().eContainer();
        return this.getTriggerLiterals((SimpleTypeDecl)_type_2, (Signature)_eContainer_1);
    }

    protected EList<Expression> _getLiterals(Command evt, int index) {
        TypeDecl _type = ((Parameter)evt.getParameters().get(index)).getType().getType();
        if (_type instanceof EnumTypeDecl) {
            TypeDecl _type_1 = ((Parameter)evt.getParameters().get(index)).getType().getType();
            EObject _eContainer = evt.eContainer();
            return this.getTriggerLiterals((EnumTypeDecl)_type_1, (Signature)_eContainer);
        }
        TypeDecl _type_2 = ((Parameter)evt.getParameters().get(index)).getType().getType();
        EObject _eContainer_1 = evt.eContainer();
        return this.getTriggerLiterals((SimpleTypeDecl)_type_2, (Signature)_eContainer_1);
    }

    protected EList<Expression> _getLiterals(Signal evt, int index) {
        TypeDecl _type = ((Parameter)evt.getParameters().get(index)).getType().getType();
        if (_type instanceof EnumTypeDecl) {
            TypeDecl _type_1 = ((Parameter)evt.getParameters().get(index)).getType().getType();
            EObject _eContainer = evt.eContainer();
            return this.getTriggerLiterals((EnumTypeDecl)_type_1, (Signature)_eContainer);
        }
        TypeDecl _type_2 = ((Parameter)evt.getParameters().get(index)).getType().getType();
        EObject _eContainer_1 = evt.eContainer();
        return this.getTriggerLiterals((SimpleTypeDecl)_type_2, (Signature)_eContainer_1);
    }

    protected EList<Expression> _getLiterals(Notification evt, int index) {
        TypeDecl _type = ((Parameter)evt.getParameters().get(index)).getType().getType();
        if (_type instanceof EnumTypeDecl) {
            TypeDecl _type_1 = ((Parameter)evt.getParameters().get(index)).getType().getType();
            EObject _eContainer = evt.eContainer();
            return this.getTriggerLiterals((EnumTypeDecl)_type_1, (Signature)_eContainer);
        }
        TypeDecl _type_2 = ((Parameter)evt.getParameters().get(index)).getType().getType();
        EObject _eContainer_1 = evt.eContainer();
        return this.getTriggerLiterals((SimpleTypeDecl)_type_2, (Signature)_eContainer_1);
    }

    public EList<Expression> getTriggerLiterals(EnumTypeDecl typ, Signature itf) {
        ExpressionFactory exprFac = ExpressionFactory.eINSTANCE;
        BasicEList exprLst = new BasicEList();
        EList _literals = typ.getLiterals();
        for (EnumElement lit : _literals) {
            ExpressionEnumLiteral eel = exprFac.createExpressionEnumLiteral();
            eel.setInterface(itf);
            eel.setLiteral(lit);
            eel.setType(typ);
            exprLst.add((Object)eel);
        }
        return exprLst;
    }

    public EList<Expression> getTriggerLiterals(SimpleTypeDecl typ, Signature itf) {
        ExpressionFactory exprFac = ExpressionFactory.eINSTANCE;
        BasicEList exprLst = new BasicEList();
        ExpressionConstantBool bTrue = exprFac.createExpressionConstantBool();
        bTrue.setValue(true);
        exprLst.add((Object)bTrue);
        ExpressionConstantBool bFalse = exprFac.createExpressionConstantBool();
        bFalse.setValue(false);
        exprLst.add((Object)bFalse);
        return exprLst;
    }

    public Interface getInterface(ExecutableSource iRef) {
        if (iRef instanceof ComponentReference) {
            return this._getInterface((ComponentReference)iRef);
        }
        if (iRef instanceof InterfaceReference) {
            return this._getInterface((InterfaceReference)iRef);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(iRef).toString());
    }

    public EList<Expression> getLiterals(EObject evt, int index) {
        if (evt instanceof Command) {
            return this._getLiterals((Command)evt, index);
        }
        if (evt instanceof Notification) {
            return this._getLiterals((Notification)evt, index);
        }
        if (evt instanceof Signal) {
            return this._getLiterals((Signal)evt, index);
        }
        if (evt instanceof NotificationParams) {
            return this._getLiterals((NotificationParams)evt, index);
        }
        if (evt instanceof ReplyParams) {
            return this._getLiterals((ReplyParams)evt, index);
        }
        if (evt instanceof TriggerParams) {
            return this._getLiterals((TriggerParams)evt, index);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(evt, index).toString());
    }
}

