/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.xtext.resource.impl.ProjectDescription;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.lib.Procedures;

public class TopologicalSorter {
    private LinkedHashSet<ProjectDescription> result;
    private Map<String, Entry> name2entry;
    private IAcceptor<ProjectDescription> cyclicAcceptor;

    public List<ProjectDescription> sortByDependencies(Iterable<ProjectDescription> descriptions, Procedures.Procedure1<? super ProjectDescription> cyclicAcceptor) {
        this.cyclicAcceptor = arg_0 -> cyclicAcceptor.apply(arg_0);
        this.name2entry = new LinkedHashMap<String, Entry>();
        for (ProjectDescription project : descriptions) {
            Entry entry = new Entry(project);
            this.name2entry.put(entry.description.getName(), entry);
        }
        this.result = new LinkedHashSet();
        this.name2entry.values().forEach(it -> this.visit((Entry)it));
        return Lists.newArrayList(this.result);
    }

    protected boolean visit(Entry current) {
        if (!this.result.contains(current.description) && !current.cyclic) {
            if (current.marked) {
                this.markCyclic(current);
                return false;
            }
            current.marked = true;
            for (String it : current.description.getDependencies()) {
                Entry depEntry = this.name2entry.get(it);
                if (depEntry == null || this.visit(depEntry)) continue;
                this.markCyclic(current);
                return false;
            }
            current.marked = false;
            this.result.add(current.description);
        }
        return true;
    }

    protected void markCyclic(Entry it) {
        if (!it.cyclic) {
            it.cyclic = true;
            this.cyclicAcceptor.accept((Object)it.description);
        }
    }

    protected static class Entry {
        private final ProjectDescription description;
        private boolean marked;
        private boolean cyclic;

        public String toString() {
            return this.description.getName();
        }

        public Entry(ProjectDescription description) {
            this.description = description;
        }
    }
}

