/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.core.PDECore;

public class IncrementalErrorReporter {
    private final IResource fResource;
    private final Collection<VirtualMarker> fReportedMarkers = new ArrayList<VirtualMarker>();
    private int fErrorCount;

    public IncrementalErrorReporter(IResource file) {
        this.fResource = file;
    }

    public VirtualMarker addMarker(String message, int lineNumber, int severity, int problemID, String category) {
        if (lineNumber == -1) {
            lineNumber = 1;
        }
        if (severity == 2) {
            ++this.fErrorCount;
        }
        VirtualMarker marker = new VirtualMarker();
        marker.setAttribute("problemId", problemID);
        marker.setAttribute("categoryId", category);
        marker.setAttribute("message", message);
        marker.setAttribute("severity", severity);
        marker.setAttribute("lineNumber", lineNumber);
        this.fReportedMarkers.add(marker);
        return marker;
    }

    public void applyMarkers() {
        IMarker[] existingMarkers;
        try {
            this.fResource.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
            existingMarkers = this.fResource.findMarkers("org.eclipse.pde.core.problem", false, 0);
        }
        catch (CoreException e) {
            PDECore.logException(e);
            existingMarkers = new IMarker[]{};
            try {
                this.fResource.deleteMarkers("org.eclipse.pde.core.problem", false, 0);
            }
            catch (CoreException e1) {
                PDECore.logException(e1);
            }
        }
        IMarker[] iMarkerArray = existingMarkers;
        int n = existingMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            boolean resolved = true;
            Map existingAttributes = null;
            Iterator<VirtualMarker> it = this.fReportedMarkers.iterator();
            while (it.hasNext()) {
                VirtualMarker reportedMarker = it.next();
                if (existingAttributes == null) {
                    try {
                        existingAttributes = marker.getAttributes();
                    }
                    catch (Exception e) {
                        PDECore.logException(e);
                        break;
                    }
                }
                if (!reportedMarker.getAttributes().equals(existingAttributes)) continue;
                resolved = false;
                it.remove();
                break;
            }
            if (resolved) {
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    PDECore.logException(e);
                }
            }
            ++n2;
        }
        for (VirtualMarker reportedMarker : this.fReportedMarkers) {
            try {
                this.fResource.createMarker("org.eclipse.pde.core.problem", reportedMarker.getAttributes());
            }
            catch (CoreException e) {
                PDECore.logException(e);
            }
        }
    }

    public int getErrorCount() {
        return this.fErrorCount;
    }

    public static class VirtualMarker {
        private final Map<String, Object> fAttributes = new HashMap<String, Object>();

        public void setAttribute(String key, Object value) {
            this.fAttributes.put(key, value);
        }

        public Map<String, Object> getAttributes() {
            return this.fAttributes;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("VirtualMarker [");
            if (this.fAttributes != null) {
                builder.append("attributes=");
                builder.append(this.fAttributes);
            }
            builder.append("]");
            return builder.toString();
        }
    }
}

