/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.shell;

import org.eclipse.concierge.shell.Shell;
import org.eclipse.concierge.shell.commands.ShellCommandGroup;
import org.osgi.framework.Bundle;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

final class PackageAdminCommandGroup
implements ShellCommandGroup {
    private PackageAdmin pkgAdmin;

    PackageAdminCommandGroup(Object obj) {
        this.pkgAdmin = (PackageAdmin)obj;
    }

    public String getGroup() {
        return "package";
    }

    public String getHelp() {
        return "\tpackage.{\n\t\tpackages [<bundleID>]\n\t\trefresh [bundleID]\n\t}";
    }

    public void handleCommand(String command, String[] args) {
        try {
            String cmd = command.intern();
            if (cmd == "packages") {
                Bundle bundle;
                if (args.length > 0) {
                    bundle = Shell.getBundle(args[0]);
                    if (bundle == null) {
                        return;
                    }
                } else {
                    bundle = null;
                }
                Shell.out.println("Packages:");
                ExportedPackage[] packages = this.pkgAdmin.getExportedPackages(bundle);
                if (packages == null) {
                    Shell.out.println("Package " + Shell.getBundle(args[0]).getBundleId() + " has no exported packages.");
                } else {
                    for (int i = 0; i < packages.length; ++i) {
                        Shell.out.println(packages[i]);
                    }
                }
                return;
            }
            if (cmd == "refresh") {
                Bundle[] bundles;
                if (args.length > 0) {
                    Bundle bundle = Shell.getBundle(args[0]);
                    if (bundle == null) {
                        return;
                    }
                    bundles = new Bundle[]{bundle};
                } else {
                    bundles = null;
                }
                this.pkgAdmin.refreshPackages(bundles);
            } else {
                Shell.err.println("Unknown command package." + cmd);
            }
        }
        catch (NumberFormatException nfe) {
            Shell.err.println("Illegal argument " + args[0]);
        }
    }
}

