/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge.shell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.concierge.shell.ShellActivator;
import org.eclipse.concierge.shell.commands.ShellCommandGroup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.BundleStartLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shell
extends Thread
implements ServiceListener {
    static boolean running;
    private Map<String, ShellCommandGroup> commandGroups = new HashMap<String, ShellCommandGroup>(1);
    private static final String[] EMPTY_STRING_ARRAY;
    static PrintStream out;
    static PrintStream err;
    private DefaultCommands defaultCommands;

    public Shell(PrintStream out, PrintStream err, ShellCommandGroup[] groups) {
        Shell.out = out;
        Shell.err = err;
        this.defaultCommands = new DefaultCommands();
        running = true;
        for (int i = 0; i < groups.length; ++i) {
            this.commandGroups.put(groups[i].getGroup(), groups[i]);
        }
        this.start();
    }

    @Override
    public void run() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            while (running) {
                out.print("\r\nConcierge> ");
                String s = in.readLine();
                if (s == null) {
                    running = false;
                }
                if (!running) continue;
                this.handleCommand(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace(err);
        }
    }

    private void handleCommand(String s) {
        try {
            String command;
            if (s.equals("")) {
                return;
            }
            int pos = s.indexOf(" ");
            String grcmd = pos > -1 ? s.substring(0, pos).toLowerCase() : s.toLowerCase();
            String[] args = pos > -1 ? this.getArgs(s.substring(pos + 1)) : EMPTY_STRING_ARRAY;
            pos = grcmd.indexOf(".");
            String group = pos > -1 ? grcmd.substring(0, pos) : "";
            String string = command = pos > -1 ? grcmd.substring(pos + 1) : grcmd;
            if (command.equals("help")) {
                out.println(this.defaultCommands.getHelp());
                ShellCommandGroup[] groups = this.commandGroups.values().toArray(new ShellCommandGroup[this.commandGroups.size()]);
                for (int i = 0; i < groups.length; ++i) {
                    out.println(groups[i].getHelp());
                }
                return;
            }
            if (group.equals("")) {
                this.defaultCommands.handleCommand(command, args);
            } else {
                ShellCommandGroup commandGroup = this.commandGroups.get(group);
                if (commandGroup != null) {
                    commandGroup.handleCommand(command, args);
                } else {
                    out.println("unknown comand group " + group);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(err);
        }
    }

    protected String[] getArgs(String args) {
        StringTokenizer tokenizer = new StringTokenizer(args, " ");
        ArrayList<String> result = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.startsWith("\"")) {
                StringBuffer buffer = new StringBuffer();
                buffer.append(token.substring(1));
                while (!token.endsWith("\"")) {
                    if (!tokenizer.hasMoreTokens()) {
                        throw new RuntimeException("Expression not well-formed.");
                    }
                    token = tokenizer.nextToken();
                    buffer.append(' ');
                    buffer.append(token);
                }
                token = buffer.substring(0, buffer.length() - 1);
            }
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    protected static Bundle getBundle(String bundleIdString) {
        int pos = bundleIdString.indexOf(" ");
        long bundleId = Long.parseLong(pos > -1 ? bundleIdString.substring(0, pos) : bundleIdString);
        Bundle bundle = ShellActivator.context.getBundle(bundleId);
        if (bundle == null) {
            err.println("Unknown bundle " + bundleId);
        }
        return bundle;
    }

    protected static ServiceReference<?> getServiceRef(String serviceIdString) {
        try {
            ServiceReference[] ref = ShellActivator.context.getServiceReferences((String)null, "(service.id=" + serviceIdString + ")");
            if (ref == null) {
                err.println("Unknown service " + serviceIdString);
                return null;
            }
            return ref[0];
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace(err);
            return null;
        }
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        int type = event.getType();
        if (type == 1) {
            ShellCommandGroup group = (ShellCommandGroup)ShellActivator.context.getService(ref);
            this.commandGroups.put(group.getGroup(), group);
            return;
        }
        if (type == 4) {
            ShellCommandGroup group = (ShellCommandGroup)ShellActivator.context.getService(ref);
            this.commandGroups.remove(group.getGroup());
            return;
        }
    }

    static {
        EMPTY_STRING_ARRAY = new String[0];
    }

    protected static final class DefaultCommands
    implements ShellCommandGroup {
        protected DefaultCommands() {
        }

        public String getGroup() {
            return "";
        }

        public String getHelp() {
            return "Concierge Shell:\n\tbundles\n\tservices [<bundle>]\n\tinstall <URL of bundle>\n\tstart <bundleId>\n\tstop <bundleId>\n\tupdate <bundleId> [<URL>]\n\tuninstall <bundleId>\n\theaders <bundleId>\n\tstartlevel <bundleId> [startlevel]\n\tproperties <serviceId>\n\tprintenv \n\trestart (framework)\n\texit (framework)\n\tquit (shell)\n";
        }

        public void handleCommand(String command, String[] args) {
            block82: {
                try {
                    if ("bundles".equals(command)) {
                        out.println("Bundles:");
                        StringBuffer buffer = new StringBuffer();
                        Bundle[] bundles = ShellActivator.context.getBundles();
                        for (int i = 0; i < bundles.length; ++i) {
                            buffer.append("[");
                            buffer.append(this.formatId(bundles[i].getBundleId()));
                            buffer.append("] ");
                            buffer.append(this.status(bundles[i].getState()));
                            buffer.append(" ");
                            buffer.append(this.nameOrLocation(bundles[i]));
                            buffer.append("\r\n");
                        }
                        out.println(buffer.toString());
                        return;
                    }
                    if ("services".equals(command)) {
                        out.println("Services:");
                        Bundle[] bundles = ShellActivator.context.getBundles();
                        StringBuffer buffer = new StringBuffer();
                        if (args.length == 0) {
                            for (int i = 0; i < bundles.length; ++i) {
                                ServiceReference[] refs = bundles[i].getRegisteredServices();
                                if (refs == null || refs.length <= 0) continue;
                                buffer.append(bundles[i] + "\n");
                                for (int j = 0; j < refs.length; ++j) {
                                    buffer.append("\t[Service ");
                                    buffer.append(refs[j].getProperty("service.id"));
                                    buffer.append("] ");
                                    buffer.append(Arrays.asList((Object[])refs[j].getProperty("objectClass")));
                                    buffer.append('\n');
                                }
                            }
                            out.println(buffer.toString());
                        } else {
                            Bundle bundle = Shell.getBundle(args[0]);
                            if (bundle == null) {
                                return;
                            }
                            ServiceReference[] refs = bundle.getRegisteredServices();
                            buffer.append(bundle + "\n");
                            if (refs != null && refs.length > 0) {
                                for (int i = 0; i < refs.length; ++i) {
                                    buffer.append("\t[Service ");
                                    buffer.append(refs[i].getProperty("service.id"));
                                    buffer.append("] ");
                                    buffer.append(Arrays.asList((Object[])refs[i].getProperty("objectClass")));
                                    buffer.append("\n");
                                }
                            } else {
                                buffer.append("\t<none>\n");
                            }
                            out.println(buffer.toString());
                        }
                        return;
                    }
                    if ("properties".equals(command)) {
                        if (args.length > 0) {
                            ServiceReference<?> ref = Shell.getServiceRef(args[0]);
                            if (ref == null) {
                                return;
                            }
                            String[] keys = ref.getPropertyKeys();
                            out.println("Service [" + args[0] + "]:");
                            for (int i = 0; i < keys.length; ++i) {
                                List<Object> value = ref.getProperty(keys[i]);
                                if (value.getClass().isArray()) {
                                    value = Arrays.asList((Object[])value);
                                }
                                out.println("\t'" + keys[i] + "' = '" + value + "'");
                            }
                        } else {
                            err.println("Missing argument <serviceId>");
                        }
                        break block82;
                    }
                    if ("filter".equals(command)) {
                        if (args.length == 1) {
                            ServiceReference[] refs = ShellActivator.context.getServiceReferences((String)null, args[0]);
                            if (refs != null && refs.length > 0) {
                                for (int j = 0; j < refs.length; ++j) {
                                    out.println("\t[" + refs[j].getProperty("service.id") + "] " + Arrays.asList((Object[])refs[j].getProperty("objectClass")));
                                }
                            }
                        } else {
                            out.println("Usage: filter <filterExpression>");
                        }
                        break block82;
                    }
                    if ("install".equals(command)) {
                        if (args.length > 0) {
                            try {
                                ShellActivator.context.installBundle(args[0]);
                            }
                            catch (Exception e) {
                                err.println("Invalid bundle location or bundle content " + args[0]);
                            }
                        } else {
                            err.println("Missing argument <bundleURL>");
                        }
                        return;
                    }
                    if ("start".equals(command)) {
                        if (args.length > 0) {
                            Bundle bundle = Shell.getBundle(args[0]);
                            if (bundle != null) {
                                try {
                                    bundle.start();
                                }
                                catch (BundleException be) {
                                    be.printStackTrace();
                                    Throwable t = be.getNestedException();
                                    if (t != null) {
                                        System.err.println("Nested exception:");
                                        t.printStackTrace();
                                    }
                                    return;
                                }
                                out.println(bundle.toString() + " started.");
                            }
                        } else {
                            err.println("Missing argument <bundleId>");
                        }
                        return;
                    }
                    if ("stop".equals(command)) {
                        if (args.length > 0) {
                            Bundle bundle = Shell.getBundle(args[0]);
                            if (bundle != null) {
                                bundle.stop();
                                System.out.println(bundle.toString() + " stopped.");
                            }
                        } else {
                            err.println("Missing argument <bundleId>");
                        }
                        return;
                    }
                    if ("uninstall".equals(command)) {
                        if (args.length > 0) {
                            Bundle bundle = Shell.getBundle(args[0]);
                            if (bundle != null) {
                                bundle.uninstall();
                                out.println(bundle.toString() + " uninstalled.");
                            }
                        } else {
                            System.err.println("Missing argument <bundleId>");
                        }
                        return;
                    }
                    if ("update".equals(command)) {
                        if (args.length == 1) {
                            Bundle bundle = Shell.getBundle(args[0]);
                            if (bundle != null) {
                                try {
                                    bundle.update();
                                }
                                catch (Exception e) {
                                    err.println("Update failed:");
                                    err.println(e.getMessage());
                                    if (e.getCause() != null) {
                                        err.println(e.getCause().getMessage());
                                    }
                                    return;
                                }
                                out.println(bundle.toString() + " updated.");
                            }
                        } else if (args.length > 1) {
                            Bundle bundle = Shell.getBundle(args[0]);
                            if (bundle != null) {
                                bundle.update(new URL(args[1]).openStream());
                                out.println(bundle.toString() + " updated.");
                            }
                        } else {
                            err.println("Missing argument <bundleId>");
                        }
                        return;
                    }
                    if ("headers".equals(command)) {
                        if (args.length > 0) {
                            Bundle bundle = Shell.getBundle(args[0]);
                            if (bundle != null) {
                                Dictionary dict = bundle.getHeaders();
                                StringBuffer buffer = new StringBuffer();
                                buffer.append("Headers for " + bundle + ":\n");
                                Enumeration en = dict.keys();
                                while (en.hasMoreElements()) {
                                    Object key = en.nextElement();
                                    buffer.append("\t" + key + " = " + (String)dict.get(key) + "\n");
                                }
                                out.println(buffer.toString());
                            }
                        } else {
                            err.println("Missing argument <bundleId>");
                        }
                        return;
                    }
                    if ("startlevel".equals(command)) {
                        if (args.length > 0) {
                            Bundle bundle = Shell.getBundle(args[0]);
                            if (bundle != null) {
                                BundleStartLevel bsl = (BundleStartLevel)bundle.adapt(BundleStartLevel.class);
                                if (args.length > 1) {
                                    try {
                                        bsl.setStartLevel(Integer.parseInt(args[1]));
                                    }
                                    catch (IllegalArgumentException e) {
                                        err.println("Invalid start level " + args[1]);
                                        return;
                                    }
                                }
                                StringBuffer buffer = new StringBuffer();
                                buffer.append("Startlevel for " + bundle + ": ");
                                buffer.append(bsl.getStartLevel());
                                out.println(buffer.toString());
                            }
                        } else {
                            err.println("Missing argument <bundleId>");
                        }
                        return;
                    }
                    if ("restart".equals(command)) {
                        try {
                            ShellActivator.context.getBundle(0L).update();
                        }
                        catch (BundleException e) {
                            e.printStackTrace();
                        }
                        break block82;
                    }
                    if ("quit".equals(command)) {
                        try {
                            ShellActivator.context.getBundle().stop();
                        }
                        catch (BundleException e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                    if ("exit".equals(command)) {
                        try {
                            ShellActivator.context.getBundle(0L).stop();
                        }
                        catch (BundleException e) {
                            e.printStackTrace();
                        }
                        running = false;
                        return;
                    }
                    if ("printenv".equals(command)) {
                        String[] keys = System.getProperties().keySet().toArray(new String[System.getProperties().size()]);
                        for (int i = 0; i < keys.length; ++i) {
                            String val = System.getProperty(keys[i]);
                            out.println(keys[i] + " = " + val);
                        }
                    } else {
                        out.println("unknown command " + command);
                    }
                }
                catch (BundleException be) {
                    be.printStackTrace(err);
                }
                catch (NumberFormatException nfe) {
                    err.println("Illegal argument " + args[0]);
                }
                catch (MalformedURLException e) {
                    err.println("Malformed URL " + args[1]);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(err);
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace(err);
                }
            }
        }

        private String formatId(long id) {
            return id < 10L ? " " + id : "" + id;
        }

        private String nameOrLocation(Bundle b) {
            Object name = b.getHeaders().get("Bundle-Name");
            return name != null ? name.toString() : b.getLocation();
        }

        private String status(int state) {
            switch (state) {
                case 32: {
                    return "(active)";
                }
                case 2: {
                    return "(installed)";
                }
                case 4: {
                    return "(resolved)";
                }
                case 8: {
                    return "(starting)   ";
                }
                case 16: {
                    return "(stopping)";
                }
                case 1: {
                    return "(uninstalled)";
                }
            }
            return null;
        }
    }
}

