/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.io.File;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.concierge.BundleImpl;
import org.eclipse.concierge.Concierge;
import org.eclipse.concierge.ServiceReferenceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleRevisions;
import org.osgi.framework.wiring.BundleWiring;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBundle
implements Bundle,
BundleRevisions {
    protected static final short AUTOSTART_STOPPED = 0;
    protected static final short AUTOSTART_STARTED_WITH_DECLARED = 1;
    protected static final short AUTOSTART_STARTED_WITH_EAGER = 2;
    protected long bundleId;
    protected ArrayList<BundleRevision> revisions = new ArrayList();
    protected BundleImpl.Revision currentRevision;
    protected String location;
    protected int state;
    protected long lastModified;
    protected List<ServiceReference<?>> registeredServices;
    protected String storageLocation;
    protected int startlevel;
    protected short autostart = 0;
    protected Concierge.BundleContextImpl context;
    protected ProtectionDomain domain;
    protected List<FrameworkListener> registeredFrameworkListeners;
    protected List<Concierge.ServiceListenerEntry> registeredServiceListeners;

    @Override
    public final int getState() {
        return this.state;
    }

    @Override
    public final long getBundleId() {
        return this.bundleId;
    }

    @Override
    public final String getLocation() {
        if (this.isSecurityEnabled()) {
            // empty if block
        }
        return this.location;
    }

    @Override
    public final ServiceReference<?>[] getRegisteredServices() {
        if (this.state == 1) {
            throw new IllegalStateException("Bundle " + this.toString() + "has been uninstalled.");
        }
        if (this.registeredServices == null) {
            return null;
        }
        if (this.isSecurityEnabled()) {
            return AbstractBundle.checkPermissions(this.registeredServices.toArray(new ServiceReferenceImpl[this.registeredServices.size()]));
        }
        return this.registeredServices.toArray(new ServiceReference[this.registeredServices.size()]);
    }

    @Override
    public final boolean hasPermission(Object permission) {
        this.checkBundleNotUninstalled();
        if (this.isSecurityEnabled()) {
            return permission instanceof Permission ? this.domain.getPermissions().implies((Permission)permission) : false;
        }
        return true;
    }

    @Override
    public final long getLastModified() {
        return this.lastModified;
    }

    @Override
    public final BundleContext getBundleContext() {
        if (this.isSecurityEnabled()) {
            // empty if block
        }
        if (this.state == 8 || this.state == 32 || this.state == 16) {
            return this.context;
        }
        return null;
    }

    @Override
    public <A> A adapt(Class<A> type) {
        if (type.isInstance(this)) {
            return (A)this;
        }
        if (type == BundleContext.class) {
            return (A)this.context;
        }
        if (type == BundleRevision.class) {
            return (A)this.currentRevision;
        }
        if (type == BundleWiring.class) {
            return (A)(this.currentRevision != null ? this.currentRevision.getWiring() : null);
        }
        return null;
    }

    @Override
    public final int compareTo(Bundle o) {
        return (int)(o.getBundleId() - this.bundleId);
    }

    @Override
    public final List<BundleRevision> getRevisions() {
        return Collections.unmodifiableList(this.revisions);
    }

    @Override
    public final Bundle getBundle() {
        return this;
    }

    @Override
    public final File getDataFile(String filename) {
        if (this.context != null) {
            return this.context.getDataFile(filename);
        }
        return null;
    }

    protected abstract boolean isSecurityEnabled();

    protected final void updateLastModified() {
        long newMod = System.currentTimeMillis();
        this.lastModified = newMod > this.lastModified ? newMod : (this.lastModified = this.lastModified + 1L);
    }

    protected static final ServiceReference<?>[] checkPermissions(ServiceReferenceImpl<?>[] refs) {
        ArrayList<ServiceReferenceImpl<?>[]> results = new ArrayList<ServiceReferenceImpl<?>[]>(refs.length);
        AccessControlContext controller = AccessController.getContext();
        block2: for (int i = 0; i < refs.length; ++i) {
            String[] interfaces = (String[])refs[i].properties.get("objectClass");
            for (int j = 0; j < interfaces.length; ++j) {
                try {
                    controller.checkPermission(new ServicePermission(interfaces[j], "get"));
                    results.add(refs);
                    continue block2;
                }
                catch (SecurityException securityException) {
                    continue;
                }
            }
        }
        return results.toArray(new ServiceReference[results.size()]);
    }

    protected final void checkBundleNotUninstalled() throws IllegalArgumentException {
        if (this.state == 1) {
            throw new IllegalArgumentException("Bundle " + this.toString() + " has been uninstalled");
        }
    }
}

