/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface ConciergeCollections {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeltaTrackingRemoveOnlyList<E>
    extends RemoveOnlyList<E> {
        private final ArrayList<E> removed = new ArrayList();
        private static final long serialVersionUID = 2467542232248099702L;

        public DeltaTrackingRemoveOnlyList(Collection<E> result) {
            super(result);
        }

        @Override
        public boolean remove(Object o) {
            boolean modified = super.remove(o);
            if (modified) {
                this.removed.add(o);
            }
            return modified;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            for (Object o : c) {
                modified |= this.remove(o);
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean modified = false;
            for (Object e : this) {
                if (c.contains(e)) continue;
                this.remove(e);
                modified = true;
            }
            return modified;
        }

        public List<E> getRemoved() {
            return this.removed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveOnlyList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = -2126964539821583131L;

        public RemoveOnlyList(Collection<? extends E> result) {
            super(result);
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException("add");
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException("addAll");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveOnlyMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = -3743325895136799794L;
        private boolean sealed;

        @Override
        public V put(K key, V value) {
            if (this.sealed) {
                throw new UnsupportedOperationException("put");
            }
            return super.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException("putAll");
        }

        void seal() {
            this.sealed = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParseResult
    extends Tuple<HashMap<String, String>, HashMap<String, Object>> {
        public ParseResult(HashMap<String, String> directives, HashMap<String, Object> attributes) {
            super(directives, attributes);
        }

        public HashMap<String, String> getDirectives() {
            return (HashMap)this.getFormer();
        }

        public HashMap<String, Object> getAttributes() {
            return (HashMap)this.getLatter();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Tuple<T1, T2> {
        private final T1 former;
        private final T2 latter;

        public Tuple(T1 former, T2 latter) {
            this.former = former;
            this.latter = latter;
        }

        public T1 getFormer() {
            return this.former;
        }

        public T2 getLatter() {
            return this.latter;
        }

        public String toString() {
            return "<" + this.former + ", " + this.latter + ">";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiMap<K, V>
    implements Map<K, List<V>> {
        protected final HashMap<K, List<V>> map;
        protected final LinkedHashSet<V> allValues = new LinkedHashSet();
        private final Comparator<V> comp;
        boolean dirty = false;

        public MultiMap() {
            this.map = new HashMap();
            this.comp = null;
        }

        public MultiMap(int initialSize) {
            this.map = new HashMap(initialSize);
            this.comp = null;
        }

        public MultiMap(MultiMap<K, ? extends V> existing) {
            this();
            this.insertMap(existing);
        }

        public MultiMap(Comparator<V> comp) {
            this.map = new HashMap();
            this.comp = comp;
        }

        HashMap<K, List<V>> getFlatMap() {
            return this.map;
        }

        public void insert(K key, V value) {
            List<V> list = this.map.get(key);
            if (list == null) {
                list = new ArrayList<V>();
                this.map.put(key, list);
            }
            list.add(value);
            if (this.comp != null) {
                Collections.sort(list, this.comp);
            }
            if (!this.dirty) {
                this.allValues.add(value);
            }
        }

        public void insertEmpty(K key) {
            List<V> list = this.map.get(key);
            if (list == null) {
                list = new ArrayList<V>();
                this.map.put(key, list);
            }
        }

        public void insertUnique(K key, V value) {
            List<V> list = this.map.get(key);
            if (list == null) {
                list = new ArrayList<V>();
                this.map.put(key, list);
            }
            if (!list.contains(value)) {
                list.add(value);
                if (this.comp != null) {
                    Collections.sort(list, this.comp);
                }
                if (!this.dirty) {
                    this.allValues.add(value);
                }
            }
        }

        public void insertAll(K key, Collection<? extends V> values) {
            List<V> list = this.map.get(key);
            if (list == null) {
                list = new ArrayList<V>();
                this.map.put(key, list);
            }
            list.addAll(values);
            if (this.comp != null) {
                Collections.sort(list, this.comp);
            }
            if (!this.dirty) {
                this.allValues.addAll(values);
            }
        }

        public void insertMap(MultiMap<K, ? extends V> existing) {
            for (K key : existing.keySet()) {
                Object vals = existing.get(key);
                this.insertAll(key, (Collection<? extends V>)vals);
            }
        }

        @Override
        public List<V> get(Object key) {
            return this.map.get(key);
        }

        public int indexOf(K key, V value) {
            Object list = this.get(key);
            return list == null ? -1 : list.indexOf(value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            Object list = this.get(key);
            if (list != null) {
                boolean result = list.remove(value);
                if (result) {
                    this.dirty = true;
                }
                return result;
            }
            return false;
        }

        @Override
        public List<V> remove(Object key) {
            List<V> values = this.map.remove(key);
            if (values == null) {
                return null;
            }
            this.dirty = true;
            return values;
        }

        public List<V> lookup(K key) {
            Object result = this.get(key);
            return result == null ? Collections.emptyList() : result;
        }

        protected void redoAllValues() {
            this.allValues.clear();
            for (List<V> valueList : this.values()) {
                this.allValues.addAll(valueList);
            }
            this.dirty = false;
        }

        public List<V> getAllValues() {
            if (this.dirty) {
                this.redoAllValues();
            }
            return new ArrayList<V>(this.allValues);
        }

        public void removeAll(K[] keys, V value) {
            for (int i = 0; i < keys.length; ++i) {
                Object list = this.get(keys[i]);
                if (list == null) continue;
                list.remove(value);
            }
            this.dirty = true;
        }

        @Override
        public Set<K> keySet() {
            return new KeySet();
        }

        public String toString() {
            return "MultiMap " + this.map.toString();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            if (this.dirty) {
                this.redoAllValues();
            }
            return this.allValues.contains(value);
        }

        @Override
        public List<V> put(K key, List<V> value) {
            throw new UnsupportedOperationException("put");
        }

        @Override
        public void putAll(Map<? extends K, ? extends List<V>> m) {
            throw new UnsupportedOperationException("putAll");
        }

        @Override
        public void clear() {
            this.map.clear();
            this.allValues.clear();
            this.dirty = false;
        }

        @Override
        public Collection<List<V>> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<K, List<V>>> entrySet() {
            return this.map.entrySet();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class KeySet
        extends AbstractSet<K> {
            private final Set<K> keySet;

            protected KeySet() {
                this.keySet = MultiMap.this.map.keySet();
            }

            @Override
            public Iterator<K> iterator() {
                final Iterator inner = this.keySet.iterator();
                return new Iterator<K>(){
                    private K element;

                    @Override
                    public boolean hasNext() {
                        return inner.hasNext();
                    }

                    @Override
                    public K next() {
                        this.element = inner.next();
                        return this.element;
                    }

                    @Override
                    public void remove() {
                        MultiMap.this.remove(this.element);
                    }
                };
            }

            @Override
            public int size() {
                return MultiMap.this.map.size();
            }

            @Override
            public boolean contains(Object key) {
                return MultiMap.this.containsKey(key);
            }

            @Override
            public boolean remove(Object key) {
                boolean result;
                boolean bl = result = MultiMap.this.remove(key) != null;
                if (result) {
                    MultiMap.this.dirty = true;
                }
                return result;
            }

            @Override
            public void clear() {
                MultiMap.this.clear();
                MultiMap.this.allValues.clear();
                MultiMap.this.dirty = false;
            }
        }
    }
}

