/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.concierge.AbstractBundle;
import org.eclipse.concierge.BundleImpl;
import org.eclipse.concierge.Concierge;
import org.eclipse.concierge.ConciergeCollections;
import org.eclipse.concierge.RFC1960Filter;
import org.eclipse.concierge.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;

public class Resources {
    static Wire createWire(Capability cap, Requirement req) {
        return cap instanceof BundleCapability && req instanceof BundleRequirement ? new ConciergeBundleWire((BundleCapability)cap, (BundleRequirement)req) : new ConciergeWire(cap, req);
    }

    static Wiring createWiring() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConciergeBundleWiring
    implements BundleWiring {
        protected final BundleRevision revision;
        private final ConciergeCollections.MultiMap<String, BundleCapability> capabilities = new ConciergeCollections.MultiMap();
        private final ConciergeCollections.MultiMap<String, BundleRequirement> requirements = new ConciergeCollections.MultiMap();
        private final Comparator<BundleWire> provComp = new Comparator<BundleWire>(){

            @Override
            public int compare(BundleWire w1, BundleWire w2) {
                BundleCapability cap1 = w1.getCapability();
                BundleCapability cap2 = w2.getCapability();
                assert (cap1.getNamespace().equals(cap2.getNamespace()));
                List<Capability> caps = ConciergeBundleWiring.this.revision.getCapabilities(cap1.getNamespace());
                return caps.indexOf(cap1) - caps.indexOf(cap2);
            }
        };
        private final Comparator<BundleWire> reqComp = new Comparator<BundleWire>(){

            @Override
            public int compare(BundleWire w1, BundleWire w2) {
                BundleRequirement req1 = w1.getRequirement();
                BundleRequirement req2 = w2.getRequirement();
                assert (req1.getNamespace().equals(req2.getNamespace()));
                List<Requirement> reqs = ConciergeBundleWiring.this.revision.getRequirements(req1.getNamespace());
                return reqs.indexOf(req1) - reqs.indexOf(req2);
            }
        };
        private final ConciergeCollections.MultiMap<String, BundleWire> providedWires = new ConciergeCollections.MultiMap(this.provComp);
        private final ConciergeCollections.MultiMap<String, BundleWire> requiredWires = new ConciergeCollections.MultiMap(this.reqComp);
        final HashSet<BundleRevision> inUseSet = new HashSet();

        ConciergeBundleWiring(BundleRevision revision, List<Wire> wires) {
            String effective;
            this.revision = revision;
            HashSet<Requirement> reqCache = new HashSet<Requirement>();
            if (wires != null) {
                for (Wire wire : wires) {
                    this.addWire((BundleWire)wire);
                    if (wire.getRequirer() != revision) continue;
                    reqCache.add(wire.getRequirement());
                }
            }
            for (BundleCapability cap : revision.getDeclaredCapabilities(null)) {
                effective = cap.getDirectives().get("effective");
                if (effective != null && !"resolve".equals(effective)) continue;
                this.capabilities.insert(cap.getNamespace(), cap);
            }
            if (revision.getTypes() == 1) {
                this.capabilities.remove("osgi.identity");
            }
            for (BundleRequirement req : revision.getDeclaredRequirements(null)) {
                effective = req.getDirectives().get("effective");
                boolean optional = "optional".equals(req.getDirectives().get("resolution"));
                if (effective != null && !"resolve".equals(effective) && !"dynamic".equals(req.getDirectives().get("resolution")) || optional && !reqCache.contains(req)) continue;
                this.requirements.insert(req.getNamespace(), req);
            }
        }

        void addWire(BundleWire wire) {
            BundleCapability cap = wire.getCapability();
            BundleRequirement req = wire.getRequirement();
            if (wire.getProvider() == this.revision) {
                this.providedWires.insert(cap.getNamespace(), wire);
                this.inUseSet.add(wire.getRequirer());
                ((ConciergeBundleWire)wire).providerWiring = this;
            } else {
                this.requiredWires.insert(req.getNamespace(), wire);
                if ("osgi.wiring.host".equals(wire.getRequirement().getNamespace())) {
                    this.inUseSet.add(wire.getProvider());
                }
                ((ConciergeBundleWire)wire).requirerWiring = this;
            }
        }

        HashMap<String, BundleWire> getPackageImportWires() {
            List<BundleWire> list = this.getRequiredWires("osgi.wiring.package");
            HashMap<String, BundleWire> result = new HashMap<String, BundleWire>();
            if (list != null) {
                for (BundleWire wire : list) {
                    result.put((String)wire.getCapability().getAttributes().get("osgi.wiring.package"), wire);
                }
            }
            return result;
        }

        List<BundleWire> getRequireBundleWires() {
            return this.getRequiredWires("osgi.wiring.bundle");
        }

        @Override
        public Bundle getBundle() {
            return this.revision.getBundle();
        }

        @Override
        public boolean isCurrent() {
            if (this.revision.getBundle().getBundleId() == 0L) {
                return true;
            }
            return ((AbstractBundle)this.revision.getBundle()).currentRevision == this.revision && this.revision.getWiring() == this;
        }

        void cleanup() {
            ConciergeBundleWiring bw;
            for (BundleWire requiredWire : this.requiredWires.getAllValues()) {
                bw = ((ConciergeBundleWire)requiredWire).providerWiring;
                if (bw == null) continue;
                bw.inUseSet.remove(this.revision);
            }
            for (BundleWire hostWire : this.providedWires.lookup("osgi.wiring.host")) {
                bw = ((ConciergeBundleWire)hostWire).requirerWiring;
                if (bw == null) continue;
                bw.inUseSet.remove(this.revision);
            }
        }

        @Override
        public boolean isInUse() {
            return this.isCurrent() || !this.inUseSet.isEmpty();
        }

        @Override
        public List<BundleCapability> getCapabilities(String namespace) {
            if (!this.isInUse()) {
                return null;
            }
            return namespace == null ? this.capabilities.getAllValues() : this.capabilities.lookup(namespace);
        }

        @Override
        public List<BundleRequirement> getRequirements(String namespace) {
            if (!this.isInUse()) {
                return null;
            }
            return namespace == null ? this.requirements.getAllValues() : this.requirements.lookup(namespace);
        }

        @Override
        public List<BundleWire> getProvidedWires(String namespace) {
            if (!this.isInUse()) {
                return null;
            }
            return namespace == null ? this.providedWires.getAllValues() : this.providedWires.lookup(namespace);
        }

        @Override
        public List<BundleWire> getRequiredWires(String namespace) {
            if (!this.isInUse()) {
                return null;
            }
            return namespace == null ? this.requiredWires.getAllValues() : this.requiredWires.lookup(namespace);
        }

        @Override
        public BundleRevision getRevision() {
            return this.revision;
        }

        @Override
        public ClassLoader getClassLoader() {
            if (!this.isInUse()) {
                return null;
            }
            if (this.revision instanceof BundleImpl.Revision) {
                return ((BundleImpl.Revision)this.revision).classloader;
            }
            return null;
        }

        @Override
        public List<URL> findEntries(String path, String filePattern, int options) {
            if (!this.isInUse()) {
                return null;
            }
            Enumeration<URL> result = null;
            if (this.revision instanceof BundleImpl.Revision) {
                BundleImpl.Revision rev = (BundleImpl.Revision)this.revision;
                result = rev.findEntries(path, filePattern, options == 1);
            }
            return result == null ? Collections.emptyList() : Collections.unmodifiableList(Collections.list(result));
        }

        @Override
        public Collection<String> listResources(String path, String filePattern, int options) {
            if (!this.isInUse()) {
                return null;
            }
            return Collections.unmodifiableSet(((BundleImpl.Revision)this.revision).classloader.listResources(path, filePattern, options, new HashSet<String>()));
        }

        @Override
        public List<Capability> getResourceCapabilities(String namespace) {
            List<BundleCapability> bcaps = this.getCapabilities(namespace);
            return bcaps == null ? null : new ArrayList<BundleCapability>(bcaps);
        }

        @Override
        public List<Requirement> getResourceRequirements(String namespace) {
            List<BundleRequirement> breqs = this.getRequirements(namespace);
            return breqs == null ? null : new ArrayList<BundleRequirement>(breqs);
        }

        @Override
        public List<Wire> getProvidedResourceWires(String namespace) {
            List<BundleWire> bwires = this.getProvidedWires(namespace);
            return bwires == null ? null : new ArrayList<BundleWire>(bwires);
        }

        @Override
        public List<Wire> getRequiredResourceWires(String namespace) {
            List<BundleWire> bwires = this.getRequiredWires(namespace);
            return bwires == null ? null : new ArrayList<BundleWire>(bwires);
        }

        @Override
        public BundleRevision getResource() {
            return this.revision;
        }

        void addCapability(HostedCapability hostedCap) {
            this.capabilities.insert(hostedCap.getNamespace(), (BundleCapability)hostedCap.getDeclaredCapability());
        }

        public String toString() {
            return "[ConciergeBundleWiring of " + this.revision + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConciergeWiring
    implements Wiring {
        private final Resource resource;
        private final ConciergeCollections.MultiMap<String, Capability> capabilities = new ConciergeCollections.MultiMap();
        private final ConciergeCollections.MultiMap<String, Requirement> requirements = new ConciergeCollections.MultiMap();
        private final ConciergeCollections.MultiMap<String, Wire> providedWires = new ConciergeCollections.MultiMap();
        private final ConciergeCollections.MultiMap<String, Wire> requiredWires = new ConciergeCollections.MultiMap();

        ConciergeWiring(Resource resource, List<Wire> wires) {
            this.resource = resource;
            for (Wire wire : wires) {
                this.addWire(wire);
            }
        }

        private void addWire(Wire wire) {
            if (wire.getProvider() == this.resource) {
                Capability cap = wire.getCapability();
                this.capabilities.insertUnique(cap.getNamespace(), cap);
                this.providedWires.insert(cap.getNamespace(), wire);
            } else {
                Requirement req = wire.getRequirement();
                this.requirements.insertUnique(req.getNamespace(), req);
                this.requiredWires.insert(req.getNamespace(), wire);
            }
        }

        @Override
        public List<Capability> getResourceCapabilities(String namespace) {
            return namespace == null ? this.capabilities.getAllValues() : this.capabilities.lookup(namespace);
        }

        @Override
        public List<Requirement> getResourceRequirements(String namespace) {
            return namespace == null ? this.requirements.getAllValues() : this.requirements.lookup(namespace);
        }

        @Override
        public List<Wire> getProvidedResourceWires(String namespace) {
            return namespace == null ? this.providedWires.getAllValues() : this.providedWires.lookup(namespace);
        }

        @Override
        public List<Wire> getRequiredResourceWires(String namespace) {
            return namespace == null ? this.requiredWires.getAllValues() : this.requiredWires.lookup(namespace);
        }

        @Override
        public Resource getResource() {
            return this.resource;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConciergeBundleWire
    extends AbstractWireImpl<BundleCapability, BundleRequirement>
    implements BundleWire {
        ConciergeBundleWiring providerWiring;
        ConciergeBundleWiring requirerWiring;

        protected ConciergeBundleWire(BundleCapability capability, BundleRequirement requirement) {
            super(capability, requirement);
        }

        @Override
        public BundleWiring getProviderWiring() {
            if (this.providerWiring == null) {
                this.providerWiring = (ConciergeBundleWiring)this.getProvider().getWiring();
            }
            return this.providerWiring;
        }

        @Override
        public BundleWiring getRequirerWiring() {
            return this.requirerWiring;
        }

        @Override
        public BundleRevision getProvider() {
            return ((BundleCapability)this.capability).getResource();
        }

        @Override
        public BundleRevision getRequirer() {
            return ((BundleRequirement)this.requirement).getResource();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConciergeWire
    extends AbstractWireImpl<Capability, Requirement> {
        protected ConciergeWire(Capability capability, Requirement requirement) {
            super(capability, requirement);
        }

        @Override
        public Resource getProvider() {
            return this.capability.getResource();
        }

        @Override
        public Resource getRequirer() {
            return this.requirement.getResource();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractWireImpl<C extends Capability, R extends Requirement>
    implements Wire {
        protected final C capability;
        protected final R requirement;

        protected AbstractWireImpl(C capability, R requirement) {
            this.capability = capability;
            this.requirement = requirement;
        }

        public C getCapability() {
            if (this.capability instanceof HostedCapability) {
                Capability declared = ((HostedCapability)this.capability).getDeclaredCapability();
                return (C)declared;
            }
            return this.capability;
        }

        public R getRequirement() {
            return this.requirement;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof AbstractWireImpl) {
                return o == this;
            }
            if (o instanceof Wire) {
                Wire w = (Wire)o;
                return w.getRequirer().equals(this.requirement.getResource()) && w.getRequirement().equals(this.requirement) && w.getProvider().equals(this.capability.getResource()) && w.getCapability().equals(this.capability);
            }
            return false;
        }

        public String toString() {
            return "{" + this.requirement + "->" + this.capability + "}";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HostedBundleCapability
    implements HostedCapability,
    BundleCapability {
        private final BundleRevision host;
        private final BundleCapability cap;

        HostedBundleCapability(BundleRevision host, Capability cap) {
            this.host = host;
            this.cap = (BundleCapability)cap;
        }

        @Override
        public String getNamespace() {
            return this.cap.getNamespace();
        }

        @Override
        public Map<String, String> getDirectives() {
            return this.cap.getDirectives();
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this.cap.getAttributes();
        }

        @Override
        public BundleRevision getResource() {
            return this.host;
        }

        @Override
        public Capability getDeclaredCapability() {
            return this.cap;
        }

        @Override
        public BundleRevision getRevision() {
            return this.host;
        }

        public String toString() {
            return "HostedCapability{host=" + this.host + ", cap=" + this.cap + ")";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BundleRequirementImpl
    extends GenericReqCap
    implements BundleRequirement {
        private final BundleRevision revision;
        private final String prettyPrint;

        public BundleRequirementImpl(BundleRevision revision, String str) throws BundleException {
            super(str);
            this.revision = revision;
            this.prettyPrint = null;
        }

        public BundleRequirementImpl(BundleRevision revision, String namespace, Map<String, String> directives, Map<String, Object> attributes, String prettyPrint) {
            super(namespace, directives, attributes);
            this.revision = revision;
            this.prettyPrint = "BundleRequirement{" + prettyPrint + "}";
        }

        @Override
        public BundleRevision getRevision() {
            return this.revision;
        }

        @Override
        public BundleRevision getResource() {
            return this.revision;
        }

        @Override
        public boolean matches(BundleCapability capability) {
            return Concierge.matches(this, capability);
        }

        @Override
        public String toString() {
            return this.prettyPrint == null ? "BundleRequirement {" + super.toString() + "}" : this.prettyPrint;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BundleCapabilityImpl
    extends GenericReqCap
    implements BundleCapability {
        private final BundleRevision revision;
        private final String prettyPrint;
        private final String[] includes;
        private final String[] excludes;
        private final boolean hasExcludes;

        BundleCapabilityImpl(BundleRevision revision, String str) throws BundleException {
            super(str);
            this.revision = revision;
            this.prettyPrint = null;
            String excludeStr = this.getDirectives().get("exclude");
            if (excludeStr == null) {
                this.excludes = new String[1];
                this.excludes[0] = "";
                this.hasExcludes = false;
            } else {
                this.excludes = Utils.splitString(Utils.unQuote(excludeStr), ',');
                this.hasExcludes = true;
            }
            String includeStr = this.getDirectives().get("include");
            if (includeStr == null) {
                this.includes = new String[1];
                this.includes[0] = "*";
            } else {
                this.includes = Utils.splitString(Utils.unQuote(excludeStr), ',');
            }
        }

        public BundleCapabilityImpl(BundleRevision revision, String namespace, Map<String, String> directives, Map<String, Object> attributes, String prettyPrint) {
            super(namespace, directives, attributes);
            this.revision = revision;
            this.prettyPrint = prettyPrint;
            String excludeStr = this.getDirectives().get("exclude");
            if (excludeStr == null) {
                this.excludes = new String[1];
                this.excludes[0] = "";
                this.hasExcludes = false;
            } else {
                this.excludes = Utils.splitString(Utils.unQuote(excludeStr), ',');
                this.hasExcludes = true;
            }
            String includeStr = this.getDirectives().get("include");
            if (includeStr == null) {
                this.includes = new String[1];
                this.includes[0] = "*";
            } else {
                this.includes = Utils.splitString(Utils.unQuote(includeStr), ',');
            }
            if ("osgi.wiring.package".equals(namespace) && attributes.get("version") == null) {
                attributes.put("version", Version.emptyVersion);
            }
        }

        @Override
        public BundleRevision getRevision() {
            return this.revision;
        }

        @Override
        public BundleRevision getResource() {
            return this.revision;
        }

        boolean filter(String name) {
            int i;
            boolean matched = false;
            for (i = 0; i < this.includes.length; ++i) {
                if (RFC1960Filter.stringCompare(this.includes[i].toCharArray(), 0, name.toCharArray(), 0) != 0) continue;
                matched = true;
                break;
            }
            if (!matched) {
                return false;
            }
            matched = false;
            for (i = 0; i < this.excludes.length; ++i) {
                if (RFC1960Filter.stringCompare(name.toCharArray(), 0, this.excludes[i].toCharArray(), 0) != 0) continue;
                matched = true;
                break;
            }
            return !matched;
        }

        boolean hasExcludes() {
            return this.hasExcludes;
        }

        @Override
        public String toString() {
            return this.prettyPrint == null ? "BundleCapability {" + super.toString() + "}" : this.prettyPrint;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class GenericReqCap
    implements Requirement,
    Capability {
        private final String namespace;
        private final Map<String, String> directives;
        private final Map<String, Object> attributes;

        protected GenericReqCap(String str) throws BundleException {
            String[] literals = Utils.splitString(str, ';');
            this.namespace = literals[0].trim();
            ConciergeCollections.ParseResult parseResult = Utils.parseLiterals(literals, 1);
            this.directives = parseResult.getDirectives() == null ? Collections.emptyMap() : Collections.unmodifiableMap(parseResult.getDirectives());
            this.attributes = parseResult.getAttributes() == null ? Collections.emptyMap() : Collections.unmodifiableMap(parseResult.getAttributes());
        }

        public GenericReqCap(String namespace, Map<String, String> directives, Map<String, Object> attributes) {
            this.namespace = namespace;
            this.directives = directives == null || directives.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(directives);
            this.attributes = attributes == null || attributes.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(attributes);
        }

        @Override
        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Map<String, String> getDirectives() {
            return this.directives;
        }

        @Override
        public final Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public String toString() {
            if (this.directives.isEmpty() && this.attributes.isEmpty()) {
                return this.namespace;
            }
            String result = this.namespace + "; ";
            for (String key : this.directives.keySet()) {
                result = result + key + ":=" + this.directives.get(key) + ", ";
            }
            for (String key : this.attributes.keySet()) {
                result = result + key + "=" + this.attributes.get(key) + ", ";
            }
            return result.substring(0, result.length() - 2);
        }
    }
}

