/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.concierge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.concierge.ConciergeCollections;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private static String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Pattern LIST_TYPE_PATTERN = Pattern.compile("List\\s*<\\s*([^\\s]*)\\s*>");
    private static final String SPECIFICATION_VERSION = "specification-version";
    private static final short STRING_TYPE = 0;
    private static final short VERSION_TYPE = 1;
    private static final short LONG_TYPE = 2;
    private static final short DOUBLE_TYPE = 3;

    public static String[] splitString(String values, char delimiter) {
        return Utils.splitString(values, delimiter, Integer.MAX_VALUE);
    }

    static String[] splitString(String values, char delimiter, int limit) {
        int count;
        int endPointer;
        if (values == null || values.length() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> tokens = new ArrayList<String>(values.length() / 10);
        char[] chars = values.toCharArray();
        int len = chars.length;
        int openingQuote = -1;
        int pointer = 0;
        int curr = 0;
        int matches = 0;
        while (Character.isWhitespace(chars[curr])) {
            ++curr;
        }
        pointer = curr;
        do {
            if (chars[curr] == '\\') {
                curr += 2;
                continue;
            }
            if (chars[curr] == '\"') {
                openingQuote = openingQuote < 0 ? curr : -1;
                ++curr;
                continue;
            }
            if (chars[curr] == delimiter && openingQuote < 0) {
                if (++matches > limit) break;
                for (endPointer = curr - 1; endPointer > 0 && Character.isWhitespace(chars[endPointer]); --endPointer) {
                }
                count = endPointer - pointer + 1;
                if (count > 0) {
                    tokens.add(new String(chars, pointer, count));
                }
                ++curr;
                while (curr < len && Character.isWhitespace(chars[curr])) {
                    ++curr;
                }
                pointer = curr;
                continue;
            }
            ++curr;
        } while (curr < len);
        if (openingQuote > -1) {
            throw new IllegalArgumentException("Unmatched quotation mark at position " + openingQuote);
        }
        for (endPointer = len - 1; endPointer > 0 && Character.isWhitespace(chars[endPointer]); --endPointer) {
        }
        count = endPointer - pointer + 1;
        if (count > 0) {
            tokens.add(new String(chars, pointer, count));
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static ConciergeCollections.ParseResult parseLiterals(String[] literals, int start) throws BundleException {
        HashMap<String, String> directives = new HashMap<String, String>();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (int i = start; i < literals.length; ++i) {
            int e;
            String[] parts = Utils.splitString(literals[i], '=', 1);
            String name = parts[0].trim();
            if (name.charAt(e = name.length() - 1) == ':') {
                String directive = name.substring(0, e).trim();
                if (directives.containsKey(directive)) {
                    throw new BundleException("Duplicate directive '" + directive + "'");
                }
                directives.put(directive, Utils.unQuote(parts[1].trim()));
                continue;
            }
            if (attributes.containsKey(name)) {
                throw new BundleException("Duplicate attribute " + name);
            }
            String[] nameParts = Utils.splitString(name, ':');
            if (nameParts.length > 1) {
                if (nameParts.length != 2) {
                    throw new BundleException("Illegal attribute name " + name);
                }
                attributes.put(nameParts[0], Utils.createValue(nameParts[1].trim(), Utils.unQuote(parts[1])));
                continue;
            }
            if ("version".equals(name) && parts[1].indexOf(44) == -1) {
                attributes.put(name, new Version(Utils.unQuote(parts[1].trim())));
                continue;
            }
            attributes.put(name, Utils.unQuote(parts[1].trim()));
        }
        return new ConciergeCollections.ParseResult(directives, attributes);
    }

    private static Object createValue(String type, String valueStr) throws BundleException {
        Matcher matcher = LIST_TYPE_PATTERN.matcher(type);
        if (matcher.matches() || "List".equals(type)) {
            short elementType = matcher.matches() ? Utils.getType(matcher.group(1)) : (short)0;
            ArrayList<Object> list = new ArrayList<Object>();
            String[] valueStrs = Utils.splitString(valueStr, ',');
            for (int i = 0; i < valueStrs.length; ++i) {
                list.add(Utils.createValue0(elementType, valueStrs[i]));
            }
            return list;
        }
        return Utils.createValue0(Utils.getType(type), valueStr);
    }

    private static short getType(String type) {
        if ("String".equals(type)) {
            return 0;
        }
        if ("Version".equals(type)) {
            return 1;
        }
        if ("Long".equals(type)) {
            return 2;
        }
        if ("Double".equals(type)) {
            return 3;
        }
        return -1;
    }

    private static Object createValue0(short type, String valueStr) {
        switch (type) {
            case 0: {
                return valueStr;
            }
            case 1: {
                return new Version(valueStr.trim());
            }
            case 2: {
                return new Long(valueStr.trim());
            }
            case 3: {
                return new Double(valueStr.trim());
            }
        }
        throw new IllegalStateException("invalid type " + type);
    }

    public static String unQuote(String quoted) {
        String quoted1 = quoted.trim();
        int len = quoted1.length();
        int start = quoted1.charAt(0) == '\"' ? 1 : 0;
        int end = quoted1.charAt(quoted1.length() - 1) == '\"' ? len - 1 : len;
        return start == 0 && end == len ? quoted : quoted1.substring(start, end);
    }

    public static String createFilter(String namespace, String req, Map<String, Object> attributes) throws BundleException {
        Object version = attributes.get("version");
        if ("osgi.wiring.package".equals(namespace) && version != null && attributes.containsKey(SPECIFICATION_VERSION)) {
            if (!new Version(Utils.unQuote((String)attributes.get(SPECIFICATION_VERSION))).equals(version)) {
                throw new BundleException("both version and specification-version are given for the import " + req);
            }
            attributes.remove(SPECIFICATION_VERSION);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append('(');
        buffer.append(namespace);
        buffer.append('=');
        buffer.append(req);
        buffer.append(')');
        if (attributes.size() == 0) {
            return buffer.toString();
        }
        buffer.insert(0, "(&");
        for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
            String key = attribute.getKey();
            Object value = attribute.getValue();
            if ("version".equals(key) || "bundle-version".equals(key)) {
                if (value instanceof String) {
                    VersionRange range = new VersionRange(Utils.unQuote((String)value));
                    if (range.getRight() == null) {
                        buffer.append('(');
                        buffer.append(key);
                        buffer.append(">=");
                        buffer.append(range.getLeft());
                        buffer.append(')');
                        continue;
                    }
                    boolean open = range.getLeftType() == '(';
                    buffer.append(open ? "(!(" : "(");
                    buffer.append(key);
                    buffer.append(open ? "<=" : ">=");
                    buffer.append(range.getLeft());
                    buffer.append(open ? "))" : ")");
                    open = range.getRightType() == ')';
                    buffer.append(open ? "(!(" : "(");
                    buffer.append(key);
                    buffer.append(open ? ">=" : "<=");
                    buffer.append(range.getRight());
                    buffer.append(open ? "))" : ")");
                    continue;
                }
                buffer.append('(');
                buffer.append(key);
                buffer.append(">=");
                buffer.append(value);
                buffer.append(')');
                continue;
            }
            buffer.append("(");
            buffer.append(key);
            buffer.append("=");
            buffer.append(value);
            buffer.append(")");
        }
        buffer.append(")");
        return buffer.toString();
    }
}

