/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dartboard.Messages;
import org.eclipse.dartboard.util.DartPreferences;
import org.eclipse.dartboard.util.LaunchUtil;
import org.eclipse.dartboard.util.PlatformUIUtil;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class LaunchFileShortcut
implements ILaunchShortcut {
    private ScopedPreferenceStore preferences = DartPreferences.getPreferenceStore();

    public void launch(ISelection selection, String mode) {
        Object firstElement;
        if (selection instanceof StructuredSelection && (firstElement = ((StructuredSelection)selection).getFirstElement()) instanceof IFile) {
            IFile file = (IFile)firstElement;
            this.launch(file.getLocation(), null);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput editorInput = editor.getEditorInput();
        if (IDE.saveAllEditors((IResource[])new IResource[]{(IResource)editorInput.getAdapter(IResource.class)}, (boolean)true) && editorInput instanceof FileEditorInput) {
            this.launch(((FileEditorInput)editorInput).getPath(), null);
        }
    }

    protected void launch(IPath file, String sdk) {
        if (sdk == null) {
            sdk = this.preferences.getString("sdk_location");
        }
        if (sdk == null || sdk.isEmpty()) {
            MessageDialog.openError((Shell)PlatformUIUtil.getActiveShell(), (String)Messages.Launch_PageTitle, (String)Messages.NewProject_SDK_Not_Found);
            return;
        }
        LaunchUtil.launchDartFile(sdk, file);
    }
}

