/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dartboard.project;

import java.util.List;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dartboard.Messages;
import org.eclipse.dartboard.stagehand.StagehandService;
import org.eclipse.dartboard.stagehand.StagehandTemplate;
import org.eclipse.dartboard.util.DartPreferences;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class DartProjectPage
extends WizardNewProjectCreationPage {
    private ScopedPreferenceStore preferences = DartPreferences.getPreferenceStore();
    private Combo stagehandTemplates;
    private Button useStagehandButton;
    private List<StagehandTemplate> templates;

    public DartProjectPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createAdditionalControls((Composite)this.getControl());
    }

    private void createAdditionalControls(Composite parent) {
        Group dartGroup = new Group(parent, 0);
        dartGroup.setFont(parent.getFont());
        dartGroup.setText(Messages.NewProject_Group_Label);
        dartGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        dartGroup.setLayout((Layout)new GridLayout(2, false));
        Label labelSdkLocation = new Label((Composite)dartGroup, 0);
        labelSdkLocation.setText(Messages.Preference_SDKLocation);
        GridDataFactory.swtDefaults().applyTo((Control)labelSdkLocation);
        Label sdkLocation = new Label((Composite)dartGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)sdkLocation);
        sdkLocation.setText(this.preferences.getString("sdk_location"));
        Group stagehandGroup = new Group(parent, 0);
        stagehandGroup.setFont(parent.getFont());
        stagehandGroup.setText(Messages.NewProject_Stagehand_Title);
        stagehandGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        stagehandGroup.setLayout((Layout)new GridLayout(1, false));
        this.useStagehandButton = new Button((Composite)stagehandGroup, 32);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.useStagehandButton);
        this.useStagehandButton.setEnabled(false);
        this.stagehandTemplates = new Combo((Composite)stagehandGroup, 8);
        this.stagehandTemplates.setEnabled(this.useStagehandButton.getSelection());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.stagehandTemplates);
        this.useStagehandButton.setText(Messages.NewProject_Stagehand_UseStagehandButtonText);
        this.useStagehandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DartProjectPage.this.stagehandTemplates.setEnabled(DartProjectPage.this.useStagehandButton.getSelection());
                if (DartProjectPage.this.stagehandTemplates.getSelectionIndex() == -1) {
                    DartProjectPage.this.stagehandTemplates.select(0);
                }
            }
        });
        ProgressIndicator indicator = new ProgressIndicator((Composite)stagehandGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)indicator);
        indicator.beginAnimatedTask();
        Job.create((String)Messages.NewProject_Stagehand_FetchStagehand, monitor -> {
            this.templates = StagehandService.getStagehandTemplates();
            Display.getDefault().asyncExec(() -> {
                indicator.done();
                if (!this.stagehandTemplates.isDisposed()) {
                    this.templates.forEach(str -> this.stagehandTemplates.add(str.getDisplayName()));
                    this.useStagehandButton.setEnabled(true);
                }
            });
        }).schedule();
    }

    public StagehandTemplate getGenerator() {
        if (this.useStagehandButton.getSelection()) {
            return this.templates.get(this.stagehandTemplates.getSelectionIndex());
        }
        return null;
    }

    protected boolean validatePage() {
        boolean isValid = super.validatePage();
        if (isValid && "".equals(this.preferences.getString("sdk_location"))) {
            this.setMessage(Messages.NewProject_SDK_Not_Found, 2);
        }
        return isValid;
    }
}

