/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ErrorHandler
extends AbstractHandler {
    private static final Logger LOG = Log.getLogger(ErrorHandler.class);
    public static final String ERROR_PAGE = "org.eclipse.jetty.server.error_page";
    boolean _showStacks = true;
    boolean _showMessageInTitle = true;
    String _cacheControl = "must-revalidate,no-cache,no-store";

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String old_error_page;
        String error_page;
        AbstractHttpConnection connection = AbstractHttpConnection.getCurrentConnection();
        String method = request.getMethod();
        if (!(method.equals("GET") || method.equals("POST") || method.equals("HEAD"))) {
            connection.getRequest().setHandled(true);
            return;
        }
        if (this instanceof ErrorPageMapper && (error_page = ((ErrorPageMapper)((Object)this)).getErrorPage(request)) != null && request.getServletContext() != null && ((old_error_page = (String)request.getAttribute(ERROR_PAGE)) == null || !old_error_page.equals(error_page))) {
            request.setAttribute(ERROR_PAGE, (Object)error_page);
            Dispatcher dispatcher = (Dispatcher)request.getServletContext().getRequestDispatcher(error_page);
            try {
                if (dispatcher != null) {
                    dispatcher.error((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                LOG.warn("No error page " + error_page, new Object[0]);
            }
            catch (ServletException e) {
                LOG.warn("EXCEPTION ", (Throwable)e);
                return;
            }
        }
        connection.getRequest().setHandled(true);
        response.setContentType("text/html;charset=ISO-8859-1");
        if (this._cacheControl != null) {
            response.setHeader("Cache-Control", this._cacheControl);
        }
        ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(4096);
        this.handleErrorPage(request, (Writer)writer, connection.getResponse().getStatus(), connection.getResponse().getReason());
        writer.flush();
        response.setContentLength(writer.size());
        writer.writeTo((OutputStream)response.getOutputStream());
        writer.destroy();
    }

    protected void handleErrorPage(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
        this.writeErrorPage(request, writer, code, message, this._showStacks);
    }

    protected void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
        if (message == null) {
            message = HttpStatus.getMessage((int)code);
        }
        writer.write("<html>\n<head>\n");
        this.writeErrorPageHead(request, writer, code, message);
        writer.write("</head>\n<body>");
        this.writeErrorPageBody(request, writer, code, message, showStacks);
        writer.write("\n</body>\n</html>\n");
    }

    protected void writeErrorPageHead(HttpServletRequest request, Writer writer, int code, String message) throws IOException {
        writer.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\"/>\n");
        writer.write("<title>Error ");
        writer.write(Integer.toString(code));
        if (this._showMessageInTitle) {
            writer.write(32);
            this.write(writer, message);
        }
        writer.write("</title>\n");
    }

    protected void writeErrorPageBody(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
        String uri = request.getRequestURI();
        this.writeErrorPageMessage(request, writer, code, message, uri);
        if (showStacks) {
            this.writeErrorPageStacks(request, writer);
        }
        writer.write("<hr /><i><small>Powered by Jetty://</small></i>");
        for (int i = 0; i < 20; ++i) {
            writer.write("<br/>                                                \n");
        }
    }

    protected void writeErrorPageMessage(HttpServletRequest request, Writer writer, int code, String message, String uri) throws IOException {
        writer.write("<h2>HTTP ERROR ");
        writer.write(Integer.toString(code));
        writer.write("</h2>\n<p>Problem accessing ");
        this.write(writer, uri);
        writer.write(". Reason:\n<pre>    ");
        this.write(writer, message);
        writer.write("</pre></p>");
    }

    protected void writeErrorPageStacks(HttpServletRequest request, Writer writer) throws IOException {
        for (Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception"); th != null; th = th.getCause()) {
            writer.write("<h3>Caused by:</h3><pre>");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            pw.flush();
            this.write(writer, sw.getBuffer().toString());
            writer.write("</pre>\n");
        }
    }

    public String getCacheControl() {
        return this._cacheControl;
    }

    public void setCacheControl(String cacheControl) {
        this._cacheControl = cacheControl;
    }

    public boolean isShowStacks() {
        return this._showStacks;
    }

    public void setShowStacks(boolean showStacks) {
        this._showStacks = showStacks;
    }

    public void setShowMessageInTitle(boolean showMessageInTitle) {
        this._showMessageInTitle = showMessageInTitle;
    }

    public boolean getShowMessageInTitle() {
        return this._showMessageInTitle;
    }

    protected void write(Writer writer, String string) throws IOException {
        if (string == null) {
            return;
        }
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    writer.write("&amp;");
                    continue block5;
                }
                case '<': {
                    writer.write("&lt;");
                    continue block5;
                }
                case '>': {
                    writer.write("&gt;");
                    continue block5;
                }
                default: {
                    if (Character.isISOControl(c) && !Character.isWhitespace(c)) {
                        writer.write(63);
                        continue block5;
                    }
                    writer.write(c);
                }
            }
        }
    }

    public static interface ErrorPageMapper {
        public String getErrorPage(HttpServletRequest var1);
    }
}

