/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.html.wizard;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.ide.datasource.DataSourceFacade;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlForEntityTemplateModel;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlForEntityTemplateTablePageLabelProvider;
import org.eclipse.dirigible.ide.template.ui.html.wizard.TableColumn;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;

public class HtmlForEntityTemplateTablePage
extends WizardPage {
    private static final long serialVersionUID = -2145208425464294046L;
    private static final String AVAILABLE_FIELDS = "Available Fields";
    private static final String ERROR_ON_LOADING_TABLE_COLUMNS_FROM_DATABASE_FOR_GENERATION = "Error on Loading Table Columns from Database for Generation";
    private static final String SELECT_THE_VISIBLE_FIELDS_WHICH_WILL_BE_USED_DURING_GENERATION = "Select the visible fields which will be used during generation";
    private static final String SELECTION_OF_FIELDS = "Selection of Fields";
    private static final Logger logger = Logger.getLogger(HtmlForEntityTemplateTablePage.class);
    private static final String PAGE_NAME = "org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlForEntityTemplateTablePage";
    private HtmlForEntityTemplateModel model;
    private TableViewer typeViewer;

    protected HtmlForEntityTemplateTablePage(HtmlForEntityTemplateModel model) {
        super(PAGE_NAME);
        this.model = model;
        this.setTitle(SELECTION_OF_FIELDS);
        this.setDescription(SELECT_THE_VISIBLE_FIELDS_WHICH_WILL_BE_USED_DURING_GENERATION);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        this.createTableField(composite);
        this.checkPageStatus();
    }

    private void selectAll(boolean b) {
        TableColumn[] tableColumns = (TableColumn[])this.typeViewer.getInput();
        TableItem[] items = this.typeViewer.getTable().getItems();
        int selectionIndex = this.typeViewer.getTable().getSelectionIndex();
        int j = 0;
        while (j < items.length) {
            TableItem tblItem = items[j];
            this.typeViewer.getTable().setSelection(j);
            tableColumns[j].setVisible(tblItem.getChecked());
            items[this.typeViewer.getTable().getSelectionIndex()].setChecked(b || tableColumns[j].isKey());
            tableColumns[j].setVisible(true);
            ++j;
        }
        this.typeViewer.getTable().setSelection(selectionIndex);
    }

    private void createTableField(Composite parent) {
        Composite upperPart = new Composite(parent, 0);
        upperPart.setLayout((Layout)new GridLayout(3, false));
        upperPart.setLayoutData((Object)new GridData(4, 4, true, false));
        Label label = new Label(upperPart, 0);
        label.setText(AVAILABLE_FIELDS);
        label.setLayoutData((Object)new GridData(16384, 1024, true, false));
        Button selectButton = new Button(upperPart, 8);
        selectButton.setText("&Select All");
        selectButton.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        selectButton.setFont(JFaceResources.getDialogFont());
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = -7095187791495950403L;

            public void widgetSelected(SelectionEvent event) {
                HtmlForEntityTemplateTablePage.this.selectAll(true);
            }
        });
        Button deselectButton = new Button(upperPart, 8);
        deselectButton.setText("&Deselect All");
        deselectButton.setLayoutData((Object)new GridData(0x1000008, 4, false, false));
        deselectButton.setFont(JFaceResources.getDialogFont());
        deselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 7117397741755265980L;

            public void widgetSelected(SelectionEvent event) {
                HtmlForEntityTemplateTablePage.this.selectAll(false);
            }
        });
        this.typeViewer = new TableViewer(parent, 2596);
        this.typeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new HtmlForEntityTemplateTablePageLabelProvider());
        this.createTableColumns();
        this.typeViewer.setInput((Object)this.model.getOriginalTableColumns());
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HtmlForEntityTemplateTablePage.this.updateTableColumns();
                HtmlForEntityTemplateTablePage.this.checkPageStatus();
            }
        });
        this.updateTableColumns();
    }

    private void updateTableColumns() {
        TableColumn[] tableColumns = (TableColumn[])this.typeViewer.getInput();
        TableItem[] items = this.typeViewer.getTable().getItems();
        int selectionIndex = this.typeViewer.getTable().getSelectionIndex();
        int j = 0;
        while (j < items.length) {
            TableItem tblItem = items[j];
            this.typeViewer.getTable().setSelection(j);
            tableColumns[j].setVisible(tblItem.getChecked());
            if (tableColumns[j].isKey()) {
                items[this.typeViewer.getTable().getSelectionIndex()].setChecked(true);
                tableColumns[j].setVisible(true);
            }
            ++j;
        }
        this.typeViewer.getTable().setSelection(selectionIndex);
    }

    private void createTableColumns() {
        try {
            this.parseEntityDescriptor();
            Connection connection = this.getConnection();
            try {
                ArrayList<TableColumn> availableTableColumns = new ArrayList<TableColumn>();
                ResultSet primaryKeys = DBUtils.getPrimaryKeys((Connection)connection, (String)this.model.getTableName());
                ArrayList<String> primaryKeysList = new ArrayList<String>();
                while (primaryKeys.next()) {
                    String columnName = primaryKeys.getString("COLUMN_NAME");
                    primaryKeysList.add(columnName);
                }
                ResultSet columns = DBUtils.getColumns((Connection)connection, (String)this.model.getTableName());
                while (columns.next()) {
                    String columnName = columns.getString("COLUMN_NAME");
                    String columnType = columns.getString("TYPE_NAME");
                    int columnSize = columns.getInt("COLUMN_SIZE");
                    TableColumn tableColumn = null;
                    tableColumn = primaryKeysList.contains(columnName) ? new TableColumn(columnName, true, true, columnType, columnSize) : new TableColumn(columnName, false, true, columnType, columnSize);
                    if (this.exists(availableTableColumns, tableColumn)) continue;
                    availableTableColumns.add(tableColumn);
                }
                this.model.setTableColumns(availableTableColumns.toArray(new TableColumn[0]));
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(ERROR_ON_LOADING_TABLE_COLUMNS_FROM_DATABASE_FOR_GENERATION, (Throwable)e);
        }
    }

    private boolean exists(List<TableColumn> availableTableColumns, TableColumn tableColumn) {
        for (TableColumn tableColumn2 : availableTableColumns) {
            TableColumn tableColumnX = tableColumn2;
            if (!tableColumnX.getName().equals(tableColumn.getName())) continue;
            return true;
        }
        return false;
    }

    protected void parseEntityDescriptor() throws Exception {
        JsonParser parser = new JsonParser();
        JsonObject entityService = (JsonObject)parser.parse((Reader)new InputStreamReader(this.model.getSourceFile().getContents()));
        this.model.setTableName(entityService.get("tableName").getAsString());
        this.model.setTableType(entityService.get("tableType").getAsString());
    }

    private void checkPageStatus() {
        this.setPageComplete(this.model.validateTableColumns());
    }

    public HtmlForEntityTemplateModel getModel() {
        return this.model;
    }

    protected Connection getConnection() throws SQLException {
        try {
            return DataSourceFacade.getInstance().getDataSource().getConnection();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }
}

