/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.confluence.core.block;

import org.eclipse.mylyn.internal.wikitext.confluence.core.block.AbstractConfluenceDelimitedBlock;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;

public class CodeBlock
extends AbstractConfluenceDelimitedBlock {
    private String title;
    private String language;

    public CodeBlock() {
        super("code");
    }

    @Override
    protected void beginBlock() {
        Attributes attributes;
        if (this.title != null) {
            attributes = new Attributes();
            attributes.setTitle(this.title);
            this.builder.beginBlock(DocumentBuilder.BlockType.PANEL, attributes);
        }
        attributes = new Attributes();
        if (this.language != null) {
            attributes.setCssClass(String.valueOf(this.language) + " code-" + this.language);
        }
        this.builder.beginBlock(DocumentBuilder.BlockType.CODE, attributes);
    }

    @Override
    protected void handleBlockContent(String content) {
        this.builder.characters(content);
        this.builder.characters("\n");
    }

    @Override
    protected void endBlock() {
        if (this.title != null) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.title = null;
    }

    @Override
    protected void setOption(String key, String value) {
        if (key.equals("title")) {
            this.title = value;
        } else if (key.equals("language")) {
            this.language = value;
        }
    }

    @Override
    protected void setOption(String option) {
        this.language = option.toLowerCase();
    }
}

