/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.wizard.project.sample;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dirigible.ide.common.image.ImageUtils;
import org.eclipse.dirigible.ide.jgit.utils.GitFileUtils;
import org.eclipse.dirigible.ide.workspace.ui.shared.IValidationStatus;
import org.eclipse.dirigible.ide.workspace.wizard.project.create.ProjectTemplateType;
import org.eclipse.dirigible.ide.workspace.wizard.project.sample.Messages;
import org.eclipse.dirigible.ide.workspace.wizard.project.sample.SampleProjectWizardModel;
import org.eclipse.dirigible.ide.workspace.wizard.project.sample.SamplesCategory;
import org.eclipse.dirigible.ide.workspace.wizard.project.sample.SamplesContentProvider;
import org.eclipse.dirigible.ide.workspace.wizard.project.sample.SamplesLabelProvider;
import org.eclipse.dirigible.ide.workspace.wizard.project.sample.SamplesProject;
import org.eclipse.dirigible.repository.ext.git.JGitConnector;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SampleProjectWizardGitTemplatePage
extends WizardPage {
    private static final long serialVersionUID = 1L;
    private static final String PAGE_NAME = Messages.SampleProjectWizardGitTemplatePage_PAGE_NAME;
    private static final String PAGE_TITLE = Messages.SampleProjectWizardGitTemplatePage_PAGE_TITLE;
    private static final String PAGE_DESCRIPTION = Messages.SampleProjectWizardGitTemplatePage_PAGE_DESCRIPTION;
    private static final String ERROR_ON_LOADING_GIT_TEMPLATES_FOR_GENERATION = Messages.SampleProjectWizardGitTemplatePage_ERROR_ON_LOADING_GIT_TEMPLATES_FOR_GENERATION;
    private static final String HELP_DIRECTORY = "HelpDirectory";
    public static final String TEMP_DIRECTORY_PREFIX = "org.eclipse.dirigible.jgit.";
    protected static final String SELECT_TEMPLATE_TYPE_FORM_THE_LIST = Messages.SampleProjectWizardGitTemplatePage_SELECT_TEMPLATE_TYPE_FORM_THE_LIST;
    private static final String GIT_TEMPLATE_DIRECTORY = "org.eclipse.dirigible.ide.workspace.wizard.project.sample";
    private static final Logger logger = Logger.getLogger(SampleProjectWizardGitTemplatePage.class);
    private final SampleProjectWizardModel model;
    private TreeViewer typeViewer;
    private Label labelPreview;
    private static final Image previewImage = ImageUtils.createImage((URL)SampleProjectWizardGitTemplatePage.getIconURL("preview.png"));

    public SampleProjectWizardGitTemplatePage(SampleProjectWizardModel model) {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        this.model = model;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        this.createTypeField(composite);
        this.createPreviewLabel(composite);
        this.checkPageStatus();
    }

    public static URL getIconURL(String iconName) {
        URL url = ImageUtils.getIconURL((String)"org.eclipse.dirigible.ide.workspace.wizard.project", (String)"/icons/", (String)iconName);
        return url;
    }

    private void createPreviewLabel(Composite composite) {
        this.labelPreview = new Label(composite, 0);
        this.labelPreview.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        this.labelPreview.setBounds(0, 0, 450, 300);
        this.labelPreview.setBackground(new Color(null, 0, 0, 0));
        this.labelPreview.setImage(previewImage);
    }

    private void createTypeField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.SampleProjectWizardGitTemplatePage_AVAILABLE_GIT_TEMPLATES);
        label.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.typeViewer = new TreeViewer(parent, 2564);
        this.typeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.typeViewer.setContentProvider((IContentProvider)new SamplesContentProvider());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new SamplesLabelProvider());
        this.typeViewer.setSorter(new ViewerSorter());
        this.typeViewer.setInput((Object)this.createGitTemplateTypes());
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() == null || !(selection.getFirstElement() instanceof SamplesProject)) {
                    SampleProjectWizardGitTemplatePage.this.setPageComplete(false);
                    SampleProjectWizardGitTemplatePage.this.setErrorMessage(SELECT_TEMPLATE_TYPE_FORM_THE_LIST);
                    SampleProjectWizardGitTemplatePage.this.labelPreview.setImage(previewImage);
                    SampleProjectWizardGitTemplatePage.this.labelPreview.pack(true);
                } else {
                    SampleProjectWizardGitTemplatePage.this.setErrorMessage(null);
                    SamplesProject gitTemplate = (SamplesProject)selection.getFirstElement();
                    SampleProjectWizardGitTemplatePage.this.getModel().setTemplate(gitTemplate.getTemplate());
                    SampleProjectWizardGitTemplatePage.this.checkPageStatus();
                    SampleProjectWizardGitTemplatePage.this.labelPreview.setImage(gitTemplate.getTemplate().getImagePreview());
                    SampleProjectWizardGitTemplatePage.this.labelPreview.pack(true);
                }
            }
        });
    }

    private SamplesCategory createGitTemplateTypes() {
        try {
            HashMap categories = new HashMap();
            ProjectTemplateType[] projectTemplateTypeArray = this.prepareGitTemplateTypes();
            int n = projectTemplateTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProjectTemplateType sampleProject = projectTemplateTypeArray[n2];
                String category = sampleProject.getCategory();
                if (categories.containsKey(category)) {
                    ((List)categories.get(category)).add(new SamplesProject(sampleProject));
                } else {
                    ArrayList<SamplesProject> sampleProjectsList = new ArrayList<SamplesProject>();
                    sampleProjectsList.add(new SamplesProject(sampleProject));
                    categories.put(category, sampleProjectsList);
                }
                ++n2;
            }
            SamplesCategory root = new SamplesCategory("");
            for (Map.Entry entry : categories.entrySet()) {
                root.addCategory(new SamplesCategory((String)entry.getKey(), (List)entry.getValue()));
            }
            return root;
        }
        catch (IOException e) {
            logger.error(ERROR_ON_LOADING_GIT_TEMPLATES_FOR_GENERATION, (Throwable)e);
            return null;
        }
    }

    protected ProjectTemplateType[] prepareGitTemplateTypes() throws IOException {
        File gitDirectory = null;
        boolean isCloned = false;
        File file = GitFileUtils.createTempDirectory((String)HELP_DIRECTORY);
        File tempDirectory = file.getParentFile();
        GitFileUtils.deleteDirectory((File)file);
        File[] fileArray = tempDirectory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File temp = fileArray[n2];
            if (temp.isDirectory() && temp.getName().startsWith(GIT_TEMPLATE_DIRECTORY)) {
                isCloned = true;
                gitDirectory = temp;
                break;
            }
            ++n2;
        }
        if (isCloned) {
            SampleProjectWizardGitTemplatePage.doPull(gitDirectory.getCanonicalPath());
        } else {
            gitDirectory = GitFileUtils.createTempDirectory((String)GIT_TEMPLATE_DIRECTORY);
            SampleProjectWizardGitTemplatePage.doClone(gitDirectory);
        }
        if (gitDirectory.listFiles().length <= 0) {
            this.model.setUseTemplate(false);
            return new ProjectTemplateType[0];
        }
        ArrayList<ProjectTemplateType> projectTemplateTypesList = new ArrayList<ProjectTemplateType>();
        File[] fileArray2 = gitDirectory.listFiles();
        int n3 = fileArray2.length;
        n = 0;
        while (n < n3) {
            File projectTemplate = fileArray2[n];
            if (!projectTemplate.getName().equalsIgnoreCase(".git") && projectTemplate.isDirectory()) {
                projectTemplateTypesList.add(ProjectTemplateType.createGitTemplateType(projectTemplate));
            }
            ++n;
        }
        return projectTemplateTypesList.toArray(new ProjectTemplateType[0]);
    }

    private void checkPageStatus() {
        if (this.getModel().isUseTemplate()) {
            if (this.getModel().getTemplateLocation() == null || "".equals(this.getModel().getTemplateLocation())) {
                this.setPageComplete(false);
                return;
            }
            this.revalidateModel();
            return;
        }
        this.setPageComplete(false);
    }

    public SampleProjectWizardModel getModel() {
        return this.model;
    }

    private void revalidateModel() {
        String projectName = this.getModel().getTemplate().getName();
        this.getModel().setProjectName(projectName);
        IValidationStatus status = this.getModel().validate();
        if (status.hasErrors()) {
            this.setErrorMessage(status.getMessage());
            this.setWarningMessage(null);
            this.setCanFinish(false);
        } else if (status.hasWarnings()) {
            this.setErrorMessage(null);
            this.setWarningMessage(status.getMessage());
            this.setCanFinish(true);
        } else {
            this.setErrorMessage(null);
            this.setWarningMessage(null);
            this.setCanFinish(true);
        }
    }

    public void setWarningMessage(String message) {
        this.setMessage(message, 2);
    }

    public void setCanFinish(boolean value) {
        this.setPageComplete(value);
    }

    private static void doPull(String gitDirectoryPath) throws IOException {
        Repository repository = null;
        try {
            repository = JGitConnector.getRepository((String)gitDirectoryPath);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        JGitConnector jgit = new JGitConnector(repository);
        try {
            jgit.pull();
            jgit.add(".");
            jgit.hardReset();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void doClone(File gitDirectory) {
        try {
            JGitConnector.cloneRepository((File)gitDirectory, (String)"https://github.com/SAP/cloud-dirigible-samples.git");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

