/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.transport.HMACSHA1NonceGenerator;
import org.eclipse.jgit.transport.NonceGenerator;

public class SignedPushConfig {
    public static final Config.SectionParser<SignedPushConfig> KEY = new Config.SectionParser<SignedPushConfig>(){

        @Override
        public SignedPushConfig parse(Config cfg) {
            return new SignedPushConfig(cfg);
        }
    };
    private String certNonceSeed;
    private int certNonceSlopLimit;
    private NonceGenerator nonceGenerator;

    public SignedPushConfig() {
    }

    SignedPushConfig(Config cfg) {
        this.setCertNonceSeed(cfg.getString("receive", null, "certnonceseed"));
        this.certNonceSlopLimit = cfg.getInt("receive", "certnonceslop", 0);
    }

    public void setCertNonceSeed(String seed) {
        this.certNonceSeed = seed;
    }

    public String getCertNonceSeed() {
        return this.certNonceSeed;
    }

    public void setCertNonceSlopLimit(int limit) {
        this.certNonceSlopLimit = limit;
    }

    public int getCertNonceSlopLimit() {
        return this.certNonceSlopLimit;
    }

    public void setNonceGenerator(NonceGenerator generator) {
        this.nonceGenerator = generator;
    }

    public NonceGenerator getNonceGenerator() {
        if (this.nonceGenerator != null) {
            return this.nonceGenerator;
        }
        if (this.certNonceSeed != null) {
            return new HMACSHA1NonceGenerator(this.certNonceSeed);
        }
        return null;
    }
}

