/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.resources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.rap.rwt.internal.RWTProperties;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.resources.ClientFilesReader;
import org.eclipse.rap.rwt.internal.resources.ContentBuffer;
import org.eclipse.rap.rwt.internal.theme.QxAppearanceWriter;
import org.eclipse.rap.rwt.internal.theme.Theme;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;
import org.eclipse.rap.rwt.service.ResourceManager;

public final class ClientResources {
    private static final String CLIENT_FILES = "client.files";
    private static final String CLIENT_JS = "client.js";
    private static final String JSON_MIN_JS = "json2.min.js";
    private static final List<String> JAVASCRIPT_FILES = ClientFilesReader.getInputFiles("client.files");
    private static final String[] WIDGET_IMAGES = new String[]{"resource/static/image/blank.gif", "resource/widget/rap/arrows/chevron-left.png", "resource/widget/rap/arrows/chevron-right.png", "resource/widget/rap/arrows/chevron-left-hover.png", "resource/widget/rap/arrows/chevron-right-hover.png", "resource/widget/rap/tree/loading.gif", "resource/widget/rap/ctabfolder/maximize.gif", "resource/widget/rap/ctabfolder/minimize.gif", "resource/widget/rap/ctabfolder/restore.gif", "resource/widget/rap/ctabfolder/close.gif", "resource/widget/rap/ctabfolder/close_hover.gif", "resource/widget/rap/ctabfolder/ctabfolder-dropdown.png", "resource/widget/rap/cursors/alias.gif", "resource/widget/rap/cursors/copy.gif", "resource/widget/rap/cursors/move.gif", "resource/widget/rap/cursors/nodrop.gif", "resource/widget/rap/cursors/up_arrow.cur", "resource/widget/rap/scale/h_line.gif", "resource/widget/rap/scale/v_line.gif"};
    private final ApplicationContextImpl applicationContext;
    private final ResourceManager resourceManager;
    private final ThemeManager themeManager;

    public ClientResources(ApplicationContextImpl applicationContext) {
        this.applicationContext = applicationContext;
        this.resourceManager = applicationContext.getResourceManager();
        this.themeManager = applicationContext.getThemeManager();
    }

    public void registerResources() {
        try {
            this.registerTextResource("resource/static/html/blank.html");
            this.registerJavascriptFiles();
            this.registerThemeResources();
            this.registerWidgetImages();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to register resources", ioe);
        }
    }

    private void registerJavascriptFiles() throws IOException {
        ContentBuffer contentBuffer = new ContentBuffer();
        String appearanceCode = this.getQxAppearanceThemeCode();
        if (RWTProperties.isDevelopmentMode()) {
            this.append(contentBuffer, "debug-settings.js");
            for (String javascriptFile : JAVASCRIPT_FILES) {
                this.append(contentBuffer, javascriptFile);
            }
        } else {
            this.append(contentBuffer, CLIENT_JS);
        }
        String json2Code = this.readResourceContent(JSON_MIN_JS);
        contentBuffer.append(json2Code.getBytes("UTF-8"));
        contentBuffer.append(appearanceCode.getBytes("UTF-8"));
        this.registerJavascriptResource(contentBuffer, "rap-client.js");
    }

    private String getQxAppearanceThemeCode() {
        List<String> customAppearances = this.themeManager.getAppearances();
        return QxAppearanceWriter.createQxAppearanceTheme(customAppearances);
    }

    private void append(ContentBuffer contentBuffer, String location) throws IOException {
        InputStream inputStream = this.openResourceStream(location);
        if (inputStream == null) {
            throw new IOException("Failed to load resource: " + location);
        }
        try {
            contentBuffer.append(inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    private void registerThemeResources() {
        String[] themeIds;
        String[] stringArray = themeIds = this.themeManager.getRegisteredThemeIds();
        int n = themeIds.length;
        int n2 = 0;
        while (n2 < n) {
            String themeId = stringArray[n2];
            Theme theme = this.themeManager.getTheme(themeId);
            theme.registerResources(this.applicationContext);
            ++n2;
        }
    }

    private void registerWidgetImages() throws IOException {
        String[] stringArray = WIDGET_IMAGES;
        int n = WIDGET_IMAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String resourcePath = stringArray[n2];
            InputStream inputStream = this.openResourceStream(resourcePath);
            this.resourceManager.register(resourcePath, inputStream);
            inputStream.close();
            ++n2;
        }
    }

    private void registerTextResource(String name) throws IOException {
        InputStream inputStream = this.openResourceStream(name);
        try {
            this.resourceManager.register(name, inputStream);
        }
        finally {
            inputStream.close();
        }
    }

    private void registerJavascriptResource(ContentBuffer buffer, String name) throws IOException {
        InputStream inputStream = buffer.getContentAsStream();
        try {
            this.resourceManager.register(name, inputStream);
        }
        finally {
            inputStream.close();
        }
        String location = this.resourceManager.getLocation(name);
        this.applicationContext.getStartupPage().setClientJsLibrary(location);
    }

    private String readResourceContent(String location) throws IOException {
        byte[] buffer = new byte[40960];
        InputStream inputStream = this.openResourceStream(location);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int read = inputStream.read(buffer);
            while (read != -1) {
                outputStream.write(buffer, 0, read);
                read = inputStream.read(buffer);
            }
        }
        finally {
            inputStream.close();
        }
        return outputStream.toString("UTF-8");
    }

    private InputStream openResourceStream(String name) {
        return this.getClass().getClassLoader().getResourceAsStream(name);
    }
}

