/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.impl;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dirigible.ide.common.status.DefaultProgressMonitor;
import org.eclipse.dirigible.ide.workspace.impl.Messages;
import org.eclipse.dirigible.ide.workspace.impl.Workspace;
import org.eclipse.dirigible.ide.workspace.impl.event.ResourceChangeEvent;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IEntityInformation;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;

public abstract class Resource
implements IResource {
    private static final String OK = Messages.Resource_OK;
    private static final String METHOD_SET_TEAM_PRIVATE_MEMBER_NOT_SUPPORTED = Messages.Resource_METHOD_SET_TEAM_PRIVATE_MEMBER_NOT_SUPPORTED;
    private static final String METHOD_SET_READ_ONLY_NOT_SUPPORTED = Messages.Resource_METHOD_SET_READ_ONLY_NOT_SUPPORTED;
    private static final String METHOD_SET_LOCAL_TIME_STAMP_NOT_SUPPORTED = Messages.Resource_METHOD_SET_LOCAL_TIME_STAMP_NOT_SUPPORTED;
    private static final String METHOD_SET_LOCAL_NOT_SUPPORTED = Messages.Resource_METHOD_SET_LOCAL_NOT_SUPPORTED;
    private static final String METHOD_SET_HIDDEN_NOT_SUPPORTED = Messages.Resource_METHOD_SET_HIDDEN_NOT_SUPPORTED;
    private static final String METHOD_SET_DERIVED_NOT_SUPPORTED = Messages.Resource_METHOD_SET_DERIVED_NOT_SUPPORTED;
    private static final String ROOLBACK_NOT_SUPPORTED = Messages.Resource_ROOLBACK_NOT_SUPPORTED;
    private static final String MOVE_IS_STILL_UNSUPPORTED = Messages.Resource_MOVE_IS_STILL_UNSUPPORTED;
    private static final String COULD_NOT_RENAME_RESOURCE = Messages.Resource_COULD_NOT_RENAME_RESOURCE;
    private static final String COULD_NOT_DELETE_RESOURCE = Messages.Resource_COULD_NOT_DELETE_RESOURCE;
    private static final String MARKERS_ARE_NOT_SUPPORTED = "Markers are not supported.";
    private static final String RULES_ARE_NOT_SUPPORTED = "Rules are not supported.";
    private static final String RESOURCE_PATH_CANNOT_BE_NULL = Messages.Resource_RESOURCE_PATH_CANNOT_BE_NULL;
    private static final Logger logger = Logger.getLogger(Resource.class);
    protected final IPath path;
    protected final Workspace workspace;
    protected final Map<QualifiedName, String> sessionProperties = new HashMap<QualifiedName, String>();

    public Resource(IPath path, Workspace workspace) {
        if (path == null) {
            throw new IllegalArgumentException(RESOURCE_PATH_CANNOT_BE_NULL);
        }
        this.path = path;
        this.workspace = workspace;
    }

    protected IRepository getRepository() {
        return this.workspace.getRepository();
    }

    public IEntity getEntity() {
        IWorkspaceRoot root = this.workspace.getRoot();
        IPath repositoryPath = root.getLocation().append(this.path);
        IRepository repository = this.getRepository();
        return repository.getResource(repositoryPath.toString());
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
        this.accept(visitor, 2, 0);
    }

    public void accept(IResourceProxyVisitor visitor, int memberFlags) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
        this.accept(visitor, depth, includePhantoms ? 1 : 0);
    }

    public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void clearHistory(IProgressMonitor arg0) throws CoreException {
    }

    public boolean contains(ISchedulingRule rule) {
        throw new UnsupportedOperationException(RULES_ARE_NOT_SUPPORTED);
    }

    public void copy(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.copy(destination, updateFlags, monitor);
    }

    public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void copy(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.copy(description, updateFlags, monitor);
    }

    public void copy(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IMarker createMarker(String type) throws CoreException {
        throw new UnsupportedOperationException(MARKERS_ARE_NOT_SUPPORTED);
    }

    public IResourceProxy createProxy() {
        throw new UnsupportedOperationException();
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        this.delete(force ? 1 : 0, monitor);
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        block5: {
            monitor = Resource.monitorWrapper(monitor);
            try {
                monitor.beginTask("deletion", -1);
                if (!this.exists()) break block5;
                try {
                    this.getEntity().delete();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    throw new CoreException(Resource.createErrorStatus(COULD_NOT_DELETE_RESOURCE));
                }
                this.workspace.notifyResourceChanged(new ResourceChangeEvent(this, 1));
            }
            finally {
                monitor.done();
            }
        }
    }

    public void deleteMarkers(String arg0, boolean arg1, int arg2) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Resource) {
            Resource other = (Resource)obj;
            return this.getType() == other.getType() && this.path.equals((Object)other.path) && this.workspace.equals(other.workspace);
        }
        return false;
    }

    public int hashCode() {
        return this.getType() * 72 + this.path.hashCode() * 72 + this.workspace.hashCode();
    }

    public boolean exists() {
        IProject project = this.getProject();
        if (project == null) {
            return this instanceof IWorkspaceRoot;
        }
        if (!project.isOpen()) {
            return false;
        }
        try {
            return this.getEntity().exists();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public IMarker findMarker(long id) throws CoreException {
        throw new UnsupportedOperationException(MARKERS_ARE_NOT_SUPPORTED);
    }

    public IMarker[] findMarkers(String type, boolean includeSubTypes, int depth) throws CoreException {
        throw new UnsupportedOperationException(MARKERS_ARE_NOT_SUPPORTED);
    }

    public int findMaxProblemSeverity(String type, boolean includeSubtypes, int depth) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getFileExtension() {
        return this.path.getFileExtension();
    }

    public IPath getFullPath() {
        if (this.getType() == 8) {
            return Path.ROOT;
        }
        return this.path;
    }

    public long getLocalTimeStamp() {
        try {
            IEntityInformation information = this.getEntity().getInformation();
            Date timeStamp = information.getModifiedAt();
            if (timeStamp != null) {
                return timeStamp.getTime();
            }
            return -1L;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public IPath getLocation() {
        return this.workspace.getLocation().append(this.path);
    }

    public URI getLocationURI() {
        return URI.create(this.getLocation().toString());
    }

    public IMarker getMarker(long arg0) {
        throw new UnsupportedOperationException();
    }

    public long getModificationStamp() {
        return this.getLocalTimeStamp();
    }

    public String getName() {
        if (this instanceof IWorkspaceRoot) {
            return "";
        }
        return this.path.lastSegment();
    }

    public IContainer getParent() {
        if (this.getType() == 8) {
            return null;
        }
        IWorkspaceRoot root = this.workspace.getRoot();
        if (this.getType() == 4) {
            return root;
        }
        IPath parentPath = this.path.removeLastSegments(1);
        if (parentPath.segmentCount() == 1) {
            return root.getProject(parentPath.lastSegment());
        }
        return root.getFolder(parentPath);
    }

    public Map<QualifiedName, String> getPersistentProperties() throws CoreException {
        return this.sessionProperties;
    }

    public String getPersistentProperty(QualifiedName key) throws CoreException {
        return this.sessionProperties.get(key);
    }

    public IProject getProject() {
        if (this.getType() == 8) {
            return null;
        }
        if (this.getType() == 4) {
            return (IProject)this;
        }
        String projectName = this.path.segment(0);
        IWorkspaceRoot root = this.workspace.getRoot();
        return root.getProject(projectName);
    }

    public IPath getProjectRelativePath() {
        if (this.getType() == 8) {
            return new Path("");
        }
        if (this.getType() == 4) {
            return new Path("");
        }
        return this.path.removeFirstSegments(1);
    }

    public IPath getRawLocation() {
        return this.getLocation();
    }

    public URI getRawLocationURI() {
        return this.getLocationURI();
    }

    public ResourceAttributes getResourceAttributes() {
        ResourceAttributes result = new ResourceAttributes();
        result.setArchive(false);
        result.setHidden(false);
        result.setExecutable(false);
        result.setReadOnly(false);
        result.setSymbolicLink(false);
        return result;
    }

    public Map<QualifiedName, Object> getSessionProperties() throws CoreException {
        return new HashMap<QualifiedName, Object>(this.sessionProperties);
    }

    public Object getSessionProperty(QualifiedName key) throws CoreException {
        return this.sessionProperties.get(key);
    }

    public int getType() {
        if (this instanceof IWorkspaceRoot) {
            return 8;
        }
        if (this instanceof IProject) {
            return 4;
        }
        if (this instanceof IFolder) {
            return 2;
        }
        if (this instanceof IFile) {
            return 1;
        }
        return 1;
    }

    public IWorkspace getWorkspace() {
        return this.workspace;
    }

    public boolean hasFilters() {
        return false;
    }

    public boolean isAccessible() {
        return this.exists();
    }

    public boolean isConflicting(ISchedulingRule rule) {
        throw new UnsupportedOperationException(RULES_ARE_NOT_SUPPORTED);
    }

    public boolean isDerived() {
        return this.isDerived(0);
    }

    public boolean isDerived(int options) {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isHidden(int arg0) {
        return false;
    }

    public boolean isLinked() {
        return this.isLinked(0);
    }

    public boolean isLinked(int options) {
        return false;
    }

    @Deprecated
    public boolean isLocal(int options) {
        return false;
    }

    public boolean isPhantom() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isSynchronized(int depth) {
        return true;
    }

    public boolean isTeamPrivateMember() {
        return false;
    }

    public boolean isTeamPrivateMember(int options) {
        return false;
    }

    public boolean isVirtual() {
        return false;
    }

    public void move(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        this.move(destination, force ? 1 : 0, monitor);
    }

    public void move(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        monitor = Resource.monitorWrapper(monitor);
        try {
            monitor.beginTask("rename", -1);
            try {
                IEntity entity = this.getEntity();
                if (entity instanceof ICollection) {
                    ICollection collection = (ICollection)entity;
                    collection.renameTo(destination.lastSegment());
                } else if (entity instanceof org.eclipse.dirigible.repository.api.IResource) {
                    org.eclipse.dirigible.repository.api.IResource resource = (org.eclipse.dirigible.repository.api.IResource)entity;
                    resource.renameTo(destination.lastSegment());
                }
            }
            catch (IOException ex) {
                throw new CoreException(Resource.createErrorStatus(COULD_NOT_RENAME_RESOURCE, ex));
            }
            this.workspace.notifyResourceChanged(new ResourceChangeEvent(this, 1));
        }
        finally {
            monitor.done();
        }
    }

    public void move(IProjectDescription descritpion, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException(MOVE_IS_STILL_UNSUPPORTED);
    }

    public void move(IProjectDescription description, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        this.move(description, updateFlags |= keepHistory ? 2 : 0, monitor);
    }

    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
    }

    public void revertModificationStamp(long value) throws CoreException {
        throw new UnsupportedOperationException(ROOLBACK_NOT_SUPPORTED);
    }

    @Deprecated
    public void setDerived(boolean isDerived) throws CoreException {
        logger.error(METHOD_SET_DERIVED_NOT_SUPPORTED);
    }

    public void setDerived(boolean isDerived, IProgressMonitor monitor) throws CoreException {
        logger.error(METHOD_SET_DERIVED_NOT_SUPPORTED);
    }

    public void setHidden(boolean arg0) throws CoreException {
        logger.error(METHOD_SET_HIDDEN_NOT_SUPPORTED);
    }

    @Deprecated
    public void setLocal(boolean flag, int depth, IProgressMonitor monitor) throws CoreException {
        logger.error(METHOD_SET_LOCAL_NOT_SUPPORTED);
    }

    public long setLocalTimeStamp(long value) throws CoreException {
        logger.error(METHOD_SET_LOCAL_TIME_STAMP_NOT_SUPPORTED);
        return this.getLocalTimeStamp();
    }

    public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
        this.sessionProperties.put(key, value);
    }

    @Deprecated
    public void setReadOnly(boolean readOnly) {
        logger.error(METHOD_SET_READ_ONLY_NOT_SUPPORTED);
    }

    public void setResourceAttributes(ResourceAttributes attributes) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
        if (value != null) {
            this.sessionProperties.put(key, value.toString());
        }
    }

    public void setTeamPrivateMember(boolean isTeamPrivate) throws CoreException {
        logger.error(METHOD_SET_TEAM_PRIVATE_MEMBER_NOT_SUPPORTED);
    }

    public void touch(IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    protected static IProgressMonitor monitorWrapper(IProgressMonitor monitor) {
        return monitor == null ? new DefaultProgressMonitor() : monitor;
    }

    protected static IStatus createOkStatus() {
        return Resource.createOkStatus(OK);
    }

    protected static IStatus createOkStatus(String message) {
        return new Status(0, "org.eclipse.dirigible.ide.workspace", message);
    }

    protected static IStatus createErrorStatus(String message) {
        return new Status(4, "org.eclipse.dirigible.ide.workspace", message);
    }

    protected static IStatus createErrorStatus(String message, Throwable ex) {
        return new Status(4, "org.eclipse.dirigible.ide.workspace", message, ex);
    }
}

