/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.git;

import java.io.File;
import java.io.IOException;
import org.eclipse.dirigible.repository.ext.git.Messages;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.DetachedHeadException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.NoFilepatternException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.util.StringUtils;

public class JGitConnector {
    private static final String INVALID_USERNAME_AND_PASSWORD = Messages.getString("JGitConnector.INVALID_USERNAME_AND_PASSWORD");
    private static final String REFS_HEADS_MASTER = "refs/heads/master";
    private static final String MERGE = "merge";
    private static final String MASTER = "master";
    private static final String BRANCH = "branch";
    public static final String ADD_ALL_FILE_PATTERN = ".";
    private static final Logger logger = Logger.getLogger(JGitConnector.class);
    private final Git git;
    private Repository repository;

    public static Repository getRepository(String repositoryPath) throws IOException {
        RepositoryBuilder repositoryBuilder = new RepositoryBuilder();
        repositoryBuilder.findGitDir(new File(repositoryPath));
        Repository repository = repositoryBuilder.build();
        repository.getConfig().setString(BRANCH, MASTER, MERGE, REFS_HEADS_MASTER);
        return repository;
    }

    public static void cloneRepository(File gitDirectory, String repositoryURI) throws InvalidRemoteException, TransportException, GitAPIException {
        JGitConnector.cloneRepository(gitDirectory, repositoryURI, null, null);
    }

    public static void cloneRepository(File gitDirectory, String repositoryURI, String username, String password) throws InvalidRemoteException, TransportException, GitAPIException {
        JGitConnector.cloneRepository(gitDirectory, repositoryURI, username, password, "origin");
    }

    public static void cloneRepository(File gitDirectory, String repositoryURI, String username, String password, String branch) throws InvalidRemoteException, TransportException, GitAPIException {
        try {
            CloneCommand cloneCommand = Git.cloneRepository();
            cloneCommand.setURI(repositoryURI);
            if (!StringUtils.isEmptyOrNull((String)username) && !StringUtils.isEmptyOrNull((String)password)) {
                cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(username, password));
            }
            cloneCommand.setRemote(branch);
            cloneCommand.setDirectory(gitDirectory);
            cloneCommand.call();
        }
        catch (NullPointerException nullPointerException) {
            throw new TransportException(INVALID_USERNAME_AND_PASSWORD);
        }
    }

    public JGitConnector(Repository repository) throws IOException {
        this.repository = repository;
        this.git = new Git(repository);
    }

    public void add(String filePattern) throws IOException, NoFilepatternException, GitAPIException {
        AddCommand addCommand = this.git.add();
        addCommand.addFilepattern(filePattern);
        addCommand.call();
    }

    public void commit(String message, String name, String email, boolean all) throws NoHeadException, NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, GitAPIException, IOException {
        CommitCommand commitCommand = this.git.commit();
        commitCommand.setMessage(message);
        commitCommand.setCommitter(name, email);
        commitCommand.setAuthor(name, email);
        commitCommand.setAll(all);
        commitCommand.call();
    }

    public void createBranch(String name, String startPoint) throws RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException, GitAPIException {
        this.repository.getConfig().setString(BRANCH, name, MERGE, REFS_HEADS_MASTER);
        CreateBranchCommand createBranchCommand = this.git.branchCreate();
        createBranchCommand.setName(name);
        createBranchCommand.setStartPoint(startPoint);
        createBranchCommand.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM);
        createBranchCommand.call();
    }

    public Ref checkout(String name) throws RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException, CheckoutConflictException, GitAPIException {
        CheckoutCommand checkoutCommand = this.git.checkout();
        checkoutCommand.setName(name);
        return checkoutCommand.call();
    }

    public void hardReset() throws CheckoutConflictException, GitAPIException {
        ResetCommand resetCommand = this.git.reset();
        resetCommand.setMode(ResetCommand.ResetType.HARD);
        resetCommand.call();
    }

    public void pull() throws WrongRepositoryStateException, InvalidConfigurationException, DetachedHeadException, InvalidRemoteException, CanceledException, RefNotFoundException, NoHeadException, TransportException, GitAPIException {
        PullCommand pullCommand = this.git.pull();
        pullCommand.call();
    }

    public void push(String username, String password) throws InvalidRemoteException, TransportException, GitAPIException {
        PushCommand pushCommand = this.git.push();
        pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(username, password));
        pushCommand.call();
    }

    public void rebase(String name) throws NoHeadException, WrongRepositoryStateException, GitAPIException {
        RebaseCommand rebaseCommand = this.git.rebase();
        rebaseCommand.setOperation(RebaseCommand.Operation.BEGIN);
        rebaseCommand.setUpstream(name);
        rebaseCommand.call();
    }

    public Status status() throws NoWorkTreeException, GitAPIException {
        return this.git.status().call();
    }

    public String getLastSHAForBranch(String branch) throws RefAlreadyExistsException, RefNotFoundException, InvalidRefNameException, CheckoutConflictException, GitAPIException {
        return this.checkout(branch).getLeaf().getObjectId().getName();
    }
}

