/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.ketch;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.internal.ketch.ElectionRound;
import org.eclipse.jgit.internal.ketch.KetchReplica;
import org.eclipse.jgit.internal.ketch.KetchSystem;
import org.eclipse.jgit.internal.ketch.KetchText;
import org.eclipse.jgit.internal.ketch.LeaderSnapshot;
import org.eclipse.jgit.internal.ketch.LocalReplica;
import org.eclipse.jgit.internal.ketch.LogIndex;
import org.eclipse.jgit.internal.ketch.Proposal;
import org.eclipse.jgit.internal.ketch.ProposalRound;
import org.eclipse.jgit.internal.ketch.Round;
import org.eclipse.jgit.internal.storage.reftree.RefTree;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KetchLeader {
    private static final Logger log = LoggerFactory.getLogger(KetchLeader.class);
    private final KetchSystem system;
    private KetchReplica[] voters;
    private KetchReplica[] followers;
    private LocalReplica self;
    final Lock lock;
    private State state = State.CANDIDATE;
    private long term;
    private final List<Proposal> queued;
    private RefTree refTree;
    volatile boolean roundHoldsReferenceToRefTree;
    private LogIndex headIndex;
    private LogIndex committedIndex;
    private boolean idle;
    private Round runningRound;

    protected KetchLeader(KetchSystem system) {
        this.system = system;
        this.lock = new ReentrantLock(true);
        this.queued = new ArrayList<Proposal>(4);
        this.idle = true;
    }

    KetchSystem getSystem() {
        return this.system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplicas(Collection<KetchReplica> replicas) {
        ArrayList<KetchReplica> v = new ArrayList<KetchReplica>(5);
        ArrayList<KetchReplica> f = new ArrayList<KetchReplica>(5);
        for (KetchReplica r : replicas) {
            switch (r.getParticipation()) {
                case FULL: {
                    v.add(r);
                    break;
                }
                case FOLLOWER_ONLY: {
                    f.add(r);
                }
            }
        }
        Collection<Integer> validVoters = KetchLeader.validVoterCounts();
        if (!validVoters.contains(v.size())) {
            throw new IllegalArgumentException(MessageFormat.format(KetchText.get().unsupportedVoterCount, v.size(), validVoters));
        }
        LocalReplica me = KetchLeader.findLocal(v);
        if (me == null) {
            throw new IllegalArgumentException(KetchText.get().localReplicaRequired);
        }
        this.lock.lock();
        try {
            this.voters = v.toArray(new KetchReplica[v.size()]);
            this.followers = f.toArray(new KetchReplica[f.size()]);
            this.self = me;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static Collection<Integer> validVoterCounts() {
        Integer[] valid = new Integer[]{1, 3, 5, 7, 9};
        return Arrays.asList(valid);
    }

    private static LocalReplica findLocal(Collection<KetchReplica> voters) {
        for (KetchReplica r : voters) {
            if (!(r instanceof LocalReplica)) continue;
            return (LocalReplica)r;
        }
        return null;
    }

    protected abstract Repository openRepository() throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueProposal(Proposal proposal) throws InterruptedException, IOException {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            proposal.abort();
            throw e;
        }
        try {
            if (this.refTree == null) {
                this.initialize();
                for (Proposal p : this.queued) {
                    this.refTree.apply(p.getCommands());
                }
            } else if (this.roundHoldsReferenceToRefTree) {
                this.refTree = this.refTree.copy();
                this.roundHoldsReferenceToRefTree = false;
            }
            if (!this.refTree.apply(proposal.getCommands())) {
                proposal.abort();
                return;
            }
            this.queued.add(proposal);
            proposal.notifyState(Proposal.State.QUEUED);
            if (this.idle) {
                this.scheduleLeader();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void initialize() throws IOException {
        try (Repository git = this.openRepository();
             RevWalk rw = new RevWalk(git);){
            this.self.initialize(git);
            ObjectId accepted = this.self.getTxnAccepted();
            if (!ObjectId.zeroId().equals(accepted)) {
                RevCommit c = rw.parseCommit(accepted);
                this.headIndex = LogIndex.unknown(accepted);
                this.refTree = RefTree.read(rw.getObjectReader(), c.getTree());
            } else {
                this.headIndex = LogIndex.unknown(ObjectId.zeroId());
                this.refTree = RefTree.newEmptyTree();
            }
        }
    }

    private void scheduleLeader() {
        this.idle = false;
        this.system.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                KetchLeader.this.runLeader();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void runLeader() {
        this.lock.lock();
        try {
            switch (2.$SwitchMap$org$eclipse$jgit$internal$ketch$KetchLeader$State[this.state.ordinal()]) {
                case 1: {
                    round = new ElectionRound(this, this.headIndex);
                    ** break;
lbl7:
                    // 1 sources

                    break;
                }
                case 2: {
                    round = this.newProposalRound();
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                default: {
                    KetchLeader.log.warn("Leader cannot run {}", (Object)this.state);
                    return;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        try {
            round.start();
        }
        catch (IOException e) {
            KetchLeader.log.error(KetchText.get().leaderFailedToStore, (Throwable)e);
            this.lock.lock();
            try {
                this.nextRound();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private ProposalRound newProposalRound() {
        ArrayList<Proposal> todo = new ArrayList<Proposal>(this.queued);
        this.queued.clear();
        this.roundHoldsReferenceToRefTree = true;
        return new ProposalRound(this, this.headIndex, todo, this.refTree);
    }

    long getTerm() {
        return this.term;
    }

    LogIndex getHead() {
        return this.headIndex;
    }

    LogIndex getCommitted() {
        return this.committedIndex;
    }

    boolean isIdle() {
        return this.idle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runAsync(Round round) {
        this.lock.lock();
        try {
            this.headIndex = round.acceptedNewIndex;
            this.runningRound = round;
            for (KetchReplica replica : this.voters) {
                replica.pushTxnAcceptedAsync(round);
            }
            for (KetchReplica replica : this.followers) {
                replica.pushTxnAcceptedAsync(round);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void onReplicaUpdate(KetchReplica replica) {
        boolean success;
        if (log.isDebugEnabled()) {
            log.debug("Replica {} finished:\n{}", (Object)replica.describeForLog(), (Object)this.snapshot());
        }
        if (replica.getParticipation() == KetchReplica.Participation.FOLLOWER_ONLY) {
            return;
        }
        if (this.runningRound == null) {
            return;
        }
        assert (this.headIndex.equals(this.runningRound.acceptedNewIndex));
        int matching = 0;
        for (KetchReplica r : this.voters) {
            if (!r.hasAccepted(this.headIndex)) continue;
            ++matching;
        }
        int quorum = this.voters.length / 2 + 1;
        boolean bl = success = matching >= quorum;
        if (!success) {
            return;
        }
        switch (this.state) {
            case CANDIDATE: {
                this.term = ((ElectionRound)this.runningRound).getTerm();
                this.state = State.LEADER;
                if (log.isDebugEnabled()) {
                    log.debug("Won election, running term " + this.term);
                }
            }
            case LEADER: {
                this.committedIndex = this.headIndex;
                if (log.isDebugEnabled()) {
                    log.debug("Committed {} in term {}", (Object)this.committedIndex.describeForLog(), (Object)this.term);
                }
                this.nextRound();
                this.commitAsync(replica);
                this.notifySuccess(this.runningRound);
                if (!log.isDebugEnabled()) break;
                log.debug("Leader state:\n{}", (Object)this.snapshot());
                break;
            }
            default: {
                log.debug("Leader ignoring replica while in {}", (Object)this.state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySuccess(Round round) {
        this.lock.unlock();
        try {
            round.success();
        }
        finally {
            this.lock.lock();
        }
    }

    private void commitAsync(KetchReplica caller) {
        for (KetchReplica r : this.voters) {
            if (r == caller || !r.shouldPushUnbatchedCommit(this.committedIndex, this.isIdle())) continue;
            r.pushCommitAsync(this.committedIndex);
        }
        for (KetchReplica r : this.followers) {
            if (r == caller || !r.shouldPushUnbatchedCommit(this.committedIndex, this.isIdle())) continue;
            r.pushCommitAsync(this.committedIndex);
        }
    }

    void nextRound() {
        this.runningRound = null;
        if (this.queued.isEmpty()) {
            this.idle = true;
        } else {
            this.scheduleLeader();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeaderSnapshot snapshot() {
        this.lock.lock();
        try {
            LeaderSnapshot s = new LeaderSnapshot();
            s.state = this.state;
            s.term = this.term;
            s.headIndex = this.headIndex;
            s.committedIndex = this.committedIndex;
            s.idle = this.isIdle();
            for (KetchReplica r : this.voters) {
                s.replicas.add(r.snapshot());
            }
            for (KetchReplica r : this.followers) {
                s.replicas.add(r.snapshot());
            }
            LeaderSnapshot leaderSnapshot = s;
            return leaderSnapshot;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.lock.lock();
        try {
            if (this.state != State.SHUTDOWN) {
                this.state = State.SHUTDOWN;
                for (KetchReplica r : this.voters) {
                    r.shutdown();
                }
                for (KetchReplica r : this.followers) {
                    r.shutdown();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.snapshot().toString();
    }

    public static enum State {
        CANDIDATE,
        LEADER,
        DEPOSED,
        SHUTDOWN;

    }
}

