/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.common.resource.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.eatop.common.metamodel.EastADLMetaModelVersionData;
import org.eclipse.eatop.common.metamodel.EastADLReleaseDescriptor;
import org.eclipse.eatop.common.preferences.IEastADLPreferenceConstants;
import org.eclipse.eatop.common.preferences.IEastADLPreferences;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.resource.BasicMigrationExtendedMetaData;
import org.eclipse.sphinx.emf.resource.ResourceHandlerRegistry;
import org.eclipse.sphinx.emf.resource.SchemaLocationURIHandler;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;

public abstract class EastADLResourceFactoryImpl
extends ResourceFactoryImpl {
    protected EastADLReleaseDescriptor eastadlRelease;
    protected ExtendedMetaData extendedMetaData;
    protected Map<String, String> schemaLocationCatalog;
    protected SchemaLocationURIHandler schemaLocationURIHandler;
    protected static Map<String, IMetaModelDescriptor> systemIdToResourceVersionDescriptorCache = new HashMap<String, IMetaModelDescriptor>();

    protected EastADLResourceFactoryImpl(EastADLReleaseDescriptor eastadlRelease) {
        Assert.isNotNull((Object)eastadlRelease);
        Assert.isNotNull((Object)eastadlRelease.getRootEPackage());
        this.eastadlRelease = eastadlRelease;
        this.extendedMetaData = this.createExtendedMetaData();
        this.schemaLocationCatalog = this.createSchemaLocationCatalog();
        this.schemaLocationURIHandler = this.createSchemaLocationURIHandler();
        this.initSchemaLocationBaseURIs();
    }

    protected SchemaLocationURIHandler createSchemaLocationURIHandler() {
        return new SchemaLocationURIHandler(this.schemaLocationCatalog){

            public URI resolve(URI uri) {
                String lastSegment = uri.lastSegment();
                if (lastSegment != null && lastSegment.endsWith("%20xml.xsd")) {
                    uri = URI.createURI((String)"xml.xsd");
                }
                return super.resolve(uri);
            }
        };
    }

    protected ExtendedMetaData createExtendedMetaData() {
        BasicMigrationExtendedMetaData extendedMetaData = new BasicMigrationExtendedMetaData((EPackage.Registry)new EPackageRegistryImpl(EPackage.Registry.INSTANCE)){

            public String getNamespace(EPackage ePackage) {
                String uri = ePackage.getNsURI();
                if (uri != null && uri.startsWith("http://east-adl.info")) {
                    return EastADLResourceFactoryImpl.this.eastadlRelease.getNamespace();
                }
                return super.getNamespace(ePackage);
            }
        };
        extendedMetaData.putPackage(this.eastadlRelease.getNamespace(), this.eastadlRelease.getRootEPackage());
        for (java.net.URI compatibleNamespaceURI : this.eastadlRelease.getCompatibleNamespaceURIs()) {
            extendedMetaData.putPackage(compatibleNamespaceURI.toString(), this.eastadlRelease.getRootEPackage());
        }
        return extendedMetaData;
    }

    protected Map<String, String> createSchemaLocationCatalog() {
        HashMap<String, String> schemaLocationCatalog = new HashMap<String, String>();
        Collection compatibleDescriptors = this.eastadlRelease.getCompatibleResourceVersionDescriptors();
        for (IMetaModelDescriptor descriptor : compatibleDescriptors) {
            EastADLReleaseDescriptor eastadlDescriptor = (EastADLReleaseDescriptor)descriptor;
            schemaLocationCatalog.put(descriptor.getNamespace(), EastADLResourceFactoryImpl.getSchemaLocation(eastadlDescriptor));
        }
        return schemaLocationCatalog;
    }

    protected abstract void initSchemaLocationBaseURIs();

    public void initResource(XMLResource resource) {
        this.initDefaultOptions(resource);
        this.installResourceHandler(resource);
    }

    protected void initDefaultOptions(XMLResource resource) {
        resource.getDefaultLoadOptions().put("EXTENDED_META_DATA", this.extendedMetaData);
        resource.getDefaultSaveOptions().put("EXTENDED_META_DATA", this.extendedMetaData);
        resource.getDefaultLoadOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        resource.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
        resource.getDefaultLoadOptions().put("USE_LEXICAL_HANDLER", Boolean.TRUE);
        resource.getDefaultSaveOptions().put("ENCODING", "UTF-8");
        resource.getDefaultSaveOptions().put("SAVE_TYPE_INFORMATION", Boolean.FALSE);
        IMetaModelDescriptor resourceVersionDescriptor = this.getResourceVersionDescriptor((Resource)resource);
        resource.getDefaultLoadOptions().put("RESOURCE_VERSION_DESCRIPTOR", resourceVersionDescriptor);
        resource.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
        resource.getDefaultSaveOptions().put("SCHEMA_LOCATION_CATALOG", this.schemaLocationCatalog);
        resource.getDefaultLoadOptions().put("URI_HANDLER", this.schemaLocationURIHandler);
        resource.getDefaultSaveOptions().put("URI_HANDLER", this.schemaLocationURIHandler);
        resource.getDefaultLoadOptions().put("ENABLE_SCHEMA_VALIDATION", Platform.isRunning() ? (Boolean)IEastADLPreferences.XSD_VALIDATION_ON_LOAD.get() : IEastADLPreferenceConstants.PREF_XSD_VALIDATION_ON_LOAD_DEFAULT);
        resource.getDefaultLoadOptions().put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        resource.getDefaultLoadOptions().put("SUPPRESS_DOCUMENT_ROOT", Boolean.TRUE);
        resource.getDefaultLoadOptions().put("USE_CONTEXT_AWARE_PROXY_URIS", Boolean.FALSE);
    }

    public IMetaModelDescriptor getResourceVersionDescriptor(Resource resource) {
        Assert.isNotNull((Object)resource);
        String modelNamespace = EcoreResourceUtil.readModelNamespace((Resource)resource);
        if (modelNamespace == null) {
            return null;
        }
        ArrayList<EastADLReleaseDescriptor> applicableDescriptors = new ArrayList<EastADLReleaseDescriptor>();
        Collection compatibleDescriptors = this.eastadlRelease.getCompatibleResourceVersionDescriptors();
        for (IMetaModelDescriptor descriptor : compatibleDescriptors) {
            EastADLReleaseDescriptor eastadlDescriptor = (EastADLReleaseDescriptor)descriptor;
            if (!eastadlDescriptor.getNamespace().equals(modelNamespace)) continue;
            applicableDescriptors.add(eastadlDescriptor);
        }
        if (applicableDescriptors.size() == 1) {
            return (IMetaModelDescriptor)applicableDescriptors.get(0);
        }
        if (applicableDescriptors.size() == 0) {
            return null;
        }
        Map schemaLocationEntries = EcoreResourceUtil.readSchemaLocationEntries((Resource)resource);
        String schemaLocation = (String)schemaLocationEntries.get(modelNamespace);
        if (schemaLocation == null) {
            return (IMetaModelDescriptor)applicableDescriptors.get(applicableDescriptors.size() - 1);
        }
        IMetaModelDescriptor releaseDescriptorCache = systemIdToResourceVersionDescriptorCache.get(schemaLocation);
        if (releaseDescriptorCache != null) {
            return releaseDescriptorCache;
        }
        for (EastADLReleaseDescriptor eastadlDescriptor : applicableDescriptors) {
            if (!EastADLResourceFactoryImpl.getSchemaLocation(eastadlDescriptor).equals(schemaLocation)) continue;
            systemIdToResourceVersionDescriptorCache.put(schemaLocation, (IMetaModelDescriptor)eastadlDescriptor);
            return eastadlDescriptor;
        }
        return null;
    }

    protected void installResourceHandler(XMLResource resource) {
        XMLResource.ResourceHandler resourceHandler = ResourceHandlerRegistry.INSTANCE.getHandler(this.eastadlRelease.getRootEPackage().getNsURI());
        if (resourceHandler != null) {
            resource.getDefaultLoadOptions().put("RESOURCE_HANDLER", resourceHandler);
            resource.getDefaultSaveOptions().put("RESOURCE_HANDLER", resourceHandler);
        }
    }

    private static String getSchemaLocation(EastADLReleaseDescriptor eastadlDescriptor) {
        EastADLMetaModelVersionData versionData = eastadlDescriptor.getEastADLVersionData();
        return "eastadl_" + versionData.getMajor() + "-" + versionData.getMinor() + "-" + versionData.getRevision() + ".xsd";
    }
}

