/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.common.ui.perspectives;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class EatopPerspectiveFactory
implements IPerspectiveFactory {
    private IPageLayout layout;

    public void createInitialLayout(IPageLayout layout) {
        this.layout = layout;
        this.createLayout(layout);
        this.addNewWizardShortcuts();
        this.addShowViewShortcuts();
        this.addPerspectiveShortcuts();
        this.addActionSets();
    }

    private void createLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        int relativePos = 1;
        IFolderLayout topLeft = layout.createFolder("topLeft", relativePos, 0.2f, editorArea);
        topLeft.addView("org.eclipse.eatop.examples.explorer.views.eastadlExplorer");
        topLeft.addView("org.eclipse.ui.navigator.ProjectExplorer");
        relativePos = 4;
        IFolderLayout bottomRight = layout.createFolder("bottomRight", relativePos, 0.65f, editorArea);
        bottomRight.addView("org.eclipse.ui.views.PropertySheet");
        bottomRight.addView("org.eclipse.pde.runtime.LogView");
        bottomRight.addPlaceholder("org.eclipse.ui.views.ProblemView");
        bottomRight.addPlaceholder("org.eclipse.ui.console.ConsoleView");
    }

    private void addNewWizardShortcuts() {
        this.layout.addNewWizardShortcut("org.eclipse.eatop.examples.common.ui.newWizards.eastadlProject");
        this.layout.addNewWizardShortcut("org.eclipse.eatop.examples.common.ui.newWizards.eastadlFile");
        this.layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
        this.layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
    }

    private void addShowViewShortcuts() {
        this.layout.addShowViewShortcut("org.eclipse.eatop.examples.explorer.views.eastadlExplorer");
        this.layout.addShowViewShortcut("org.eclipse.ui.navigator.ProjectExplorer");
        this.layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        this.layout.addShowViewShortcut("org.eclipse.ui.views.PropertySheet");
        this.layout.addShowViewShortcut("org.eclipse.pde.runtime.LogView");
        this.layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        this.layout.addShowViewShortcut("org.eclipse.ui.console.ConsoleView");
    }

    private void addPerspectiveShortcuts() {
        this.layout.addPerspectiveShortcut("org.eclipse.ui.resourcePerspective");
    }

    private void addActionSets() {
        this.layout.addActionSet("org.eclipse.debug.ui.launchActionSet");
        this.layout.addActionSet("org.eclipse.team.ui.actionSet");
    }
}

