/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.examples.explorer.dialogs;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import org.eclipse.eatop.common.ui.util.ModelSearcher;
import org.eclipse.eatop.examples.explorer.internal.messages.Messages;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class InstanceRefEditorDialog
extends Dialog {
    protected ILabelProvider labelProvider;
    protected IContentProvider contentProvider;
    protected Object object;
    protected EClassifier eClassifier;
    protected String displayName;
    protected ItemProvider values;
    protected List<?> choiceOfValues;
    protected Object result;
    protected boolean multiLine;
    protected boolean unique;
    protected boolean isManyFeature;
    protected Object selectedObject;
    protected boolean autoresolve;
    protected boolean forceAutoresolve;
    protected TreePath resultPath;
    protected boolean isTarget;

    public InstanceRefEditorDialog(Shell parent, ILabelProvider labelProvider, EObject eObject, EStructuralFeature eStructuralFeature, String displayName, List<?> choiceOfValues, boolean forceAutoresolve) {
        super(parent);
        this.labelProvider = labelProvider;
        this.object = eObject;
        this.choiceOfValues = choiceOfValues;
        ArrayList l = new ArrayList();
        for (Object o : choiceOfValues) {
            if (o == null) continue;
            l.add(o);
        }
        this.choiceOfValues = l;
        this.autoresolve = true;
        this.forceAutoresolve = forceAutoresolve;
        this.isTarget = this.isTargetFeature(eStructuralFeature);
        this.isManyFeature = eStructuralFeature.isMany();
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    private boolean isTargetFeature(EStructuralFeature feature) {
        EAnnotation annotation = feature.getEAnnotation(Messages.Annotation_Stereotype);
        return annotation != null && annotation.getDetails().containsValue((Object)Messages.InstanceRef_Target);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.isTarget) {
            shell.setText("Instance reference target");
        } else {
            shell.setText("Instance reference context");
        }
        shell.setImage(this.labelProvider.getImage(this.object));
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        GridData contentsGridData = new GridData(4, 4, true, true);
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        GridLayout grid = new GridLayout();
        grid.numColumns = 1;
        contents.setLayout((Layout)grid);
        contents.setSize(400, 550);
        Tree tree = new Tree(contents, 2052);
        GridData treeGridData = new GridData(4, 4, true, true);
        treeGridData.widthHint = 300;
        treeGridData.heightHint = 300;
        TreeViewer newTreeViewer = new TreeViewer(tree);
        newTreeViewer.getTree().setLayout((Layout)new FillLayout());
        newTreeViewer.getTree().setLayoutData((Object)treeGridData);
        newTreeViewer.setContentProvider((IContentProvider)new InstanceRefTreeProvider());
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory);
        newTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        newTreeViewer.setInput(this.choiceOfValues);
        newTreeViewer.addSelectionChangedListener(this.createSelectionListener());
        if (!this.forceAutoresolve && this.isTarget) {
            Button check = new Button(contents, 32);
            check.setSelection(true);
            check.setText("Try to automatically set context");
            check.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InstanceRefEditorDialog.this.autoresolve = ((Button)e.widget).getSelection();
                }
            });
        }
        return contents;
    }

    private ISelectionChangedListener createSelectionListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                if (event.getSelection() instanceof ITreeSelection) {
                    ITreeSelection selection = (ITreeSelection)event.getSelection();
                    InstanceRefEditorDialog.this.resultPath = selection.getPaths()[0];
                    Object o = selection.getFirstElement();
                    if (o instanceof EObject) {
                        InstanceRefEditorDialog.this.selectedObject = o;
                    }
                }
            }
        };
    }

    private EList<EObject> buildContextList() {
        EObject selectedContext = (EObject)this.selectedObject;
        EClass contextClass = selectedContext.eClass();
        BasicEList l = new BasicEList();
        l.add((Object)selectedContext);
        int i = this.resultPath.getSegmentCount() - 2;
        while (i > 0) {
            if (((EObject)this.resultPath.getSegment(i)).eClass() == contextClass) {
                l.add((Object)((EObject)this.resultPath.getSegment(i)));
            }
            --i;
        }
        return l;
    }

    protected void okPressed() {
        this.result = !this.isManyFeature ? this.selectedObject : this.buildContextList();
        super.okPressed();
    }

    public boolean close() {
        return super.close();
    }

    public Object getResult() {
        if (this.isManyFeature) {
            new BasicEList();
            return this.result;
        }
        return this.result;
    }

    public boolean getAutoresolveSelected() {
        return this.autoresolve;
    }

    public TreePath getTreePath() {
        return this.resultPath;
    }

    class InstanceRefTreeProvider
    implements ITreeContentProvider {
        InstanceRefTreeProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            HashSet<EObject> elements = new HashSet<EObject>();
            for (Object o : (List)inputElement) {
                if (!(o instanceof EObject)) continue;
                elements.add(EcoreUtil.getRootContainer((EObject)((EObject)o)));
            }
            return elements.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            HashSet<EObject> children = new HashSet<EObject>();
            Object[] typeChildren = this.addTypeChildren((EObject)parentElement, new Object[0]);
            List<Object> typeChildrenList = Arrays.asList(typeChildren);
            for (Object choice : InstanceRefEditorDialog.this.choiceOfValues) {
                for (EObject eObject : ((EObject)parentElement).eContents()) {
                    if (!ModelSearcher.isIndirectRealOrVirtualAncestor((EObject)eObject, (EObject)((EObject)choice))) continue;
                    children.add(eObject);
                }
                for (EObject eObject : typeChildrenList) {
                    if (!ModelSearcher.isVirtualAncestorOrEquals((EObject)eObject, (EObject)((EObject)choice))) continue;
                    children.add(eObject);
                }
            }
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof EObject) {
                return ((EObject)element).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            for (Object choice : InstanceRefEditorDialog.this.choiceOfValues) {
                if (element == choice || !ModelSearcher.isRealOrVirtualAncestor((EObject)((EObject)element), (EObject)((EObject)choice))) continue;
                return true;
            }
            return false;
        }

        private Object[] addTypeChildren(EObject parentElement, Object[] children) {
            EObject typeEObject = this.getEObjectType(parentElement);
            if (typeEObject != null) {
                ArrayList<Object> childrenList = new ArrayList<Object>();
                if (children != null) {
                    childrenList.addAll(Arrays.asList(children));
                }
                childrenList.addAll((Collection<Object>)typeEObject.eContents());
                return childrenList.toArray();
            }
            return children;
        }

        private EObject getEObjectType(EObject parentElement) {
            Object eGet;
            EStructuralFeature eStructuralFeature = parentElement.eClass().getEStructuralFeature("type");
            if (eStructuralFeature != null && (eGet = parentElement.eGet(eStructuralFeature)) != null && eGet instanceof EObject) {
                return (EObject)eGet;
            }
            return null;
        }

        public Deque<EObject> getPath(Object leaf) {
            ArrayDeque<EObject> path = new ArrayDeque<EObject>();
            path.addFirst((EObject)leaf);
            while (this.getParent(leaf) != null) {
                path.addFirst((EObject)this.getParent(leaf));
                leaf = this.getParent(leaf);
            }
            return path;
        }
    }
}

