/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eatop.workspace.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.eatop.common.metamodel.EastADLReleaseDescriptor;
import org.eclipse.eatop.workspace.internal.Activator;
import org.eclipse.eatop.workspace.natures.EastADLNature;
import org.eclipse.eatop.workspace.preferences.IEastADLWorkspacePreferences;
import org.eclipse.sphinx.emf.internal.metamodel.InternalMetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class EastADLPlatformUtil {
    private static void collectEastADLProjectsInGroup(IProject project, boolean includeReferencingProjects, Set<IProject> projectGroup, Set<IProject> visitedProjects) {
        if (project.isAccessible() && visitedProjects.add(project)) {
            IProject p;
            if (EastADLPlatformUtil.hasEastADLNature(project)) {
                projectGroup.add(project);
            }
            IProject[] iProjectArray = ExtendedPlatform.getReferencedProjectsSafely((IProject)project);
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                p = iProjectArray[n2];
                if (p.isAccessible() && EastADLPlatformUtil.hasEastADLNature(p)) {
                    EastADLPlatformUtil.collectEastADLProjectsInGroup(p, includeReferencingProjects, projectGroup, visitedProjects);
                }
                ++n2;
            }
            if (includeReferencingProjects) {
                iProjectArray = ExtendedPlatform.getReferencingProjectsSafely((IProject)project);
                n = iProjectArray.length;
                n2 = 0;
                while (n2 < n) {
                    p = iProjectArray[n2];
                    if (p.isAccessible() && EastADLPlatformUtil.hasEastADLNature(p)) {
                        EastADLPlatformUtil.collectEastADLProjectsInGroup(p, includeReferencingProjects, projectGroup, visitedProjects);
                    }
                    ++n2;
                }
            }
        }
    }

    public static boolean hasEastADLNature(IProject project) {
        Assert.isNotNull((Object)project);
        Assert.isTrue((boolean)project.isAccessible());
        boolean hasEastADLNature = false;
        try {
            hasEastADLNature = project.hasNature(EastADLNature.ID);
        }
        catch (CoreException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)((Object)ex));
        }
        return hasEastADLNature;
    }

    public static Collection<IProject> getProjectGroup(IProject project, boolean includeReferencingProjects) {
        Assert.isNotNull((Object)project);
        HashSet<IProject> projectGroup = new HashSet<IProject>();
        EastADLPlatformUtil.collectEastADLProjectsInGroup(project, includeReferencingProjects, projectGroup, new HashSet<IProject>());
        return projectGroup;
    }

    public static Collection<IProject> getProjectGroup(IModelDescriptor modelDescriptor) {
        IProject project;
        Assert.isNotNull((Object)modelDescriptor);
        HashSet<IProject> projectGroup = new HashSet<IProject>();
        IResource root = modelDescriptor.getRoot();
        if (root != null && (project = root.getProject()).isAccessible() && EastADLPlatformUtil.hasEastADLNature(project)) {
            projectGroup.add(project);
        }
        for (IResource resource : modelDescriptor.getReferencedRoots()) {
            IProject project2 = resource.getProject();
            if (!project2.isAccessible() || !EastADLPlatformUtil.hasEastADLNature(project2)) continue;
            projectGroup.add(project2);
        }
        return projectGroup;
    }

    public static IStatus convertToEastADLProject(IProject project, EastADLReleaseDescriptor eastadlRelease, IProgressMonitor monitor) {
        Assert.isNotNull((Object)project);
        Assert.isNotNull((Object)eastadlRelease);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!EastADLPlatformUtil.hasEastADLNature(project)) {
            progress.subTask("Set EAST-ADL nature to project");
            try {
                EastADLNature.addTo(project, (IProgressMonitor)progress);
            }
            catch (CoreException ex) {
                return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)((Object)ex));
            }
        }
        IEastADLWorkspacePreferences.RESOURCE_VERSION.set(project, (Object)eastadlRelease);
        EastADLReleaseDescriptor currentReleaseDescriptor = (EastADLReleaseDescriptor)IEastADLWorkspacePreferences.EAST_ADL_RELEASE.get(project);
        if (currentReleaseDescriptor == null) {
            IEastADLWorkspacePreferences.EAST_ADL_RELEASE.setInProject(project, (Object)eastadlRelease);
        }
        for (IFile file : ExtendedPlatform.getAllFiles((IProject)project, (boolean)false)) {
            if (!"eaxml".equals(file.getFileExtension())) continue;
            InternalMetaModelDescriptorRegistry.INSTANCE.removeCachedDescriptor(file);
            InternalMetaModelDescriptorRegistry.INSTANCE.addCachedDescriptor(file, (IMetaModelDescriptor)eastadlRelease);
        }
        ModelDescriptorRegistry.INSTANCE.addModels(project);
        return Status.OK_STATUS;
    }
}

