/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.relp;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.scada.protocol.relp.data.AbstractGenericResponse;
import org.eclipse.scada.protocol.relp.data.Frame;
import org.eclipse.scada.protocol.relp.data.OpenRequest;
import org.eclipse.scada.protocol.relp.data.OpenResponse;
import org.eclipse.scada.protocol.relp.data.ServerCloseMessage;
import org.eclipse.scada.protocol.relp.data.SyslogRequest;
import org.eclipse.scada.protocol.relp.data.SyslogResponse;

public class FrameProcessor
extends ChannelDuplexHandler {
    private static final Charset CHARSET_OPEN = StandardCharsets.US_ASCII;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof Frame) {
            this.processFrame(ctx, (Frame)msg);
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof OpenResponse) {
            this.writeOpenResponse(ctx, (OpenResponse)msg, promise);
        } else if (msg instanceof SyslogResponse) {
            this.writeGenericResponse(ctx, (AbstractGenericResponse)msg, promise);
        } else if (msg instanceof ServerCloseMessage) {
            ctx.write((Object)new Frame(0L, "serverclose", null));
        } else {
            super.write(ctx, msg, promise);
        }
    }

    protected void writeGenericResponse(ChannelHandlerContext ctx, AbstractGenericResponse msg, ChannelPromise promise) {
        ctx.write((Object)this.createCommonResponse(msg.getTransactionId(), msg.getCode(), msg.getMessage(), null));
    }

    protected void writeOpenResponse(ChannelHandlerContext ctx, OpenResponse msg, ChannelPromise promise) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> entry : msg.getOffers().entrySet()) {
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(entry.getKey());
            if (entry.getValue() != null) {
                sb.append('=');
                sb.append(entry.getValue());
            }
            ++i;
        }
        ctx.write((Object)this.createCommonResponse(msg.getTransactionId(), msg.getCode(), msg.getMessage(), sb));
    }

    private Frame createCommonResponse(long transactionId, int code, String message, StringBuilder data) {
        StringBuilder sb = new StringBuilder();
        sb.append(code);
        if (message != null && !message.isEmpty()) {
            sb.append(" ");
            sb.append(message);
        }
        if (data != null) {
            sb.append("\n");
            sb.append((CharSequence)data);
        }
        return new Frame(transactionId, "rsp", sb.toString());
    }

    private void processFrame(ChannelHandlerContext ctx, Frame frame) {
        if (frame.getCommand() == null) {
            throw new IllegalStateException("Null command");
        }
        switch (frame.getCommand()) {
            case "open": {
                this.handleOpen(ctx, frame);
                break;
            }
            case "syslog": {
                this.handleSyslog(ctx, frame);
            }
        }
    }

    private void handleSyslog(ChannelHandlerContext ctx, Frame frame) {
        ctx.fireChannelRead((Object)new SyslogRequest(frame.getTransactionId(), frame.getData()));
    }

    protected void handleOpen(ChannelHandlerContext ctx, Frame frame) {
        String data = frame.getData().toString(CHARSET_OPEN);
        StringTokenizer tok = new StringTokenizer(data, "\n");
        HashMap<String, String> offers = new HashMap<String, String>();
        while (tok.hasMoreTokens()) {
            String tpl = tok.nextToken();
            String[] fields = tpl.split("=", 2);
            if (fields.length > 1) {
                offers.put(fields[0], fields[1]);
                continue;
            }
            offers.put(fields[0], fields[0]);
        }
        ctx.fireChannelRead((Object)new OpenRequest(frame.getTransactionId(), offers));
    }
}

