/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common.mc.handshake;

import java.util.Map;
import org.eclipse.scada.protocol.ngp.common.ChainConfigurator;
import org.eclipse.scada.protocol.ngp.common.mc.MessageChannelFilter;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.AbstractHandshake;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.HandshakeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutHandshake
extends AbstractHandshake {
    private static final Logger logger = LoggerFactory.getLogger(TimeoutHandshake.class);

    @Override
    public void request(HandshakeContext handshakeContext, Map<String, String> helloProperties) {
        helloProperties.put("timeout", "" + handshakeContext.getProtocolConfiguration().getTimeout());
    }

    @Override
    public void handshake(HandshakeContext handshakeContext, Map<String, String> helloProperties, Map<String, String> acceptedProperties) throws Exception {
        Integer timeout = this.getInteger(helloProperties, "timeout", null);
        if (timeout != null) {
            int newTimeout = Math.min(Math.max(timeout, MessageChannelFilter.MIN_TIMEOUT), MessageChannelFilter.MAX_TIMEOUT);
            logger.info("Timeout setting = {}", (Object)newTimeout);
            acceptedProperties.put("timeout", "" + newTimeout);
        }
    }

    @Override
    public void apply(HandshakeContext handshakeContext, Map<String, String> acceptedProperties) throws Exception {
    }

    @Override
    public void postApply(HandshakeContext handshakeContext, Map<String, String> acceptedProperties) throws Exception {
    }

    @Override
    public void sessionStarted(HandshakeContext handshakeContext, Map<String, String> acceptedProperties) throws Exception {
        Integer timeout = this.getInteger(acceptedProperties, "timeout", null);
        if (timeout != null) {
            int pingFrequency = Integer.getInteger("org.eclipse.scada.protocol.ngp.common.mc.pingFrequency", 3);
            new ChainConfigurator(handshakeContext.getSession()).startKeepAlive(pingFrequency, (int)Math.ceil((double)timeout.intValue() / 1000.0));
            return;
        }
        new ChainConfigurator(handshakeContext.getSession()).startKeepAlive(handshakeContext.getProtocolConfiguration().getPingFrequency(), (int)Math.ceil((double)handshakeContext.getProtocolConfiguration().getTimeout() / 1000.0));
    }
}

