/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.generator.ui.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.acceleo.engine.service.AbstractAcceleoGenerator;
import org.eclipse.acceleo.engine.utils.AcceleoLaunchingUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.scada.protocol.ngp.generator.ui.Activator;
import org.osgi.framework.Bundle;

public class GenerateAll {
    private final URI modelURI;
    private final IContainer targetFolder;
    List<? extends Object> arguments;
    private final String main;

    public GenerateAll(URI modelURI, IContainer targetFolder, List<? extends Object> arguments, String main) {
        this.modelURI = modelURI;
        this.targetFolder = targetFolder;
        this.arguments = arguments;
        this.main = main;
    }

    public void doGenerate(IProgressMonitor monitor) throws Exception {
        if (!this.targetFolder.getLocation().toFile().exists()) {
            this.targetFolder.getLocation().toFile().mkdirs();
        }
        monitor.subTask("Loading...");
        Class clazz = Activator.getDefault().getBundle().loadClass(this.main);
        Constructor ctor = clazz.getConstructor(URI.class, File.class, List.class);
        AbstractAcceleoGenerator gen0 = (AbstractAcceleoGenerator)ctor.newInstance(this.modelURI, this.targetFolder.getLocation().toFile(), this.arguments);
        monitor.worked(1);
        String generationID = AcceleoLaunchingUtil.computeUIProjectID((String)"org.eclipse.scada.protocol.ngp.generator", (String)this.main, (String)this.modelURI.toString(), (String)this.targetFolder.getFullPath().toString(), new ArrayList());
        gen0.setGenerationID(generationID);
        gen0.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
    }

    private URI getTemplateURI(String bundleID, IPath relativePath) throws IOException {
        Enumeration entries;
        Bundle bundle = Platform.getBundle((String)bundleID);
        if (bundle == null) {
            return URI.createPlatformResourceURI((String)new Path(bundleID).append(relativePath).toString(), (boolean)false);
        }
        URL url = bundle.getEntry(relativePath.toString());
        if (url == null && relativePath.segmentCount() > 1 && (entries = bundle.findEntries("/", "*.emtl", true)) != null) {
            String[] segmentsRelativePath = relativePath.segments();
            while (url == null && entries.hasMoreElements()) {
                String[] segmentsPath;
                URL entry = (URL)entries.nextElement();
                Path path = new Path(entry.getPath());
                if (path.segmentCount() > relativePath.segmentCount()) {
                    path = path.removeFirstSegments(path.segmentCount() - relativePath.segmentCount());
                }
                boolean equals = (segmentsPath = path.segments()).length == segmentsRelativePath.length;
                int i = 0;
                while (equals && i < segmentsPath.length) {
                    equals = segmentsPath[i].equals(segmentsRelativePath[i]);
                    ++i;
                }
                if (!equals) continue;
                url = bundle.getEntry(entry.getPath());
            }
        }
        URI result = url != null ? URI.createPlatformPluginURI((String)new Path(bundleID).append((IPath)new Path(url.getPath())).toString(), (boolean)false) : URI.createPlatformResourceURI((String)new Path(bundleID).append(relativePath).toString(), (boolean)false);
        return result;
    }
}

