/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.model.Protocol;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Type implements Enumerator
{
    SCALAR(0, "SCALAR", "SCALAR"),
    OPTIONAL(1, "OPTIONAL", "OPTIONAL"),
    ORDERED(2, "ORDERED", "ORDERED"),
    UNIQUE(3, "UNIQUE", "UNIQUE");

    public static final int SCALAR_VALUE = 0;
    public static final int OPTIONAL_VALUE = 1;
    public static final int ORDERED_VALUE = 2;
    public static final int UNIQUE_VALUE = 3;
    private static final Type[] VALUES_ARRAY;
    public static final List<Type> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Type[]{SCALAR, OPTIONAL, ORDERED, UNIQUE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Type get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Type result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Type getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Type result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Type get(int value) {
        switch (value) {
            case 0: {
                return SCALAR;
            }
            case 1: {
                return OPTIONAL;
            }
            case 2: {
                return ORDERED;
            }
            case 3: {
                return UNIQUE;
            }
        }
        return null;
    }

    private Type(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

