/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.relp.service;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.eclipse.scada.protocol.relp.FrameCodec;
import org.eclipse.scada.protocol.relp.FrameProcessor;
import org.eclipse.scada.protocol.relp.Helper;
import org.eclipse.scada.protocol.relp.RelpExceptionHandler;
import org.eclipse.scada.protocol.relp.RelpHandler;
import org.eclipse.scada.protocol.relp.service.ReceiverHandler;
import org.eclipse.scada.protocol.relp.service.ReceiverHandlerFactory;
import org.eclipse.scada.protocol.relp.service.ReceiverSession;
import org.eclipse.scada.protocol.syslog.SyslogCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Receiver
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Receiver.class);
    private final NioEventLoopGroup bossGroup;
    private final NioEventLoopGroup workerGroup;
    private final ServerBootstrap bootstrap;
    private final Channel channel;
    private final ReceiverHandlerFactory factory;

    public Receiver(ReceiverHandlerFactory factory, int port) {
        this(factory, new InetSocketAddress(port));
    }

    public Receiver(ReceiverHandlerFactory factory, SocketAddress addr) {
        this.factory = factory;
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup);
        this.bootstrap.channel(NioServerSocketChannel.class);
        this.bootstrap.option(ChannelOption.SO_BACKLOG, (Object)5);
        this.bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                Receiver.this.handleInitChannel(ch);
            }
        });
        this.channel = this.bootstrap.bind(addr).channel();
        logger.info("Receiver running ...");
    }

    protected void handleInitChannel(SocketChannel ch) {
        logger.debug("Create new sessesion - channel: {}", (Object)ch);
        ch.pipeline().addLast("frame.decoder", (ChannelHandler)new FrameCodec());
        ch.pipeline().addLast("frame.processor", (ChannelHandler)new FrameProcessor());
        ch.pipeline().addLast("relp.handler", (ChannelHandler)new RelpHandler());
        ch.pipeline().addLast("syslog", (ChannelHandler)new SyslogCodec(Helper.RELP));
        ch.pipeline().addLast("exception", (ChannelHandler)new RelpExceptionHandler());
        ReceiverHandler handler = this.factory.createHandler();
        new ReceiverSession(ch, handler);
    }

    @Override
    public void close() {
        this.channel.close();
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully();
    }
}

