/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.modbus.message;

import org.eclipse.scada.protocol.modbus.io.ModbusProtocolError;

public class ModbusApplicationHeader {
    public static final int MBAP_HEADER_SIZE = 7;
    public static final int PROTOCOL_IDENTIFIER = 0;
    final int transactionIdentifier;
    final int protocolIdentifier;
    final int length;
    final byte unitIdentifier;

    public ModbusApplicationHeader(int transactionIdentifier, int protocolIdentifier, int length, byte unitIdentifier) {
        if (protocolIdentifier != 0) {
            throw new ModbusProtocolError(String.format("protocolIdentifier must be %s but is %s", 0, protocolIdentifier));
        }
        if (length > 254) {
            throw new ModbusProtocolError(String.format("length must be less or equal than %s", 254));
        }
        this.transactionIdentifier = transactionIdentifier;
        this.protocolIdentifier = protocolIdentifier;
        this.length = length;
        this.unitIdentifier = unitIdentifier;
    }

    public int getTransactionIdentifier() {
        return this.transactionIdentifier;
    }

    public int getProtocolIdentifier() {
        return this.protocolIdentifier;
    }

    public int getLength() {
        return this.length;
    }

    public byte getUnitIdentifier() {
        return this.unitIdentifier;
    }
}

