/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.modbus.slave;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoConnector;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.SimpleIoProcessorPool;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.nio.NioProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.eclipse.scada.protocol.modbus.codec.ModbusRtuDecoder;
import org.eclipse.scada.protocol.modbus.codec.ModbusRtuEncoder;
import org.eclipse.scada.protocol.modbus.codec.ModbusRtuProtocolCodecFilter;
import org.eclipse.scada.protocol.modbus.codec.ModbusSlaveProtocolFilter;
import org.eclipse.scada.protocol.modbus.codec.ModbusTcpDecoder;
import org.eclipse.scada.protocol.modbus.codec.ModbusTcpEncoder;
import org.eclipse.scada.protocol.modbus.message.BaseMessage;
import org.eclipse.scada.protocol.modbus.message.ErrorResponse;
import org.eclipse.scada.protocol.modbus.message.ReadResponse;
import org.eclipse.scada.protocol.modbus.message.WriteMultiDataRequest;
import org.eclipse.scada.protocol.modbus.message.WriteMultiDataResponse;
import org.eclipse.scada.protocol.modbus.message.WriteSingleDataRequest;
import org.eclipse.scada.protocol.modbus.message.WriteSingleDataResponse;
import org.eclipse.scada.protocol.modbus.slave.ProtocolOptions;
import org.eclipse.scada.protocol.modbus.slave.SessionContext;
import org.eclipse.scada.protocol.modbus.slave.Slave;
import org.eclipse.scada.protocol.modbus.slave.SlaveHandle;
import org.eclipse.scada.utils.concurrent.ScheduledExportedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlaveHost {
    private static final Logger logger = LoggerFactory.getLogger(SlaveHost.class);
    private static final AtomicLong COUNTER = new AtomicLong();
    private final SimpleIoProcessorPool<NioSession> processor;
    private final IoAcceptor acceptor;
    private final boolean disposeAcceptor;
    private final ProtocolOptions options;
    private ScheduledExecutorService executor;
    private final Map<Integer, Slave> slaves = new HashMap<Integer, Slave>();
    private final IoConnector connector;

    public SlaveHost(ProtocolOptions options, int port) throws IOException {
        this.options = SlaveHost.makeOptions(options);
        this.connector = null;
        this.processor = new SimpleIoProcessorPool(NioProcessor.class);
        NioSocketAcceptor nioAcceptor = new NioSocketAcceptor(this.processor);
        this.acceptor = nioAcceptor;
        nioAcceptor.setReuseAddress(true);
        nioAcceptor.setBacklog(5);
        this.disposeAcceptor = true;
        this.setupAcceptor(null);
        this.acceptor.bind((SocketAddress)new InetSocketAddress(port));
    }

    public SlaveHost(ProtocolOptions options, SlaveHostCustomizer slaveHostCustomizer, SocketAddress ... socketAddresses) throws IOException {
        this.options = SlaveHost.makeOptions(options);
        this.connector = null;
        this.processor = new SimpleIoProcessorPool(NioProcessor.class);
        this.acceptor = new NioSocketAcceptor(this.processor);
        this.disposeAcceptor = true;
        this.setupAcceptor(slaveHostCustomizer);
        this.acceptor.bind(socketAddresses);
    }

    public SlaveHost(ProtocolOptions options, SocketAcceptor acceptor, SlaveHostCustomizer slaveHostCustomizer) {
        this.options = SlaveHost.makeOptions(options);
        this.connector = null;
        this.acceptor = acceptor;
        this.processor = null;
        this.disposeAcceptor = false;
        this.setupAcceptor(slaveHostCustomizer);
    }

    public SlaveHost(ProtocolOptions options, IoConnector connector, SlaveHostCustomizer slaveHostCustomizer) {
        this.options = SlaveHost.makeOptions(options);
        this.connector = connector;
        this.acceptor = null;
        this.processor = null;
        this.disposeAcceptor = false;
        this.setupConnector(slaveHostCustomizer);
    }

    private static ProtocolOptions makeOptions(ProtocolOptions options) {
        if (options == null) {
            return new ProtocolOptions();
        }
        return new ProtocolOptions(options);
    }

    private void setupConnector(SlaveHostCustomizer slaveHostCustomizer) {
        this.setup((IoService)this.connector, slaveHostCustomizer);
    }

    private void setupAcceptor(SlaveHostCustomizer slaveHostCustomizer) {
        this.setup((IoService)this.acceptor, slaveHostCustomizer);
    }

    private void setup(IoService service, SlaveHostCustomizer slaveHostCustomizer) {
        this.executor = ScheduledExportedExecutorService.newSingleThreadExportedScheduledExecutor((String)("SlaveHost/" + COUNTER.incrementAndGet()));
        switch (this.options.getMode()) {
            case RTU: {
                ModbusRtuEncoder encoder = new ModbusRtuEncoder();
                ModbusRtuDecoder decoder = new ModbusRtuDecoder(this.executor, this.options.getInterFrameDelay(), TimeUnit.MILLISECONDS);
                service.getFilterChain().addLast("modbusPdu", (IoFilter)new ModbusRtuProtocolCodecFilter((ProtocolEncoder)encoder, decoder));
                break;
            }
            case TCP: {
                ModbusTcpEncoder encoder = new ModbusTcpEncoder();
                ModbusTcpDecoder decoder = new ModbusTcpDecoder();
                service.getFilterChain().addLast("modbusPdu", (IoFilter)new ProtocolCodecFilter((ProtocolEncoder)encoder, (ProtocolDecoder)decoder));
            }
        }
        service.getFilterChain().addLast("modbus", (IoFilter)new ModbusSlaveProtocolFilter());
        if (slaveHostCustomizer != null) {
            slaveHostCustomizer.customizeFilterChain(service.getFilterChain());
        }
        service.setHandler((IoHandler)new IoHandlerAdapter(){

            public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
                logger.info("Uncaught exception", cause);
                SlaveHost.this.handleExceptionCaught(session, cause);
            }

            public void sessionCreated(IoSession session) throws Exception {
                logger.info("Session created: {}", (Object)session);
                SlaveHost.this.handleSessionCreated(session);
            }

            public void sessionOpened(IoSession session) throws Exception {
                logger.info("Session opened: {}", (Object)session);
                SlaveHost.this.handleSessionOpened(session);
            }

            public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
                logger.info("Session idle: {}", (Object)session);
                SlaveHost.this.handleSessionIdle(session);
            }

            public void sessionClosed(IoSession session) throws Exception {
                logger.info("Session closed: {}", (Object)session);
                SlaveHost.this.handleSessionClosed(session);
            }

            public void messageReceived(IoSession session, Object message) throws Exception {
                SlaveHost.this.handleMessageReceived(session, message);
            }
        });
    }

    protected void handleExceptionCaught(IoSession session, Throwable cause) {
        session.close(true);
    }

    protected void handleMessageReceived(final IoSession session, Object message) {
        if (!(message instanceof BaseMessage)) {
            return;
        }
        BaseMessage baseMessage = (BaseMessage)message;
        Slave slave = this.slaves.get(baseMessage.getUnitIdentifier());
        if (slave == null) {
            this.handleInvalidSlave(baseMessage);
            return;
        }
        slave.handleMessage(new SessionContext(){

            @Override
            public void sendExceptionReply(BaseMessage baseMessage, int exceptionCode) {
                session.write(SlaveHost.this.makeError(baseMessage, exceptionCode));
            }

            @Override
            public void sendReadReply(BaseMessage baseMessage, int[] data, ByteOrder order) {
                session.write(SlaveHost.this.makeReadReply(baseMessage, data, order));
            }

            @Override
            public void sendReadReply(BaseMessage baseMessage, boolean[] data) {
                session.write(SlaveHost.this.makeReadReply(baseMessage, data));
            }

            @Override
            public void sendWriteReply(WriteMultiDataRequest message) {
                WriteMultiDataResponse reply = new WriteMultiDataResponse(message.getTransactionId(), message.getUnitIdentifier(), message.getFunctionCode(), message.getStartAddress(), message.getNumRegisters());
                session.write((Object)reply);
            }

            @Override
            public void sendWriteReply(WriteSingleDataRequest message) {
                WriteSingleDataResponse reply = new WriteSingleDataResponse(message.getTransactionId(), message.getUnitIdentifier(), message.getFunctionCode(), message.getAddress(), message.getData());
                session.write((Object)reply);
            }
        }, baseMessage);
    }

    protected Object makeReadReply(BaseMessage baseMessage, boolean[] data) {
        byte[] reply = new byte[data.length / 8 + 1];
        int i = 0;
        while (i < data.length) {
            if (data[i]) {
                reply[i / 8] = (byte)(reply[i / 8] | 1 << i % 8);
            }
            ++i;
        }
        return new ReadResponse(baseMessage.getTransactionId(), baseMessage.getUnitIdentifier(), baseMessage.getFunctionCode(), IoBuffer.wrap((byte[])reply));
    }

    protected Object makeReadReply(BaseMessage baseMessage, int[] data, ByteOrder order) {
        IoBuffer reply = IoBuffer.allocate((int)(data.length * 2));
        reply.order(order);
        int i = 0;
        while (i < data.length) {
            reply.putUnsignedShort(data[i]);
            ++i;
        }
        reply.flip();
        return new ReadResponse(baseMessage.getTransactionId(), baseMessage.getUnitIdentifier(), baseMessage.getFunctionCode(), reply);
    }

    protected Object makeError(BaseMessage baseMessage, int exceptionCode) {
        return new ErrorResponse(baseMessage.getTransactionId(), baseMessage.getUnitIdentifier(), baseMessage.getFunctionCode(), (byte)exceptionCode);
    }

    protected void handleInvalidSlave(BaseMessage baseMessage) {
    }

    protected void handleSessionClosed(IoSession session) {
    }

    protected void handleSessionIdle(IoSession session) {
        session.close(true);
    }

    protected void handleSessionCreated(IoSession session) {
    }

    protected void handleSessionOpened(IoSession session) {
        Integer idle = this.options.getReadTimeout();
        if (idle != null && idle > 0) {
            session.getConfig().setIdleTime(IdleStatus.READER_IDLE, idle.intValue());
        }
    }

    public void dispose() {
        if (this.disposeAcceptor) {
            this.acceptor.dispose();
        }
        if (this.processor != null) {
            this.processor.dispose();
        }
        this.executor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlaveHandle registerSlave(final Slave slave, final int slaveId) {
        Slave oldSlave;
        if (slaveId <= 0 || slaveId > 255) {
            throw new IllegalArgumentException(String.format("slaveId must be between 0 and 255", new Object[0]));
        }
        SlaveHost slaveHost = this;
        synchronized (slaveHost) {
            oldSlave = this.slaves.put(slaveId, slave);
        }
        if (oldSlave != null) {
            oldSlave.dispose();
        }
        return new SlaveHandle(){

            @Override
            public void dispose() {
                SlaveHost.this.unregisterSlave(slave, slaveId);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterSlave(Slave slave, int slaveId) {
        SlaveHost slaveHost = this;
        synchronized (slaveHost) {
            if (this.slaves.get(slaveId) != slave) {
                return;
            }
            this.slaves.remove(slaveId);
        }
        slave.dispose();
    }

    public static interface SlaveHostCustomizer {
        public void customizeFilterChain(DefaultIoFilterChainBuilder var1);
    }
}

