/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.ngp.common.mc.handshake;

import java.util.Map;
import org.eclipse.scada.protocol.ngp.common.ChainConfigurator;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.AbstractHandshake;
import org.eclipse.scada.protocol.ngp.common.mc.handshake.HandshakeContext;

public class SslFeatureHandshake
extends AbstractHandshake {
    @Override
    public void request(HandshakeContext context, Map<String, String> helloProperties) {
        if (context.getProtocolConfiguration().getSslContextFactory() != null) {
            helloProperties.put("requestSsl", "true");
        } else if (context.getProtocolConfiguration().isSslRequired()) {
            throw new IllegalStateException("SSL is required by the client but not configured");
        }
    }

    @Override
    public void handshake(HandshakeContext context, Map<String, String> helloProperties, Map<String, String> acceptedProperties) throws Exception {
        if (context.getProtocolConfiguration().getSslContextFactory() == null) {
            if (context.getProtocolConfiguration().isSslRequired()) {
                throw new IllegalStateException("Server requires SSL");
            }
            return;
        }
        if (!SslFeatureHandshake.getBoolean(helloProperties, "requestSsl", Boolean.FALSE).booleanValue()) {
            return;
        }
        acceptedProperties.put("useSsl", "true");
    }

    @Override
    public void apply(HandshakeContext context, Map<String, String> acceptedProperties) throws Exception {
        if (!SslFeatureHandshake.getBoolean(acceptedProperties, "useSsl", Boolean.FALSE).booleanValue()) {
            if (context.getProtocolConfiguration().isSslRequired()) {
                throw new IllegalStateException("SSL required by the client, but not supported by the server");
            }
            return;
        }
        new ChainConfigurator(context.getSession()).startSsl(!context.isClientMode(), context.isClientMode());
    }

    @Override
    public void postApply(HandshakeContext context, Map<String, String> acceptedProperties) throws Exception {
    }

    @Override
    public void sessionStarted(HandshakeContext context, Map<String, String> acceptedProperties) throws Exception {
    }
}

