/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.dave;

import java.util.LinkedList;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestWrapper;
import org.eclipse.scada.protocol.dave.DaveCommandCodes;
import org.eclipse.scada.protocol.dave.DaveConnectionEstablishedMessage;
import org.eclipse.scada.protocol.dave.DaveGenericMessage;
import org.eclipse.scada.protocol.dave.DaveMessage;
import org.eclipse.scada.protocol.dave.DaveReadRequest;
import org.eclipse.scada.protocol.dave.DaveReadResult;
import org.eclipse.scada.protocol.dave.DaveWriteRequest;
import org.eclipse.scada.protocol.iso8073.DataTPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaveFilter
extends IoFilterAdapter {
    private static final byte PACKET_START_MAGIC = 50;
    private static final Logger logger = LoggerFactory.getLogger(DaveFilter.class);

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        logger.info("Sending hello");
        byte[] byArray = new byte[16];
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[5] = 8;
        byArray[8] = -16;
        byArray[11] = 1;
        byArray[13] = 1;
        byArray[14] = -1;
        byArray[15] = -1;
        byte[] data = byArray;
        IoBuffer buffer = IoBuffer.allocate((int)0).setAutoExpand(true);
        buffer.put((byte)50);
        buffer.put((byte)1);
        buffer.put(data);
        buffer.flip();
        session.write((Object)new DataTPDU(buffer));
        nextFilter.sessionOpened(session);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        int parameterStart;
        if (!(writeRequest.getMessage() instanceof DaveMessage)) {
            super.filterWrite(nextFilter, session, writeRequest);
            return;
        }
        DaveMessage message = (DaveMessage)writeRequest.getMessage();
        IoBuffer data = IoBuffer.allocate((int)0).setAutoExpand(true);
        if (message instanceof DaveReadRequest) {
            this.encodeHeader(message, data, (byte)1);
            parameterStart = data.position();
            this.encodeReadRequests((DaveReadRequest)message, data);
            int parameterEnd = data.position();
            this.finishEncode(data, (short)(parameterEnd - parameterStart), (short)0);
        } else if (message instanceof DaveWriteRequest) {
            this.encodeHeader(message, data, (byte)1);
            parameterStart = data.position();
            this.encodeWriteRequestsParameters((DaveWriteRequest)message, data);
            int parameterEnd = data.position();
            int dataStart = data.position();
            this.encodeWriteRequestsData((DaveWriteRequest)message, data);
            int dataEnd = data.position();
            this.finishEncode(data, (short)(parameterEnd - parameterStart), (short)(dataEnd - dataStart));
        }
        data.flip();
        final DataTPDU pdu = new DataTPDU(data);
        this.filterWrite(nextFilter, session, (WriteRequest)new WriteRequestWrapper(writeRequest){

            public Object getMessage() {
                return pdu;
            }
        });
    }

    private void encodeWriteRequestsData(DaveWriteRequest message, IoBuffer data) {
        for (DaveWriteRequest.Request request : message.getRequests()) {
            if (request.getType() == DaveReadRequest.Request.AddressType.BIT) {
                byte[] byArray = new byte[2];
                byArray[1] = 3;
                data.put(byArray);
            } else {
                byte[] byArray = new byte[2];
                byArray[1] = 4;
                data.put(byArray);
            }
            IoBuffer requestData = request.getData();
            data.putShort((short)(request.getCount() * this.startFactor(request)));
            data.put(requestData);
        }
    }

    private void encodeWriteRequestsParameters(DaveWriteRequest message, IoBuffer data) {
        data.put(DaveCommandCodes.DAVE_WRITE.getCommandCode());
        data.put((byte)message.getRequests().size());
        for (DaveWriteRequest.Request request : message.getRequests()) {
            this.encodeAddress(data, request);
        }
    }

    private short startFactor(DaveReadRequest.Request request) {
        switch (request.getType()) {
            case BIT: {
                return 1;
            }
            case BYTE: {
                return 8;
            }
            case WORD: {
                return 16;
            }
        }
        return 8;
    }

    private void encodeReadRequests(DaveReadRequest message, IoBuffer data) {
        data.put(DaveCommandCodes.DAVE_READ.getCommandCode());
        data.put((byte)message.getRequests().size());
        for (DaveReadRequest.Request request : message.getRequests()) {
            this.encodeAddress(data, request);
        }
    }

    private void encodeAddress(IoBuffer data, DaveReadRequest.Request request) {
        data.put((byte)18);
        data.put((byte)10);
        data.put((byte)16);
        data.put(request.getType().getType());
        data.putShort(request.getCount());
        data.putShort(request.getBlock());
        data.put(request.getArea());
        data.putMediumInt(request.getStart() * this.startFactor(request));
    }

    private void finishEncode(IoBuffer data, short parameterLen, short dataLen) {
        data.putShort(6, parameterLen);
        data.putShort(8, dataLen);
    }

    private void encodeHeader(DaveMessage message, IoBuffer data, byte type) {
        data.put((byte)50);
        data.put(type);
        data.put((byte)0);
        data.put((byte)0);
        data.putShort((short)0);
        data.putShort((short)0);
        data.putShort((short)0);
        if (type == 2 || type == 3) {
            data.put((byte)0);
            data.put((byte)0);
        }
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (!(message instanceof DataTPDU)) {
            return;
        }
        DataTPDU data = (DataTPDU)message;
        IoBuffer buffer = data.getData();
        DaveMessage daveMessage = this.decode(buffer);
        if (daveMessage != null) {
            nextFilter.messageReceived(session, (Object)daveMessage);
        }
    }

    private DaveMessage decode(IoBuffer buffer) {
        byte start = buffer.get();
        if (start != 50) {
            throw new IllegalStateException(String.format("packet header must be 0x32 but is %02x", start));
        }
        byte type = buffer.get();
        logger.debug("Type: {}");
        buffer.get();
        buffer.get();
        buffer.getUnsignedShort();
        int plen = buffer.getUnsignedShort();
        int dlen = buffer.getUnsignedShort();
        if (type == 2 || type == 3) {
            int errorInfo = buffer.getUnsignedShort();
            logger.debug("Error info: {}", (Object)errorInfo);
        } else {
            boolean errorInfo = false;
        }
        IoBuffer parameters = IoBuffer.allocate((int)plen);
        IoBuffer data = IoBuffer.allocate((int)dlen);
        buffer.get(parameters.array());
        buffer.get(data.array());
        logger.debug("plen: {}, dlen: {}, remain: {}", new Object[]{plen, dlen, buffer.remaining()});
        logger.debug("Parameters: {}", (Object)parameters);
        logger.debug("Data: {}", (Object)data);
        if (parameters.remaining() == 2 && parameters.get(0) == 4) {
            return this.decodeDataReadReply(parameters, data);
        }
        if (parameters.remaining() == 8 && parameters.get(0) == -16) {
            int maxPDU = parameters.getUnsignedShort(6);
            return new DaveConnectionEstablishedMessage(maxPDU);
        }
        return new DaveGenericMessage(parameters, data);
    }

    private DaveMessage decodeDataReadReply(IoBuffer parameters, IoBuffer data) {
        parameters.get();
        int count = parameters.getUnsigned();
        LinkedList<DaveReadResult.Result> result = new LinkedList<DaveReadResult.Result>();
        int i = 0;
        while (i < count) {
            short q = data.getUnsigned();
            if (q == 255 && data.remaining() > 4) {
                byte type = data.get();
                int len = data.getUnsignedShort();
                if (type == 4) {
                    len >>= 3;
                }
                IoBuffer valueData = IoBuffer.allocate((int)len);
                data.get(valueData.array());
                result.add(new DaveReadResult.Result(valueData));
                if (len % 2 != 0 && data.remaining() > 0) {
                    data.get();
                }
            } else if (q != 255) {
                result.add(new DaveReadResult.Result(q));
            }
            ++i;
        }
        return new DaveReadResult(result);
    }
}

