/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.utils;

import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferLoader {
    private static final Logger logger = LoggerFactory.getLogger(BufferLoader.class);

    public static List<IoBuffer> loadBuffersFromResource(Class<?> clazz, String resourceName) throws IOException {
        logger.debug("Loading buffer - {}", (Object)resourceName);
        URL url = Resources.getResource(clazz, (String)resourceName);
        return (List)Resources.readLines((URL)url, (Charset)Charset.forName("UTF-8"), (LineProcessor)new LineProcessor<List<IoBuffer>>(){
            private final List<IoBuffer> result = new LinkedList<IoBuffer>();
            private IoBuffer buffer = null;

            protected void pushBuffer() {
                if (this.buffer == null) {
                    return;
                }
                this.buffer.flip();
                this.result.add(this.buffer);
                this.buffer = null;
            }

            public boolean processLine(String line) throws IOException {
                if ((line = line.replaceAll("#.*", "")).isEmpty()) {
                    this.pushBuffer();
                    return true;
                }
                String[] toks = line.split("\\s+");
                if (toks.length <= 0) {
                    this.pushBuffer();
                    return true;
                }
                if (this.buffer == null) {
                    this.buffer = IoBuffer.allocate((int)0);
                    this.buffer.setAutoExpand(true);
                }
                String[] stringArray = toks;
                int n = toks.length;
                int n2 = 0;
                while (n2 < n) {
                    String tok = stringArray[n2];
                    this.buffer.put(Byte.parseByte(tok, 16));
                    ++n2;
                }
                return true;
            }

            public List<IoBuffer> getResult() {
                this.pushBuffer();
                return this.result;
            }
        });
    }
}

