/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.modbus.message;

import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.protocol.modbus.Constants;
import org.eclipse.scada.protocol.modbus.message.BaseMessage;

public class WriteSingleDataRequest
extends BaseMessage {
    private static final byte[] TRUE;
    private static final byte[] FALSE;
    private final int address;
    private final byte[] value;

    static {
        byte[] byArray = new byte[2];
        byArray[0] = -1;
        TRUE = byArray;
        FALSE = new byte[2];
    }

    public WriteSingleDataRequest(int transactionId, byte unitIdentifier, byte functionCode, int address, int value) {
        this(transactionId, unitIdentifier, functionCode, address, value, Constants.DEFAULT_BYTE_ORDER);
    }

    public WriteSingleDataRequest(int transactionId, byte unitIdentifier, byte functionCode, int address, byte[] data) {
        super(transactionId, unitIdentifier, functionCode);
        this.address = address;
        this.value = data;
    }

    public WriteSingleDataRequest(int transactionId, byte unitIdentifier, byte functionCode, int address, int value, ByteOrder byteOrder) {
        super(transactionId, unitIdentifier, functionCode);
        this.address = address;
        this.value = new byte[2];
        IoBuffer bb = IoBuffer.wrap((byte[])this.value);
        bb.order(byteOrder).putUnsignedShort(value);
    }

    public WriteSingleDataRequest(int transactionId, byte unitIdentifier, byte functionCode, int address, boolean value) {
        super(transactionId, unitIdentifier, functionCode);
        this.address = address;
        this.value = value ? TRUE : FALSE;
    }

    public int getAddress() {
        return this.address;
    }

    public byte[] getData() {
        return this.value;
    }

    public boolean isTrue() {
        return Arrays.equals(this.value, TRUE);
    }

    public boolean isFalse() {
        return Arrays.equals(this.value, FALSE);
    }
}

