/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.iso8073;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.filterchain.IoFilterAdapter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestWrapper;
import org.eclipse.scada.protocol.iso8073.DataTPDU;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COTPFilter
extends IoFilterAdapter {
    private static final Logger logger = LoggerFactory.getLogger(COTPFilter.class);
    private static final byte COMMAND_CONNECT_CONFIRM = 13;
    private static final byte COMMAND_DATA = 15;
    private final int rack;
    private final byte slot;

    public COTPFilter(int rack, byte slot) {
        this.rack = rack;
        this.slot = slot;
    }

    public void sessionOpened(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        logger.debug("Session opened: {}", (Object)session);
        IoBuffer buffer = IoBuffer.allocate((int)1);
        buffer.setAutoExpand(true);
        byte[] byArray = new byte[18];
        byArray[0] = 17;
        byArray[1] = -32;
        byArray[5] = 1;
        byArray[7] = -63;
        byArray[8] = 2;
        byArray[9] = 1;
        byArray[11] = -62;
        byArray[12] = 2;
        byArray[14] = 1;
        byArray[15] = -64;
        byArray[16] = 1;
        byArray[17] = 9;
        buffer.put(byArray);
        buffer.put(13, (byte)(this.rack + 1));
        buffer.put(14, this.slot);
        buffer.flip();
        session.write((Object)buffer);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        if (writeRequest.getMessage() instanceof DataTPDU) {
            logger.debug("Filter as DT: {}", (Object)writeRequest);
            this.handleDT(nextFilter, session, writeRequest);
        } else {
            nextFilter.filterWrite(session, writeRequest);
        }
    }

    private void handleDT(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) {
        DataTPDU userData = (DataTPDU)writeRequest.getMessage();
        final IoBuffer data = IoBuffer.allocate((int)(userData.getData().remaining() + 3));
        data.put((byte)2);
        data.put((byte)-16);
        data.put((byte)-128);
        data.put(userData.getData());
        data.flip();
        nextFilter.filterWrite(session, (WriteRequest)new WriteRequestWrapper(writeRequest){

            public Object getMessage() {
                return data;
            }
        });
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, WriteRequest writeRequest) throws Exception {
        logger.debug("Message sent: {} -> {}", (Object)session, (Object)writeRequest);
        nextFilter.messageSent(session, writeRequest);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        logger.debug("Message received: {} - {}", new Object[]{session, message});
        if (!(message instanceof IoBuffer)) {
            return;
        }
        IoBuffer buffer = (IoBuffer)message;
        short command = (short)(buffer.getUnsigned(1) >> 4);
        logger.debug("Command: {}", (Object)command);
        if (command == 13) {
            this.handleConnectConfirm(nextFilter, session, buffer);
        } else if (command == 15) {
            this.handleData(nextFilter, session, buffer);
        } else {
            logger.warn("Unknown command: {}", (Object)command);
        }
    }

    private void handleData(IoFilter.NextFilter nextFilter, IoSession session, IoBuffer buffer) {
        buffer.getUnsigned();
        buffer.getUnsigned();
        buffer.getUnsigned();
        nextFilter.messageReceived(session, (Object)new DataTPDU(buffer));
    }

    private void handleConnectConfirm(IoFilter.NextFilter nextFilter, IoSession session, IoBuffer buffer) {
        nextFilter.sessionOpened(session);
    }
}

