/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.dave;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.protocol.dave.DaveMessage;
import org.eclipse.scada.protocol.dave.DaveReadRequest;

public class DaveWriteRequest
extends DaveMessage {
    private final Collection<Request> requests = new LinkedList<Request>();

    public void addRequest(Request request) {
        this.requests.add(request);
    }

    public Collection<Request> getRequests() {
        return Collections.unmodifiableCollection(this.requests);
    }

    public static class BitRequest
    extends Request {
        private final IoBuffer data;

        public BitRequest(byte area, short block, short start, boolean[] bits) {
            super(DaveReadRequest.Request.AddressType.BIT, area, block, start, (short)bits.length);
            this.data = IoBuffer.allocate((int)bits.length);
            int i = 0;
            while (i < bits.length) {
                this.data.put(bits[i] ? (byte)1 : 0);
                ++i;
            }
            this.data.flip();
        }

        public BitRequest(byte area, short block, short start, boolean bit) {
            super(DaveReadRequest.Request.AddressType.BIT, area, block, start, (short)1);
            this.data = IoBuffer.allocate((int)1);
            this.data.put(bit ? (byte)1 : 0);
            this.data.flip();
        }

        @Override
        public IoBuffer getData() {
            return this.data;
        }
    }

    public static class ByteRequest
    extends Request {
        private final IoBuffer data;

        public ByteRequest(byte area, short block, short start, IoBuffer data) {
            super(DaveReadRequest.Request.AddressType.BYTE, area, block, start, (short)data.remaining());
            this.data = data;
        }

        public ByteRequest(byte area, short block, short start, byte[] data) {
            super(DaveReadRequest.Request.AddressType.BYTE, area, block, start, (short)data.length);
            this.data = IoBuffer.wrap((byte[])data);
        }

        public ByteRequest(byte area, short block, short start, byte data) {
            super(DaveReadRequest.Request.AddressType.BYTE, area, block, start, (short)1);
            this.data = IoBuffer.allocate((int)1);
            this.data.put(data);
            this.data.flip();
        }

        @Override
        public IoBuffer getData() {
            return this.data;
        }
    }

    public static abstract class Request
    extends DaveReadRequest.Request {
        public Request(DaveReadRequest.Request.AddressType type, byte area, short block, short start, short count) {
            super(type, area, block, start, count);
        }

        public abstract IoBuffer getData();
    }
}

