/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.arduino;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecException;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.eclipse.scada.protocol.arduino.CommandCode;
import org.eclipse.scada.protocol.arduino.messages.CommonMessage;
import org.eclipse.scada.protocol.arduino.messages.ConfigurationMessage;
import org.eclipse.scada.protocol.arduino.messages.DataMessage;
import org.eclipse.scada.protocol.arduino.messages.WriteRequestMessage;

public class ArduinoCodec
implements ProtocolEncoder,
ProtocolDecoder {
    private final Charset charset = Charset.forName("ISO-8859-1");

    public void decode(IoSession session, IoBuffer data, ProtocolDecoderOutput output) throws Exception {
        short magic = data.getShort();
        byte version = data.get();
        int sequence = data.getInt();
        byte commandCode = data.get();
        if (magic != 1202) {
            throw new ProtocolCodecException(String.format("Magic code should be 1202 but is %s", magic));
        }
        if (version != 1) {
            throw new ProtocolCodecException(String.format("Version should be %s but is %s", 1, version));
        }
        this.decodeMessage(sequence, commandCode, data, output);
    }

    private void decodeMessage(int sequence, byte commandCode, IoBuffer data, ProtocolDecoderOutput output) throws ProtocolCodecException {
        switch (commandCode) {
            case 3: {
                this.decodeResponseConfiguration(data, output, sequence);
                break;
            }
            case 5: {
                this.decodeResponseData(data, output, sequence);
            }
        }
    }

    private void decodeResponseData(IoBuffer data, ProtocolDecoderOutput output, int sequence) throws ProtocolCodecException {
        int nin = data.get();
        Object[] vars = new Object[nin];
        int i = 0;
        while (i < nin) {
            vars[i] = this.decodeData(data);
            ++i;
        }
        DataMessage msg = new DataMessage(sequence, CommandCode.RESPOND_DATA, vars);
        output.write((Object)msg);
    }

    private Object decodeData(IoBuffer data) throws ProtocolCodecException {
        data.order(ByteOrder.LITTLE_ENDIAN);
        byte dataType = data.get();
        switch (dataType) {
            case 0: {
                return null;
            }
            case 1: {
                if (data.get() != 0) {
                    return true;
                }
                return false;
            }
            case 2: {
                return data.getInt();
            }
            case 3: {
                return data.getLong();
            }
            case 4: {
                return Float.valueOf(data.getFloat());
            }
        }
        throw new ProtocolCodecException(String.format("Data type %02x is unknown", dataType));
    }

    private void decodeResponseConfiguration(IoBuffer data, ProtocolDecoderOutput output, int sequence) {
        byte nin = data.get();
        byte nout = data.get();
        Map[] parameters = new Map[nin + nout];
        while (data.hasRemaining()) {
            byte type = data.get();
            byte signalNumber = data.get();
            byte len = data.get();
            byte[] dataBuffer = new byte[len];
            data.get(dataBuffer);
            if (parameters[signalNumber] == null) {
                parameters[signalNumber] = new HashMap();
            }
            parameters[signalNumber].put(Integer.valueOf(type), this.convertData(type, dataBuffer));
        }
        ConfigurationMessage msg = new ConfigurationMessage(sequence, CommandCode.RESPOND_CONFIGURATION, parameters);
        output.write((Object)msg);
    }

    private Object convertData(byte type, byte[] dataBuffer) {
        switch (type) {
            case 1: {
                return dataBuffer[0];
            }
            case 2: {
                return String.valueOf(this.charset.decode(ByteBuffer.wrap(dataBuffer)));
            }
        }
        return dataBuffer;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput output) throws Exception {
    }

    public void dispose(IoSession session) throws Exception {
    }

    public void encode(IoSession session, Object message, ProtocolEncoderOutput output) throws Exception {
        IoBuffer data = IoBuffer.allocate((int)0);
        data.order(ByteOrder.LITTLE_ENDIAN);
        data.setAutoExpand(true);
        if (message instanceof WriteRequestMessage) {
            this.encodeHeader(data, (CommonMessage)message);
            this.encodeWriteRequest(data, (WriteRequestMessage)message);
        } else if (message instanceof CommonMessage) {
            this.encodeHeader(data, (CommonMessage)message);
        }
        data.flip();
        output.write((Object)data);
    }

    private void encodeWriteRequest(IoBuffer data, WriteRequestMessage message) {
        data.putShort(message.getIndex());
        Object value = message.getData();
        if (value == null) {
            data.put((byte)0);
        } else if (value instanceof Boolean) {
            data.put((byte)1);
            data.put((byte)((Boolean)value != false ? 255 : 0));
        } else if (value instanceof Float || value instanceof Double) {
            data.put((byte)4);
            data.putFloat(((Number)value).floatValue());
        } else if (value instanceof Long) {
            data.put((byte)3);
            data.putLong(((Number)value).longValue());
        } else if (value instanceof Number) {
            data.put((byte)2);
            data.putInt(((Number)value).intValue());
        } else if (value instanceof String) {
            data.put((byte)2);
            data.putInt(Integer.parseInt((String)value));
        } else {
            throw new RuntimeException(String.format("Unable to write request of type %s", value.getClass()));
        }
    }

    private void encodeHeader(IoBuffer data, CommonMessage message) {
        data.putShort((short)1202);
        data.put((byte)1);
        data.putInt(message.getSequence());
        data.put(message.getCommandCode().getCommandCode());
    }
}

